/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.lenses;

import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.capabilities.LivingCapability;
import fr.wind_blade.isorropia.common.items.misc.ItemLens;
import fr.wind_blade.isorropia.common.lenses.Lens;
import fr.wind_blade.isorropia.common.network.CapabilityMessage;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.common.lib.utils.EntityUtils;

public class EnvyLens
extends Lens {
    public static final ResourceLocation ENVY = new ResourceLocation("isorropia", "textures/aspects/invidia_hud.png");
    private static final Method getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
    private static final Field getPool = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");

    public EnvyLens(ItemLens lensIn) {
        super(lensIn);
    }

    @Override
    public void handleTicks(World worldIn, EntityPlayer playerIn, boolean doubleLens) {
        Entity entity;
        if (!worldIn.field_72995_K && (entity = EntityUtils.getPointedEntity((World)worldIn, (Entity)playerIn, (double)0.0, (double)1.5, (float)5.0f, (boolean)true)) instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            LivingCapability cap = (LivingCapability)living.getCapability(Common.LIVING_CAPABILITY, null);
            if (cap.hasLooted) {
                return;
            }
            try {
                ResourceLocation lootTableLocation = (ResourceLocation)getLootTable.invoke((Object)living, new Object[0]);
                if (lootTableLocation == null) {
                    cap.hasLooted = true;
                    Common.INSTANCE.sendTo((IMessage)new CapabilityMessage((EntityLivingBase)living, cap.serializeNBT()), (EntityPlayerMP)playerIn);
                    return;
                }
                LootTableManager manager = worldIn.func_184146_ak();
                if (manager == null) {
                    return;
                }
                LootTable lootTable = manager.func_186521_a(lootTableLocation);
                if (lootTable == null) {
                    cap.hasLooted = true;
                    Common.INSTANCE.sendTo((IMessage)new CapabilityMessage((EntityLivingBase)living, cap.serializeNBT()), (EntityPlayerMP)playerIn);
                    return;
                }
                getPool.setAccessible(true);
                List pools = (List)getPool.get(lootTable);
                if (pools == null || pools.isEmpty()) {
                    cap.hasLooted = true;
                    Common.INSTANCE.sendTo((IMessage)new CapabilityMessage((EntityLivingBase)living, cap.serializeNBT()), (EntityPlayerMP)playerIn);
                    return;
                }
                ++cap.envy;
                if ((float)cap.envy > living.func_110143_aJ() * 20.0f) {
                    LootContext.Builder builder = new LootContext.Builder((WorldServer)worldIn).func_186472_a((Entity)living);
                    for (ItemStack stack : lootTable.func_186462_a(new Random(), builder.func_186471_a())) {
                        living.func_70099_a(stack, 0.0f);
                    }
                    cap.hasLooted = true;
                }
                Common.INSTANCE.sendTo((IMessage)new CapabilityMessage((EntityLivingBase)living, cap.serializeNBT()), (EntityPlayerMP)playerIn);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleRenderGameOverlay(World worldIn, EntityPlayer playerIn, ScaledResolution resolution, boolean doubleLens, float partialTicks) {
        Entity entity = EntityUtils.getPointedEntity((World)worldIn, (Entity)playerIn, (double)1.0, (double)5.0, (float)5.0f, (boolean)true);
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            LivingCapability cap = (LivingCapability)living.getCapability(Common.LIVING_CAPABILITY, null);
            if (!cap.hasLooted && resolution != null) {
                this.renderEnvyHUD(resolution, entity.func_145782_y());
            }
        }
    }

    @Override
    public void handleRenderWorldLast(World worldIn, EntityPlayer playerIn, boolean doubleLens, float partialTicks) {
    }

    @Override
    public void handleRemoval(World worldIn, EntityPlayer playerIn) {
    }

    @SideOnly(value=Side.CLIENT)
    private void renderEnvyHUD(ScaledResolution scaledResolution, int entityId) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId);
        if (entity instanceof EntityLiving) {
            double x = scaledResolution.func_78327_c() - 16.0;
            double y = scaledResolution.func_78324_d() - 16.0;
            double pourcentage = (double)((float)((LivingCapability)entity.getCapability(Common.LIVING_CAPABILITY, null)).envy / ((EntityLiving)entity).func_110143_aJ()) * 5.15;
            if (pourcentage <= 100.0) {
                double p = pourcentage * 8.0 / 100.0;
                double u = 8.0 - p;
                double i = 1.0 - pourcentage / 100.0;
                Color color = new Color(47616);
                GL11.glPushMatrix();
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ENVY);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_178994_b(1.0f, 1.0f, 1.0f, 0);
                buffer.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                buffer.func_181662_b(x, y + 8.0, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                buffer.func_181662_b(x + 16.0, y + 8.0, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                buffer.func_181662_b(x + 16.0, y, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                tessellator.func_78381_a();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder buffer1 = tessellator1.func_178180_c();
                buffer1.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer1.func_178994_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0);
                buffer1.func_181662_b(x, y + u, 0.0).func_187315_a(0.0, i).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
                buffer1.func_181662_b(x, y + 8.0, 0.0).func_187315_a(0.0, 1.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
                buffer1.func_181662_b(x + 16.0, y + 8.0, 0.0).func_187315_a(1.0, 1.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
                buffer1.func_181662_b(x + 16.0, y + u, 0.0).func_187315_a(1.0, i).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
                tessellator1.func_78381_a();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GL11.glPopMatrix();
            }
        }
    }
}

