/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.research;

import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.blocks.BlocksIS;
import fr.wind_blade.isorropia.common.celestial.CelestialBody;
import fr.wind_blade.isorropia.common.config.Config;
import fr.wind_blade.isorropia.common.curative.JellyRabbitRecipe;
import fr.wind_blade.isorropia.common.curative.OreBoarRecipe;
import fr.wind_blade.isorropia.common.entities.EntityChocow;
import fr.wind_blade.isorropia.common.entities.EntityChromaticSheep;
import fr.wind_blade.isorropia.common.entities.EntityDopeSquid;
import fr.wind_blade.isorropia.common.entities.EntityGoldenChicken;
import fr.wind_blade.isorropia.common.entities.EntityGravekeeper;
import fr.wind_blade.isorropia.common.entities.EntityGuardianPanther;
import fr.wind_blade.isorropia.common.entities.EntityHellHound;
import fr.wind_blade.isorropia.common.entities.EntityScholarChicken;
import fr.wind_blade.isorropia.common.entities.EntityTaintPig;
import fr.wind_blade.isorropia.common.items.ItemsIS;
import fr.wind_blade.isorropia.common.items.misc.ItemCat;
import fr.wind_blade.isorropia.common.research.ScanEntityResearch;
import fr.wind_blade.isorropia.common.research.ScanFidelity;
import fr.wind_blade.isorropia.common.research.ScanSun;
import fr.wind_blade.isorropia.common.research.ScanTameable;
import fr.wind_blade.isorropia.common.research.recipes.CurativeInfusionRecipe;
import fr.wind_blade.isorropia.common.research.recipes.OrganCurativeInfusionRecipe;
import fr.wind_blade.isorropia.common.research.recipes.SpecieCurativeInfusionRecipe;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ScanningManager;

public class ResearchsIS {
    private static void registerBatchAspect(AspectList aspects, Item ... items) {
        for (Item item : items) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item), (AspectList)aspects);
        }
    }

    private static AspectList getAspects(ItemStack stack) {
        AspectList list = AspectHelper.getObjectAspects((ItemStack)stack);
        return list != null ? list : new AspectList();
    }

    private static void addAspects(ItemStack stack, AspectList aspects) {
        AspectList list = ResearchsIS.getAspects(stack);
        list.add(aspects);
        ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)list);
    }

    private static void addAspects(Item item, AspectList list) {
        ResearchsIS.addAspects(new ItemStack(item), list);
    }

    private static void addAspects(Block block, AspectList list) {
        ResearchsIS.addAspects(new ItemStack(block), list);
    }

    public static void initAspects(FMLPostInitializationEvent event) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof ItemFood)) continue;
            ItemFood food = (ItemFood)item;
            ItemStack stack = new ItemStack(item);
            AspectList list = AspectHelper.getObjectAspects((ItemStack)stack);
            list = (list == null ? new AspectList() : list).add(IsorropiaAPI.HUNGER, Math.round(food.func_150905_g(stack)));
            for (int raw : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)raw).contains("raw")) continue;
                list.add(IsorropiaAPI.FLESH, food.func_150905_g(stack));
                break;
            }
            if ((double)food.func_150906_h(stack) < 0.6) {
                ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)list);
                continue;
            }
            ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)list.add(IsorropiaAPI.GLUTTONY, Math.round(food.func_150906_h(stack) * (float)food.func_150905_g(stack))));
        }
        ResearchsIS.addAspects(Items.field_179558_bo, new AspectList().add(IsorropiaAPI.FLESH, 2));
        ResearchsIS.addAspects(Items.field_151147_al, new AspectList().add(IsorropiaAPI.FLESH, 2));
        ResearchsIS.addAspects(Items.field_151082_bd, new AspectList().add(IsorropiaAPI.FLESH, 2));
        ResearchsIS.addAspects(Items.field_151076_bf, new AspectList().add(IsorropiaAPI.FLESH, 2));
        ResearchsIS.addAspects(Items.field_179561_bm, new AspectList().add(IsorropiaAPI.FLESH, 2));
        ResearchsIS.addAspects(Blocks.field_150324_C, new AspectList().add(IsorropiaAPI.SLOTH, 2));
        if (!Loader.isModLoaded((String)"forbiddenmagicre")) {
            ResearchsIS.addAspects(new ItemStack(Items.field_151073_bk), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151073_bk)).add(IsorropiaAPI.ENVY, 5));
            ResearchsIS.addAspects(new ItemStack(Blocks.field_150335_W), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150335_W)).add(IsorropiaAPI.WRATH, 15));
            ResearchsIS.addAspects(new ItemStack(Items.field_151059_bz), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151059_bz)).add(IsorropiaAPI.WRATH, 2));
            ResearchsIS.addAspects(new ItemStack(Items.field_151144_bL, 1, 4), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151144_bL, 1, 4)).add(IsorropiaAPI.WRATH, 5));
            ResearchsIS.addAspects(new ItemStack(Items.field_151141_av), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151141_av)).add(IsorropiaAPI.LUST, 5));
            ResearchsIS.addAspects(new ItemStack(Items.field_151010_B, 1, Short.MAX_VALUE), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151010_B, 1, Short.MAX_VALUE)).add(IsorropiaAPI.PRIDE, 8));
            ResearchsIS.addAspects(new ItemStack((Item)Items.field_151169_ag, 1, Short.MAX_VALUE), AspectHelper.getObjectAspects((ItemStack)new ItemStack((Item)Items.field_151169_ag, 1, Short.MAX_VALUE)).add(IsorropiaAPI.PRIDE, 8));
            ResearchsIS.addAspects(new ItemStack((Item)Items.field_151171_ah, 1, Short.MAX_VALUE), AspectHelper.getObjectAspects((ItemStack)new ItemStack((Item)Items.field_151171_ah, 1, Short.MAX_VALUE)).add(IsorropiaAPI.PRIDE, 4));
            ResearchsIS.addAspects(new ItemStack((Item)Items.field_151149_ai, 1, Short.MAX_VALUE), AspectHelper.getObjectAspects((ItemStack)new ItemStack((Item)Items.field_151149_ai, 1, Short.MAX_VALUE)).add(IsorropiaAPI.PRIDE, 4));
            ResearchsIS.addAspects(new ItemStack((Item)Items.field_151151_aj, 1, Short.MAX_VALUE), AspectHelper.getObjectAspects((ItemStack)new ItemStack((Item)Items.field_151151_aj, 1, Short.MAX_VALUE)).add(IsorropiaAPI.PRIDE, 4));
            ResearchsIS.addAspects(new ItemStack(Items.field_151156_bN), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151156_bN)).add(IsorropiaAPI.PRIDE, 10).add(IsorropiaAPI.NETHER, 20));
            ResearchsIS.addAspects(new ItemStack(Items.field_151058_ca), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151058_ca)).add(IsorropiaAPI.LUST, 5));
            ResearchsIS.addAspects(new ItemStack(Items.field_151104_aV, 1, Short.MAX_VALUE), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151104_aV, 1, Short.MAX_VALUE)).add(IsorropiaAPI.SLOTH, 10));
            ResearchsIS.addAspects(new ItemStack(Items.field_151079_bi), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151079_bi)).add(IsorropiaAPI.ENVY, 5));
            ResearchsIS.addAspects(new ItemStack(Items.field_151132_bS), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151132_bS)).add(IsorropiaAPI.ENVY, 10));
            ResearchsIS.addAspects(new ItemStack(Items.field_151105_aU), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151105_aU)).add(IsorropiaAPI.GLUTTONY, 10));
            ResearchsIS.addAspects(new ItemStack(Items.field_151106_aX), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151106_aX)).add(IsorropiaAPI.GLUTTONY, 1));
            ResearchsIS.addAspects(new ItemStack(Blocks.field_150424_aL), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150424_aL)).add(IsorropiaAPI.NETHER, 2));
            ResearchsIS.addAspects(new ItemStack(Blocks.field_150449_bY), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150449_bY)).add(IsorropiaAPI.NETHER, 5));
            ResearchsIS.addAspects(new ItemStack(Items.field_151075_bm), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151075_bm)).add(IsorropiaAPI.NETHER, 2));
            ResearchsIS.addAspects(new ItemStack(Items.field_151144_bL, 1, 1), AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151144_bL, 1, 1)).add(IsorropiaAPI.NETHER, 10));
        }
    }

    public static void init() {
        ResearchCategories.registerCategory((String)"ISORROPIA", (String)"HEDGEALCHEMY", null, (ResourceLocation)new ResourceLocation("isorropia", "textures/misc/logo.png"), (ResourceLocation)new ResourceLocation("isorropia", "textures/research/background.jpg"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("isorropia", "research/isorropia.json"));
        Config.CRYSTALS.addAll((Collection)Aspect.aspects.values().stream().map(aspect -> ThaumcraftApiHelper.makeCrystal((Aspect)aspect)).collect(Collectors.toList()));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "wheat_growth"), (CrucibleRecipe)new CrucibleRecipe("CULTIVATION", new ItemStack(Items.field_151015_O), (Object)new ItemStack(Items.field_151014_N), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.EARTH, 2).add(Aspect.WATER, 2)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "carrot_dupe"), (CrucibleRecipe)new CrucibleRecipe("CULTIVATION", new ItemStack(Items.field_151172_bF, 2), (Object)new ItemStack(Items.field_151172_bF), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.EARTH, 2).add(Aspect.WATER, 2)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "potato_dupe"), (CrucibleRecipe)new CrucibleRecipe("CULTIVATION", new ItemStack(Items.field_151174_bG, 2), (Object)new ItemStack(Items.field_151174_bG), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.EARTH, 2).add(Aspect.WATER, 2)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "beet_dupe"), (CrucibleRecipe)new CrucibleRecipe("CULTIVATION", new ItemStack(Items.field_185164_cV), (Object)new ItemStack(Items.field_185163_cU), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.EARTH, 2).add(Aspect.WATER, 2)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "melon_growth"), (CrucibleRecipe)new CrucibleRecipe("CULTIVATION", new ItemStack(Blocks.field_150440_ba), (Object)new ItemStack(Items.field_151081_bc), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.EARTH, 2).add(Aspect.WATER, 2)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "pumpkin_growth"), (CrucibleRecipe)new CrucibleRecipe("CULTIVATION", new ItemStack(Blocks.field_150423_aK), (Object)new ItemStack(Items.field_151080_bb), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.EARTH, 2).add(Aspect.WATER, 2)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "egg_incubation"), (CrucibleRecipe)new CrucibleRecipe("INCUBATION", new ItemStack(ItemsIS.itemIncubatedEgg), (Object)new ItemStack(Items.field_151110_aK), new AspectList().add(Aspect.LIFE, 5).add(Aspect.BEAST, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "meat_dupe1"), (CrucibleRecipe)new CrucibleRecipe("GROWTH", new ItemStack(Items.field_179561_bm, 2), (Object)new ItemStack(Items.field_179561_bm), new AspectList().add(Aspect.LIFE, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "meat_dupe2"), (CrucibleRecipe)new CrucibleRecipe("GROWTH", new ItemStack(Items.field_179558_bo, 2), (Object)new ItemStack(Items.field_179558_bo), new AspectList().add(Aspect.LIFE, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "meat_dupe3"), (CrucibleRecipe)new CrucibleRecipe("GROWTH", new ItemStack(Items.field_151082_bd, 2), (Object)new ItemStack(Items.field_151082_bd), new AspectList().add(Aspect.LIFE, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "meat_dupe4"), (CrucibleRecipe)new CrucibleRecipe("GROWTH", new ItemStack(Items.field_151147_al, 2), (Object)new ItemStack(Items.field_151147_al), new AspectList().add(Aspect.LIFE, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "meat_dupe5"), (CrucibleRecipe)new CrucibleRecipe("GROWTH", new ItemStack(Items.field_151076_bf, 2), (Object)new ItemStack(Items.field_151076_bf), new AspectList().add(Aspect.LIFE, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "harding1"), (CrucibleRecipe)new CrucibleRecipe("HARDNING", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_179561_bm), new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.CRAFT, 1)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "harding2"), (CrucibleRecipe)new CrucibleRecipe("HARDNING", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_179558_bo), new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.CRAFT, 1)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "harding3"), (CrucibleRecipe)new CrucibleRecipe("HARDNING", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_151082_bd), new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.CRAFT, 1)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "harding4"), (CrucibleRecipe)new CrucibleRecipe("HARDNING", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_151147_al), new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.CRAFT, 1)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("isorropia", "harding5"), (CrucibleRecipe)new CrucibleRecipe("HARDNING", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_151076_bf), new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.CRAFT, 1)));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "base_lens"), (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "ARCANELENSES@1", 20, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.FIRE, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(ItemsIS.itemBaseLens), new Object[]{"GSG", "SPS", "GSG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('P'), Blocks.field_150410_aZ}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "lens_fire"), (InfusionRecipe)new InfusionRecipe("FIRELENS", (Object)new ItemStack((Item)ItemsIS.itemFireLens), 1, new AspectList().add(Aspect.LIGHT, 40).add(Aspect.ENERGY, 20).add(Aspect.SENSES, 30), (Object)new ItemStack(ItemsIS.itemBaseLens), new Object[]{ItemsTC.amber, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE), ItemsTC.amber, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "lens_air"), (InfusionRecipe)new InfusionRecipe("AIRLENS", (Object)new ItemStack((Item)ItemsIS.itemAirLens), 1, new AspectList().add(Aspect.AURA, 15).add(Aspect.SENSES, 20), (Object)new ItemStack(ItemsIS.itemBaseLens), new Object[]{Items.field_151043_k, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR), Items.field_151043_k, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "lens_ordo"), (InfusionRecipe)new InfusionRecipe("ORDOLENS", (Object)new ItemStack((Item)ItemsIS.itemOrdoLens), 1, new AspectList().add(Aspect.MIND, 32).add(Aspect.MAGIC, 32).add(Aspect.SENSES, 20), (Object)ItemsIS.itemBaseLens, new Object[]{ItemsTC.scribingTools, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ORDER), Items.field_151122_aG, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ORDER)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "lens_envy"), (InfusionRecipe)new InfusionRecipe("ENVYLENS", (Object)new ItemStack((Item)ItemsIS.itemEnvyLens), 6, new AspectList().add(Aspect.DESIRE, 32).add(IsorropiaAPI.HUNGER, 32).add(IsorropiaAPI.LUST, 32).add(IsorropiaAPI.ENVY, 64), (Object)ItemsIS.itemBaseLens, new Object[]{Items.field_151045_i, ThaumcraftApiHelper.makeCrystal((Aspect)IsorropiaAPI.ENVY), Items.field_151121_aF, ThaumcraftApiHelper.makeCrystal((Aspect)IsorropiaAPI.ENVY)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "somatic_brain"), (InfusionRecipe)new InfusionRecipe("SOMATICBRAIN", (Object)new ItemStack((Item)ItemsIS.itemSomaticBrain), 4, new AspectList().add(Aspect.MIND, 150).add(Aspect.DESIRE, 100).add(IsorropiaAPI.ENVY, 20), (Object)BlocksTC.jarBrain, new Object[]{new ItemStack(ItemsTC.plate), new ItemStack(ItemsTC.mind, 1, 1), Blocks.field_150438_bZ, new ItemStack(ItemsTC.mind, 1, 1)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "modified_matrix"), (InfusionRecipe)new InfusionRecipe("CREATUREINFUSIONS@1", (Object)new ItemStack((Block)BlocksIS.blockModifiedMatrix), 8, new AspectList().add(Aspect.LIFE, 500).add(Aspect.CRAFT, 500).add(Aspect.MAGIC, 500).add(Aspect.BEAST, 500), (Object)BlocksTC.infusionMatrix, new Object[]{ItemsTC.salisMundus, ItemsTC.visResonator, ItemsTC.salisMundus, ItemsTC.visResonator}));
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "quicksilver_limbs"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new OrganCurativeInfusionRecipe.Builder().withOrganTarget(OrganCurativeInfusionRecipe.Organ.MUSCLE)).withModifier("generic.movementSpeed", new AttributeModifier(UUID.fromString("b3f15142-2b27-11eb-adc1-0242ac120002"), "QUICKSILVER_SPEED", 0.08, 0))).withModifier("forge.swimSpeed", new AttributeModifier(UUID.fromString("c1719976-2b27-11eb-adc1-0242ac120002"), "QUICKSILVER_SWIM_SPEED", 0.2, 0))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "jelly_rabbit"), new JellyRabbitRecipe());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "ore_boar"), new OreBoarRecipe());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "taintfeeder"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(IsorropiaAPI.HUNGER, 100).add(Aspect.PLANT, 50).add(Aspect.LIFE, 50).add(Aspect.FLUX, 45))).withComponents(Ingredient.func_193367_a((Item)ItemsTC.bottleTaint), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BlocksTC.logSilverwood)), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BlocksTC.jarVoid)), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BlocksTC.logSilverwood)))).withInstability(4)).withKnowledgeRequirement("TAINTFEEDER")).withResult(EntityTaintPig.class)).withPredicate(entity -> entity.getClass() == EntityPig.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.PIG, "Pig")}), ItemCat.createCat(ItemCat.EnumCat.PIG, "Taintfeeder"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "selfshearing"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new CurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.TOOL, 60).add(Aspect.MECHANISM, 30))).withComponents(Ingredient.func_193367_a((Item)Items.field_151097_aZ), Ingredient.func_193367_a((Item)Items.field_151132_bS))).withInstability(2)).withKnowledgeRequirement("SELFSHEARING")).withPredicate(entity -> entity instanceof IShearable)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.SHEEP, "Shearable Mob")}), ItemCat.createCat(ItemCat.EnumCat.SELFSHEARING, "Self Shearing Mob"))).withInformationNBT(new NBTTagCompound())).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "scholarschicken"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.SENSES, 60).add(Aspect.EXCHANGE, 30).add(Aspect.DARKNESS, 60))).withComponents(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 0)}), Ingredient.func_193367_a((Item)Items.field_151097_aZ))).withInstability(2)).withResult(EntityScholarChicken.class)).withKnowledgeRequirement("SCHOLARSCHICKEN")).withPredicate(entity -> entity.getClass() == EntityChicken.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.CHICKEN, "Chicken")}), ItemCat.createCat(ItemCat.EnumCat.CHICKEN, "Scholar's Chicken"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "chromaticsheep"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.SENSES, 60).add(Aspect.EXCHANGE, 30).add(Aspect.DARKNESS, 60))).withComponents(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 1)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 2)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 4)}))).withInstability(2)).withResult(EntityChromaticSheep.class)).withKnowledgeRequirement("CHROMATICSHEEP")).withPredicate(entity -> entity.getClass() == EntitySheep.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.SHEEP, "Sheep")}), ItemCat.createCat(ItemCat.EnumCat.SHEEP, "Chromatic Sheep"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "gravekeeper"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.LIGHT, 100).add(Aspect.UNDEAD, 60).add(Aspect.ORDER, 80))).withComponents(Ingredient.func_193367_a((Item)Items.field_151103_aS), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150340_R)), Ingredient.func_193367_a((Item)ItemsTC.amber), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BlocksTC.logSilverwood)))).withInstability(6)).withResult(EntityGravekeeper.class)).withKnowledgeRequirement("GRAVEKEEPERINFUSION")).withCelestialAura(CelestialBody.SUN, 50)).withPredicate(entity -> entity.getClass() == EntityOcelot.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.OCELOT, "Feline")}), ItemCat.createCat(ItemCat.EnumCat.OCELOT, "Gravekeeper"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "enderheart"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new OrganCurativeInfusionRecipe.Builder().withOrganTarget(OrganCurativeInfusionRecipe.Organ.HEART)).withAspects(new AspectList().add(IsorropiaAPI.FLESH, 60).add(Aspect.MOTION, 60).add(Aspect.ELDRITCH, 60))).withComponents(Ingredient.func_193367_a((Item)Items.field_151110_aK), Ingredient.func_193367_a((Item)Items.field_151110_aK), Ingredient.func_193367_a((Item)Items.field_151079_bi))).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.PIG, "Creature")}), ItemCat.createCat(ItemCat.EnumCat.ENDERHEART, "Ender Heart"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "shockskin"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new OrganCurativeInfusionRecipe.Builder().withOrganTarget(OrganCurativeInfusionRecipe.Organ.SKIN)).withAspects(new AspectList().add(Aspect.ENERGY, 30).add(Aspect.AVERSION, 30).add(Aspect.AIR, 5))).withComponents(Ingredient.func_193367_a((Item)Items.field_151128_bU), Ingredient.func_193367_a((Item)Items.field_151137_ax), Ingredient.func_193367_a((Item)Items.field_151128_bU), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR)}))).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.PIG, "Creature")}), ItemCat.createCat(ItemCat.EnumCat.SHOCK, "Shock Skin"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "awakened_blood"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new OrganCurativeInfusionRecipe.Builder().withOrganTarget(OrganCurativeInfusionRecipe.Organ.BLOOD)).withAspects(new AspectList().add(Aspect.LIFE, 50).add(Aspect.MIND, 50))).withComponents(Ingredient.func_193367_a((Item)Items.field_151060_bw), Ingredient.func_193367_a((Item)Items.field_151060_bw), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151153_ao)}), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BlocksTC.logSilverwood)))).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.PIG, "Creature")}), ItemCat.createCat(ItemCat.EnumCat.AWAKENED_BLOOD, "Awakened Blood"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "portability"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new OrganCurativeInfusionRecipe.Builder().withOrganTarget(OrganCurativeInfusionRecipe.Organ.VOID)).withAspects(new AspectList().add(Aspect.VOID, 50).add(Aspect.MOTION, 50))).withComponents(Ingredient.func_193367_a((Item)Items.field_151079_bi), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BlocksTC.jarNormal)))).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.PIG, "Creature")}), ItemCat.createCat(ItemCat.EnumCat.PORTABILITY, "Portability"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "diamond_skin"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new OrganCurativeInfusionRecipe.Builder().withOrganTarget(OrganCurativeInfusionRecipe.Organ.SKIN)).withModifier("generic.armor", new AttributeModifier(UUID.fromString("6bc2ebe8-2b1c-11eb-adc1-0242ac120002"), "DIAMOND_SKIN", 20.0, 0))).withModifier("generic.armorToughness", new AttributeModifier(UUID.fromString("21afc412-2b1d-11eb-adc1-0242ac120002"), "DIAMOND_SKIN_TOUGHNESS", 8.0, 0))).withAspects(new AspectList().add(Aspect.BEAST, 10).add(Aspect.PROTECT, 30).add(Aspect.CRYSTAL, 30))).withComponents(Ingredient.func_193367_a((Item)Items.field_151045_i), Ingredient.func_193367_a((Item)Items.field_151045_i), Ingredient.func_193367_a((Item)Items.field_151116_aA))).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.PIG, "Creature")}), ItemCat.createCat(ItemCat.EnumCat.DIAMOND_SKIN, "Diamond Skin"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "mooshroom"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.BEAST, 10).add(Aspect.PLANT, 30))).withComponents(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P)}), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150337_Q)), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150338_P)), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150337_Q)))).withInstability(4)).withKnowledgeRequirement("MONSTEREXCHANGE")).withResult(EntityMooshroom.class)).withPredicate(entity -> entity.getClass() == EntityCow.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.COW, "Cow")}), ItemCat.createCat(ItemCat.EnumCat.COW, "Mooshroom"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "chocow"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(IsorropiaAPI.FLESH, 30).add(Aspect.EXCHANGE, 10))).withComponents(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 3)}), Ingredient.func_193367_a((Item)Items.field_151102_aT), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 3)}), Ingredient.func_193367_a((Item)Items.field_151102_aT))).withInstability(2)).withKnowledgeRequirement("CHOCOCOW")).withResult(EntityChocow.class)).withPredicate(entity -> entity.getClass() == EntityCow.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.COW, "Cow")}), ItemCat.createCat(ItemCat.EnumCat.COW, "ChocoCow"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "goldchicken"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.CRAFT, 45).add(Aspect.DESIRE, 30).add(Aspect.METAL, 30))).withComponents(Ingredient.func_193367_a((Item)Items.field_151153_ao), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(BlocksTC.crucible)}), Ingredient.func_193367_a((Item)Items.field_151153_ao), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(BlocksTC.metalAlchemical)}))).withInstability(2)).withKnowledgeRequirement("GOLDCHICKEN")).withResult(EntityGoldenChicken.class)).withPredicate(entity -> entity.getClass() == EntityChicken.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.CHICKEN, "Chicken")}), ItemCat.createCat(ItemCat.EnumCat.CHICKEN, "GoldChicken"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "guardian_panther"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.BEAST, 30).add(Aspect.AVERSION, 30))).withComponents(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185225_H)}), Ingredient.func_193367_a((Item)Items.field_151141_av))).withInstability(2)).withKnowledgeRequirement("GUARDIAN_PANTHER")).withResult(EntityGuardianPanther.class)).withPredicate(entity -> entity.getClass() == EntityOcelot.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.OCELOT, "Ocelot")}), ItemCat.createCat(ItemCat.EnumCat.OCELOT, "panther"))).build());
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "nether_hound"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.FIRE, 30).add(Aspect.AVERSION, 30).add(Aspect.ALCHEMY, 30))).withComponents(Ingredient.func_193367_a((Item)Items.field_151129_at), Ingredient.func_193367_a((Item)Items.field_151072_bj), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE)}), Ingredient.func_193367_a((Item)Items.field_151072_bj))).withInstability(2)).withKnowledgeRequirement("NETHER_HOUND")).withResult(EntityHellHound.class)).withPredicate(entity -> entity.getClass() == EntityWolf.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.WOLF, "Dog")}), ItemCat.createCat(ItemCat.EnumCat.WOLF, "hellhound"))).build());
        Ingredient food = Ingredient.func_193368_a((Item[])new Item[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151015_O, Items.field_151034_e, Items.field_151103_aS, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N});
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "instilledfidelity"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new CurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.BEAST, 30).add(Aspect.MIND, 30))).withComponents(food, food, food)).withInstability(2)).withKnowledgeRequirement("INSTILLEDFIDELITY")).withPredicate(entity -> entity instanceof EntityTameable)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.WOLF, "Tameable Mob")}), ItemCat.createCat(ItemCat.EnumCat.LOVE, "Tamed Mob"))).build());
        if (Loader.isModLoaded((String)"thaumicbases")) {
            ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("isorropia", "research/tb_compat.json"));
            EntityDopeSquid.makeDopeSquidRecipe();
        }
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.animal", EntityAnimal.class, true, "CREATUREINFUSIONS@1", "research.scan.animal.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.taint", ITaintedMob.class, true, "CURATIVEVAT@1", "research.scan.taint.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.chicken", EntityChicken.class, false, "SIMILITUDOINFUSIONS@1", "research.scan.chicken.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.cow", EntityCow.class, false, "SIMILITUDOINFUSIONS@1", "research.scan.cow.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.pig", EntityPig.class, false, "SIMILITUDOINFUSIONS@1", "research.scan.pig.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.pigman", EntityPigZombie.class, false, "SIMILITUDOINFUSIONS@2", "research.scan.pigman.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.enderman", EntityEnderman.class, false, "SIMILITUDOINFUSIONS@3", "research.scan.enderman.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.golem", EntityIronGolem.class, false, "SIMILITUDOINFUSIONS@3", "research.scan.golem.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.villager", EntityVillager.class, false, "SIMILITUDOINFUSIONS@3", "research.scan.villager.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.sheep", EntitySheep.class, false, "SIMILITUDOINFUSIONS@3", "research.scan.sheep.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.slime", EntitySlime.class, false, "JELLYRABBIT@0", "research.scan.slime.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanEntityResearch("!scan.rabbit", EntityRabbit.class, false, "JELLYRABBIT@0", "research.scan.rabbit.text"));
        ScanningManager.addScannableThing((IScanThing)new ScanFidelity());
        ScanningManager.addScannableThing((IScanThing)new ScanTameable());
        ScanningManager.addScannableThing((IScanThing)new ScanSun());
    }
}

