/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.research.collections;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;

public class Collection {
    private String registryName;
    private final String research;
    private final ItemStack[] ingredients;

    public Collection(String research, ItemStack ... stacks) {
        this.research = research;
        this.ingredients = stacks;
    }

    public Collection(String research, Item ... items) {
        this(research, Collection.to_ingredients(items).toArray(new ItemStack[0]));
    }

    public Collection(String research, Block ... blocks) {
        this(research, Collection.to_ingredients(blocks).toArray(new ItemStack[0]));
    }

    public static void checkThing(EntityPlayer player, Collection collection, ItemStack stack) {
        for (ItemStack object : collection.getIngredients()) {
            if (object.func_77973_b() != stack.func_77973_b() || object.func_77960_j() != stack.func_77960_j()) continue;
            Collection.progress(player, collection, stack);
        }
    }

    public static void progress(EntityPlayer player, Collection collection, ItemStack stack) {
        IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
        knowledge.addResearch(collection.getRegistryName() + ":" + stack.func_77973_b().getRegistryName() + "_" + stack.func_77960_j());
        if (Collection.isFinish(player, collection)) {
            Collection.finish(player, collection);
        }
    }

    public static void finish(EntityPlayer player, Collection collection) {
        IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
        knowledge.addResearch("collection:" + collection.getRegistryName());
        for (ItemStack stack : collection.getIngredients()) {
            knowledge.removeResearch(collection.getRegistryName() + ":" + stack.func_77973_b().getRegistryName() + "_" + stack.func_77960_j());
        }
    }

    public static boolean isFinish(EntityPlayer player, Collection collection) {
        IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
        if (knowledge.isResearchKnown("collection:" + collection.getRegistryName())) {
            return true;
        }
        for (ItemStack stack : collection.getIngredients()) {
            if (knowledge.isResearchKnown("collection:" + collection.getRegistryName() + ":" + stack.func_77973_b().getRegistryName())) continue;
            return false;
        }
        return true;
    }

    private static List<ItemStack> to_ingredients(Item ... items) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (Item item : items) {
            ingredients.add(new ItemStack(item));
        }
        return ingredients;
    }

    private static List<ItemStack> to_ingredients(Block ... blocks) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (Block block : blocks) {
            ingredients.add(new ItemStack(block));
        }
        return ingredients;
    }

    public void setRegistryName(String name) {
        this.registryName = name;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public String getResearch() {
        return this.research;
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }
}

