/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.tiles;

import fr.wind_blade.isorropia.client.fx.ISFXDispatcher;
import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.blocks.BlocksIS;
import fr.wind_blade.isorropia.common.celestial.CelestialBody;
import fr.wind_blade.isorropia.common.celestial.ICelestialBody;
import fr.wind_blade.isorropia.common.curative.ICurativeEffectProvider;
import fr.wind_blade.isorropia.common.events.SoundsIR;
import fr.wind_blade.isorropia.common.libs.helpers.IsorropiaHelper;
import fr.wind_blade.isorropia.common.network.ISPacketFXInfusionSource;
import fr.wind_blade.isorropia.common.research.recipes.CurativeInfusionRecipe;
import fr.wind_blade.isorropia.common.tiles.TileVatConnector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.util.Random;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.IInfusionStabiliser;
import thaumcraft.api.crafting.IInfusionStabiliserExt;
import thaumcraft.api.crafting.IStabilizable;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.blocks.devices.BlockPedestal;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockArc;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileThaumcraft;
import thaumcraft.common.tiles.crafting.TilePedestal;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;

public class TileVat
extends TileThaumcraft
implements IAspectContainer,
ITickable,
IStabilizable {
    private static final int X_RANGE = 12;
    private static final int Y_RANGE = 10;
    private static final int Z_RANGE = 12;
    private static final short MIN_FLUX_PRESSURE = 30;
    private static final short MAX_FLUX_PRESSURE = 300;
    private static final byte FLUX_EXPUNGE_SECOND = 2;
    private int mode = 0;
    private int stabilityCap = 25;
    private float stability = 0.0f;
    private float totalInstability;
    private float startUp;
    private Map<String, SourceFX> sourceFX = new HashMap<String, SourceFX>();
    private EntityLivingBase entityContained;
    private Aspect currentlySucking;
    private Set<TilePedestal> pedestals = new HashSet<TilePedestal>();
    private boolean active = false;
    private float costMult;
    private int cycleTime = 20;
    private int curativeCount;
    private float fluxStocked;
    private float stabilityReplenish = 0.0f;
    private AspectList essentiaNeeded = new AspectList();
    private UUID entityUUID;
    private ICelestialBody celestialBody = CelestialBody.NONE;
    private float celestialAura;
    private int celestialAuraCap = 100;
    private boolean expunge;
    private int count = 0;
    private int craftCount = 0;
    private float soundExpunge = 0.0f;
    private int countDelay = this.cycleTime / 2;
    private int itemCount = 0;
    private ArrayList<BlockPos> problemBlocks = new ArrayList();
    HashMap<Block, Integer> tempBlockCount = new HashMap();
    private boolean infusing = false;
    private CurativeInfusionRecipe recipe;
    private ArrayList<ItemStack> recipeIngredients = new ArrayList();
    private NonNullList<ItemStack> stacksUsed = NonNullList.func_191196_a();
    private float celestialAuraNeeded;
    private final List<ItemStack> optionalComponents = new ArrayList<ItemStack>();
    private EntityPlayer recipePlayer = null;
    private int recipeXP;
    private ICurativeEffectProvider curativeEffect;
    private List<ItemStack> loots = new ArrayList<ItemStack>();
    public boolean checkSurroundings = true;

    public IStabilizable.EnumStability getStability() {
        if (this.stability <= -25.0f) {
            return IStabilizable.EnumStability.VERY_UNSTABLE;
        }
        if (this.stability < 0.0f) {
            return IStabilizable.EnumStability.UNSTABLE;
        }
        if (this.stability > (float)(this.stabilityCap / 2)) {
            return IStabilizable.EnumStability.VERY_STABLE;
        }
        return IStabilizable.EnumStability.STABLE;
    }

    public float getLossPerCycle() {
        return this.recipe == null ? 0.0f : (float)this.recipe.getInstability() / this.getModFromCurrentStability();
    }

    public float getModFromCurrentStability() {
        switch (this.getStability()) {
            case VERY_STABLE: {
                return 5.0f;
            }
            case STABLE: {
                return 6.0f;
            }
            case UNSTABLE: {
                return 7.0f;
            }
            case VERY_UNSTABLE: {
                return 8.0f;
            }
        }
        return 1.0f;
    }

    public void func_73660_a() {
        ++this.count;
        this.getSurroundings();
        if (this.fluxStocked > 300.0f) {
            if (this.infusing) {
                this.infusingFinish(null, true);
            }
            this.destroyMultiBlock();
        }
        this.updateStartUp();
        if (this.field_145850_b.field_72995_K) {
            this.doEffects();
        } else {
            if (this.getEntityContained() != null && this.entityContained.field_70128_L) {
                this.destroyMultiBlock();
            }
            if (!this.expunge && this.fluxStocked >= 30.0f) {
                if (this.mode == 2) {
                    this.infusingFinish(this.recipe, true);
                }
                this.expunge = true;
            }
            if (this.expunge && this.count % this.countDelay * 2 == 0) {
                this.fluxStocked -= 1.0f;
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (float)1.0f, (boolean)false);
                if (this.fluxStocked <= 0.0f) {
                    this.expunge = false;
                    this.fluxStocked = 0.0f;
                }
                this.syncTile(false);
                return;
            }
            if (this.getEntityContained() != null) {
                this.pedestals = this.getSurrondingPedestals();
                if (this.getEntityContained() != null && this.getEntityContained().func_70027_ad()) {
                    this.getEntityContained().func_70066_B();
                }
                if (this.mode == 0 && !this.expunge) {
                    this.curativeUpdate();
                    this.essentiaStep();
                } else if (this.mode == 2 && this.active && this.count % this.countDelay == 0) {
                    this.infusionCycle();
                }
            }
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_145838_q().func_176203_a(this.func_145832_p()), this.func_145838_q().func_176203_a(this.func_145832_p()), 0);
        this.func_70296_d();
    }

    private void updateStartUp() {
        this.startUp = !this.active || !this.infusing && this.expunge ? (this.startUp > 0.0f ? this.startUp - Math.max(this.startUp / 10.0f, 0.001f) : 0.0f) : (this.startUp < 1.0f ? this.startUp + Math.max(this.startUp / 10.0f, 0.001f) : 1.0f);
    }

    public int addToContainer(Aspect aspectIn, int amount) {
        if (this.mode == 0 && this.curativeEffect != null && this.getEntityContained() != null && this.curativeCount <= 0) {
            if (aspectIn == this.curativeEffect.getAspect() && amount > 0 && this.curativeEffect.effectCanApply(this.entityContained, this)) {
                this.curativeEffect.onApply(this.entityContained, this);
                this.curativeCount += this.curativeEffect.getCooldown(this.entityContained, this);
                this.curativeEffect = null;
                this.syncTile(false);
                return 0;
            }
        } else if (this.mode != 0) {
            this.essentiaNeeded.remove(aspectIn, amount);
            return 0;
        }
        return amount;
    }

    private void curativeUpdate() {
        this.essentiaNeeded = new AspectList();
        this.curativeCount = Math.max(this.curativeCount - 1, 0);
        EntityLivingBase contained = this.getEntityContained();
        if (this.field_145850_b.field_72995_K || contained == null) {
            return;
        }
        Optional<ICurativeEffectProvider> effect = IsorropiaAPI.curativeEffects.stream().filter(var -> var.effectCanApply(contained, this) && this.getEssentiaNeeded().getAmount(var.getAspect()) < 1).findFirst();
        if (effect.isPresent()) {
            this.curativeEffect = effect.get();
            this.essentiaNeeded.add(effect.get().getAspect(), 1);
        }
        if (this.doNeedEssentia()) {
            this.drawnAllEssentia();
        }
    }

    private void doEffects() {
        for (int i = 0; i < 10; ++i) {
        }
        if (this.infusing) {
            if (this.celestialAuraNeeded > 0.0f && this.canDrawnCelestialAura()) {
                ISFXDispatcher.fxAbsorption((float)this.field_174879_c.func_177958_n() + 0.5f, (double)((float)this.field_174879_c.func_177956_o() + 1.5f) + (this.celestialAuraNeeded > this.celestialAura ? 3.0 : -3.5), (float)this.field_174879_c.func_177952_p() + 0.5f, 0.49019608f, 0.5568628f, 0.63529414f, this.celestialAuraNeeded > this.celestialAura);
            }
            if (this.craftCount == 0) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundsIR.curative_infusion_start, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
            } else if (this.craftCount == 0 || this.craftCount % 65 == 0) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundsIR.curative_infusion_loop, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
            }
            ++this.craftCount;
            FXDispatcher.INSTANCE.blockRunes((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() - 2.5, (double)this.field_174879_c.func_177952_p(), this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 0.1f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 25, -0.03f);
        } else if (this.craftCount > 0) {
            this.craftCount -= 2;
            if (this.craftCount < 0) {
                this.craftCount = 0;
            }
            if (this.craftCount > 50) {
                this.craftCount = 50;
            }
        }
        if (this.active && !this.infusing) {
            if (this.expunge) {
                if (this.soundExpunge == 0.0f && this.fluxStocked * 2.0f > 5.821f) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundsIR.curative_expunge_flux_start, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                    this.soundExpunge = -1.0f;
                } else if (this.fluxStocked * 2.0f > 5.821f && (double)Minecraft.func_71410_x().field_71439_g.field_70173_aa % Math.floor(116.42f) == 0.0 || this.soundExpunge == -1.0f) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundsIR.curative_expunge_flux_loop, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                    this.soundExpunge = (float)Math.floor(116.42f) + 1.0f;
                }
            }
            if (this.fluxStocked * 2.0f <= 5.821f && this.soundExpunge == 1.0f) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundsIR.curative_expunge_flux_end, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                this.soundExpunge = 0.0f;
            }
            if (this.soundExpunge > 1.0f) {
                this.soundExpunge -= 1.0f;
            }
        }
        this.drawnIngredientParticles();
        if (this.infusing && this.stability < 0.0f && (float)this.field_145850_b.field_73012_v.nextInt(200) <= Math.abs(this.stability)) {
            float xx = (float)this.field_174879_c.func_177958_n() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 4.0f;
            float zz = (float)this.field_174879_c.func_177952_p() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 4.0f;
            int yy = this.field_174879_c.func_177956_o() + 1;
            while (!this.field_145850_b.func_175623_d(new BlockPos((double)xx, (double)yy, (double)zz))) {
                ++yy;
            }
            FXDispatcher.INSTANCE.arcLightning((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)xx, (double)yy, (double)zz, 0.8f, 0.1f, 1.0f, 0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawnIngredientParticles() {
        Iterator<String> i = this.sourceFX.keySet().iterator();
        while (i.hasNext()) {
            String fxk = i.next();
            SourceFX fx = this.sourceFX.get(fxk);
            if (fx.ticks <= 0) {
                i.remove();
                continue;
            }
            if (fx.loc.equals((Object)this.field_174879_c)) {
                Entity player = this.field_145850_b.func_73045_a(fx.color);
                if (player != null) {
                    for (int a = 0; a < 4; ++a) {
                        FXDispatcher.INSTANCE.drawInfusionParticles4(player.field_70165_t + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * player.field_70130_N), player.func_174813_aQ().field_72338_b + (double)(this.field_145850_b.field_73012_v.nextFloat() * player.field_70131_O), player.field_70161_v + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * player.field_70130_N), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p());
                    }
                }
            } else {
                TileEntity tile = this.field_145850_b.func_175625_s(fx.loc);
                if (tile instanceof TilePedestal) {
                    ItemStack is = ((TilePedestal)tile).getSyncedStackInSlot(0);
                    if (!is.func_190926_b()) {
                        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                            FXDispatcher.INSTANCE.drawInfusionParticles3((double)((float)fx.loc.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)fx.loc.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() + 1.0f), (double)((float)fx.loc.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p());
                        } else {
                            int a;
                            Item bi = is.func_77973_b();
                            int md = is.func_77952_i();
                            if (bi instanceof ItemBlock) {
                                for (a = 0; a < 4; ++a) {
                                    FXDispatcher.INSTANCE.drawInfusionParticles2((double)((float)fx.loc.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)fx.loc.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() + 1.0f), (double)((float)fx.loc.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()), Block.func_149634_a((Item)bi).func_176223_P(), md);
                                }
                            } else {
                                for (a = 0; a < 4; ++a) {
                                    FXDispatcher.INSTANCE.drawInfusionParticles1((double)((float)fx.loc.func_177958_n() + 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (double)((float)fx.loc.func_177956_o() + 1.23f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (double)((float)fx.loc.func_177952_p() + 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), this.field_174879_c.func_177984_a(), is);
                                }
                            }
                        }
                    }
                } else {
                    fx.ticks = 0;
                }
            }
            --fx.ticks;
            this.sourceFX.put(fxk, fx);
        }
    }

    public boolean onCasterRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos pos, EnumFacing side, EnumHand hand) {
        if (this.active && !this.infusing && !this.expunge) {
            if (this.infusionStart(player)) {
                this.mode = 2;
                return false;
            }
            if (player.func_70093_af() && !this.expunge && this.fluxStocked > 0.0f) {
                this.expunge = true;
            }
        }
        if (!world.field_72995_K && !this.active) {
            world.func_184133_a(null, pos, SoundsIR.curative_infusion_start, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.active = true;
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean onBlockRigthClick(EntityPlayer playerIn, EnumFacing facing, boolean master) {
        EntityLivingBase contained = this.getEntityContained();
        ItemStack stack = playerIn.func_184614_ca();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (block == BlocksIS.blockJarSoul && stack.func_77942_o() && stack.func_77978_p().func_74764_b("ENTITY_DATA")) {
            if (contained == null && playerIn.field_71071_by.func_70441_a(new ItemStack(BlocksTC.jarNormal))) {
                this.setEntityContained((EntityLivingBase)IsorropiaHelper.nbtToLiving(stack.func_77978_p(), this.field_145850_b, new BlockPos((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() - 2), (double)this.field_174879_c.func_177952_p() + 0.5)), facing.func_176734_d().func_185119_l() - 90.0f);
                ItemStack itemStack = stack;
                itemStack.func_190918_g(1);
                return true;
            }
        } else if (contained instanceof EntityLiving) {
            if (!this.loots.isEmpty()) {
                this.loots.stream().filter(loot -> !playerIn.func_191521_c(loot)).forEach(drop -> playerIn.func_71019_a(drop, false));
                this.loots.clear();
                return true;
            }
            if (block == BlocksTC.jarNormal) {
                IsorropiaHelper.playerJarEntity(playerIn, (EntityLiving)this.setEntityContained(null, 0.0f));
                return true;
            }
        } else if (block == BlocksIS.blockModifiedMatrix) {
            return false;
        }
        if (contained == null && master) {
            this.setEntityContained((EntityLivingBase)playerIn);
            return true;
        }
        if (contained instanceof EntityPlayer && playerIn.equals((Object)contained)) {
            this.setEntityContained(null);
            return true;
        }
        return false;
    }

    public boolean infusionStart(EntityPlayer player) {
        if (this.getEntityContained() == null) {
            return false;
        }
        this.essentiaNeeded = new AspectList();
        this.recipeIngredients.clear();
        this.stacksUsed.clear();
        this.pedestals.clear();
        this.pedestals = this.getSurrondingPedestals();
        this.optionalComponents.clear();
        this.updateSurroundings();
        for (TilePedestal ped : this.pedestals) {
            if (ped.func_70301_a(0).func_190926_b()) continue;
            this.recipeIngredients.add(ped.func_70301_a(0).func_77946_l());
        }
        this.recipe = IsorropiaAPI.findMatchingCreatureInfusionRecipe(this.getEntityContained(), this.recipeIngredients, player, this);
        if (this.recipe == null) {
            this.infusing = false;
            return false;
        }
        if ((double)this.costMult < 0.5) {
            this.costMult = 0.5f;
        }
        AspectList al = this.recipe.getCurrentAspect(player, this.field_145850_b, this.entityContained, this.stability, this.totalInstability, null);
        AspectList al2 = new AspectList();
        for (Aspect as : al.getAspects()) {
            if ((float)al.getAmount(as) * this.costMult <= 0.0f) continue;
            al2.add(as, (int)((float)al.getAmount(as) * this.costMult));
        }
        this.essentiaNeeded = al2;
        this.celestialAuraNeeded = this.recipe.getCelestialAura();
        this.celestialBody = this.recipe.getCelestialBody();
        this.recipePlayer = player;
        this.infusing = true;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsIR.curative_infusion_start, SoundCategory.BLOCKS, 0.5f, 1.0f);
        this.syncTile(false);
        this.func_70296_d();
        return true;
    }

    public Set<TilePedestal> getSurrondingPedestals() {
        return this.getSurrondingPedestals(12, 10, 12, 12, 10, 12);
    }

    public Set<TilePedestal> getSurrondingPedestals(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        HashSet<TilePedestal> peds = new HashSet<TilePedestal>();
        BlockPos vat_pos = this.func_174877_v();
        Iterable blocks = BlockPos.func_191531_b((int)(vat_pos.func_177958_n() - minX), (int)(vat_pos.func_177956_o() - minY), (int)(vat_pos.func_177952_p() - minZ), (int)(vat_pos.func_177958_n() + maxX), (int)(vat_pos.func_177956_o() + maxY), (int)(vat_pos.func_177952_p() + maxZ));
        for (BlockPos pos : blocks) {
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (!(te instanceof TilePedestal)) continue;
            peds.add((TilePedestal)te);
        }
        return peds;
    }

    public Set<BlockPos> getSurroundingOccults() {
        return this.getSurroundingOccults(12, 10, 12, 12, 10, 12);
    }

    public Set<BlockPos> getSurroundingOccults(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        HashSet<BlockPos> occults = new HashSet<BlockPos>();
        BlockPos curativePos = this.func_174877_v();
        Iterable blocks = BlockPos.func_191531_b((int)(curativePos.func_177958_n() - minX), (int)(curativePos.func_177956_o() - minY), (int)(curativePos.func_177952_p() - minZ), (int)(curativePos.func_177958_n() + maxX), (int)(curativePos.func_177956_o() + maxY), (int)(curativePos.func_177952_p() + maxZ));
        for (BlockPos pos : blocks) {
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            if (block == null || block != Blocks.field_150465_bP && (!(block instanceof IInfusionStabiliser) || !((IInfusionStabiliser)block).canStabaliseInfusion(this.func_145831_w(), pos))) continue;
            occults.add(pos);
        }
        return occults;
    }

    private void getSurroundings() {
        HashSet<Long> stuff = new HashSet<Long>();
        this.pedestals.clear();
        this.tempBlockCount.clear();
        this.problemBlocks.clear();
        this.cycleTime = 10;
        this.stabilityReplenish = 0.0f;
        this.costMult = 1.0f;
        try {
            Long[] posArray;
            for (int xx = -8; xx <= 8; ++xx) {
                for (int zz = -8; zz <= 8; ++zz) {
                    boolean skip = false;
                    for (int yy = -3; yy <= 7; ++yy) {
                        int z;
                        int y;
                        if (xx == 0 && zz == 0) continue;
                        int x = this.field_174879_c.func_177958_n() + xx;
                        BlockPos bp = new BlockPos(x, y = this.field_174879_c.func_177956_o() - yy, z = this.field_174879_c.func_177952_p() + zz);
                        Block bi = this.field_145850_b.func_180495_p(bp).func_177230_c();
                        if (bi instanceof BlockPedestal) {
                            this.pedestals.add((TilePedestal)this.field_145850_b.func_175625_s(bp));
                        }
                        try {
                            if (bi != Blocks.field_150465_bP && (!(bi instanceof IInfusionStabiliser) || !((IInfusionStabiliser)bi).canStabaliseInfusion(this.func_145831_w(), bp))) continue;
                            stuff.add(bp.func_177986_g());
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            while (!stuff.isEmpty() && (posArray = stuff.toArray(new Long[stuff.size()])) != null && posArray[0] != null) {
                long lp = posArray[0];
                try {
                    BlockPos c1 = BlockPos.func_177969_a((long)lp);
                    int x2 = this.field_174879_c.func_177958_n() - c1.func_177958_n();
                    int z2 = this.field_174879_c.func_177952_p() - c1.func_177952_p();
                    int x3 = this.field_174879_c.func_177958_n() + x2;
                    int z3 = this.field_174879_c.func_177952_p() + z2;
                    BlockPos c2 = new BlockPos(x3, c1.func_177956_o(), z3);
                    Block sb1 = this.field_145850_b.func_180495_p(c1).func_177230_c();
                    Block sb2 = this.field_145850_b.func_180495_p(c2).func_177230_c();
                    float amt1 = 0.1f;
                    float amt2 = 0.1f;
                    if (sb1 instanceof IInfusionStabiliserExt) {
                        amt1 = ((IInfusionStabiliserExt)sb1).getStabilizationAmount(this.func_145831_w(), c1);
                    }
                    if (sb2 instanceof IInfusionStabiliserExt) {
                        amt2 = ((IInfusionStabiliserExt)sb2).getStabilizationAmount(this.func_145831_w(), c2);
                    }
                    if (sb1 == sb2 && amt1 == amt2) {
                        if (sb1 instanceof IInfusionStabiliserExt && ((IInfusionStabiliserExt)sb1).hasSymmetryPenalty(this.func_145831_w(), c1, c2)) {
                            this.stabilityReplenish -= ((IInfusionStabiliserExt)sb1).getSymmetryPenalty(this.func_145831_w(), c1);
                            this.problemBlocks.add(c1);
                        } else {
                            this.stabilityReplenish += this.calcDeminishingReturns(sb1, amt1);
                        }
                    } else {
                        this.stabilityReplenish -= Math.max(amt1, amt2);
                        this.problemBlocks.add(c1);
                    }
                    stuff.remove(c2.func_177986_g());
                }
                catch (Exception c1) {
                    // empty catch block
                }
                stuff.remove(lp);
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() instanceof BlockPillar) {
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() == BlocksTC.pillarAncient) {
                    --this.cycleTime;
                    this.costMult -= 0.1f;
                    this.stabilityReplenish -= 0.1f;
                }
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() == BlocksTC.pillarEldritch) {
                    this.cycleTime -= 3;
                    this.costMult += 0.05f;
                    this.stabilityReplenish += 0.2f;
                }
            }
            int[] xm = new int[]{-1, 1, 1, -1};
            int[] zm = new int[]{-1, -1, 1, 1};
            for (int a = 0; a < 4; ++a) {
                Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(xm[a], -3, zm[a])).func_177230_c();
                if (b == BlocksTC.matrixSpeed) {
                    --this.cycleTime;
                    this.costMult += 0.01f;
                }
                if (b != BlocksTC.matrixCost) continue;
                ++this.cycleTime;
                this.costMult -= 0.02f;
            }
            this.countDelay = this.cycleTime / 2;
            boolean apc = false;
            for (TilePedestal cc : this.pedestals) {
                boolean items = false;
                int x4 = this.field_174879_c.func_177958_n() - cc.func_174877_v().func_177958_n();
                int z4 = this.field_174879_c.func_177952_p() - cc.func_174877_v().func_177952_p();
                Block bb = this.field_145850_b.func_180495_p(cc.func_174877_v()).func_177230_c();
                if (bb == BlocksTC.pedestalEldritch) {
                    this.costMult += 0.0025f;
                }
                if (bb != BlocksTC.pedestalAncient) continue;
                this.costMult -= 0.01f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float calcDeminishingReturns(Block b, float base) {
        int c;
        float bb = base;
        int n = c = this.tempBlockCount.containsKey(b) ? this.tempBlockCount.get(b) : 0;
        if (c > 0) {
            bb *= (float)Math.pow(0.75, c);
        }
        this.tempBlockCount.put(b, c + 1);
        return bb;
    }

    private void updateSurroundings() {
        if (!this.field_145850_b.func_175707_a(this.field_174879_c.func_177982_a(-12, -10, -12), this.field_174879_c.func_177982_a(12, 10, 12))) {
            return;
        }
        Set<BlockPos> occults = this.getSurroundingOccults();
        this.cycleTime = Math.max(10, this.cycleTime);
        this.stabilityReplenish = 0.0f;
        this.costMult = 1.0f;
        this.countDelay = this.cycleTime / 2;
        int[] xm = new int[]{-1, 1, 1, -1};
        int[] zm = new int[]{-1, -1, 1, 1};
        for (int a = 0; a < 4; ++a) {
            Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(xm[a], -3, zm[a])).func_177230_c();
            if (b == BlocksTC.matrixSpeed) {
                --this.cycleTime;
                this.costMult += 0.01f;
            }
            if (b != BlocksTC.matrixCost) continue;
            ++this.cycleTime;
            this.costMult -= 0.02f;
        }
        for (TilePedestal tile : this.pedestals) {
            Block bb = this.field_145850_b.func_180495_p(tile.func_174877_v()).func_177230_c();
            if (bb == BlocksTC.pedestalEldritch) {
                this.costMult += 0.0025f;
            }
            if (bb != BlocksTC.pedestalAncient) continue;
            this.costMult -= 0.01f;
        }
        for (BlockPos pos : occults) {
            int x1 = this.field_174879_c.func_177958_n() - pos.func_177958_n();
            int z1 = this.field_174879_c.func_177952_p() - pos.func_177952_p();
            int x2 = this.field_174879_c.func_177958_n() + x1;
            int z2 = this.field_174879_c.func_177952_p() + z1;
            BlockPos c2 = new BlockPos(x2, pos.func_177956_o(), z2);
            Block sb1 = this.field_145850_b.func_180495_p(pos).func_177230_c();
            Block sb2 = this.field_145850_b.func_180495_p(c2).func_177230_c();
            float amt1 = 0.1f;
            float amt2 = 0.1f;
            if (sb1 instanceof IInfusionStabiliserExt) {
                amt1 = ((IInfusionStabiliserExt)sb1).getStabilizationAmount(this.func_145831_w(), pos);
            }
            if (sb2 instanceof IInfusionStabiliserExt) {
                amt2 = ((IInfusionStabiliserExt)sb2).getStabilizationAmount(this.func_145831_w(), c2);
            }
            if (sb1 == sb2 && amt1 == amt2) {
                this.stabilityReplenish += amt1;
                continue;
            }
            this.stabilityReplenish -= Math.max(amt1, amt2);
        }
    }

    public void infusionCycle() {
        if (this.recipe == null) {
            this.infusingFinish(null, true);
            return;
        }
        if (this.getEntityContained() == null) {
            this.destroyMultiBlock();
        }
        boolean valid = this.getEntityContained() != null;
        this.stability -= this.field_145850_b.field_73012_v.nextFloat() * this.getLossPerCycle();
        this.stability += this.stabilityReplenish;
        this.stability = Math.min(Math.max(this.stability, -100.0f), (float)this.stabilityCap);
        if (this.stability < 0.0f && (float)this.field_145850_b.field_73012_v.nextInt(1500) <= Math.abs(this.stability)) {
            this.inEvRandom();
            this.stability += 5.0f + this.field_145850_b.field_73012_v.nextFloat() * 5.0f;
            this.inResAdd();
            if (valid) {
                return;
            }
        }
        if (!valid) {
            this.infusing = false;
            this.essentiaNeeded = new AspectList();
            this.syncTile(false);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 1.0f, 0.6f);
            this.func_70296_d();
            return;
        }
        if (!this.celestialAuraStep()) {
            return;
        }
        if (!this.xpStep()) {
            return;
        }
        this.countDelay = Math.max(this.countDelay, 1);
        if (!this.essentiaStep()) {
            return;
        }
        if (!this.ingredientStep()) {
            return;
        }
        if (!this.visStep()) {
            return;
        }
        this.fluxStocked += this.recipe.getFluxRejection();
        this.infusing = false;
        this.infusingFinish(this.recipe, false);
        this.syncTile(false);
        this.func_70296_d();
    }

    public boolean celestialAuraStep() {
        if (this.celestialAuraNeeded > 0.0f) {
            if (this.celestialAura < this.celestialAuraNeeded) {
                this.drawnCelestialAura();
            } else {
                this.celestialAura -= 1.0f;
                this.celestialAuraNeeded -= 1.0f;
            }
            return false;
        }
        return true;
    }

    public boolean xpStep() {
        if (this.recipeXP > 0) {
            List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(10.0, 10.0, 10.0));
            if (!targets.isEmpty()) {
                for (EntityPlayer target : targets) {
                    if (!target.field_71075_bZ.field_75098_d && target.field_71068_ca <= 0) continue;
                    if (!target.field_71075_bZ.field_75098_d) {
                        target.func_82242_a(-1);
                    }
                    --this.recipeXP;
                    target.func_70097_a(DamageSource.field_76376_m, (float)this.field_145850_b.field_73012_v.nextInt(2));
                    Common.INSTANCE.sendToAllAround((IMessage)new ISPacketFXInfusionSource(this.field_174879_c, this.field_174879_c, target.func_145782_y()), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                    target.func_184185_a(SoundEvents.field_187659_cY, 1.0f, 2.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
                    this.countDelay = this.cycleTime;
                    return false;
                }
                Aspect[] ingEss = this.recipe.getAspects().getAspects();
                if (ingEss != null && ingEss.length > 0 && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                    Aspect as = ingEss[this.field_145850_b.field_73012_v.nextInt(ingEss.length)];
                    this.fluxStocked += 1.0f;
                    this.essentiaNeeded.add(as, 1);
                    this.stability -= 0.25f;
                    this.syncTile(false);
                    this.func_70296_d();
                }
            }
            return false;
        }
        return true;
    }

    public boolean essentiaStep() {
        if (this.essentiaNeeded.visSize() > 0) {
            if (this.doNeedEssentia()) {
                this.drawnAllEssentia();
            }
            return false;
        }
        return true;
    }

    public boolean ingredientStep() {
        if (this.recipeIngredients.isEmpty()) {
            return true;
        }
        for (int a = 0; a < this.recipeIngredients.size(); ++a) {
            for (TilePedestal pedestal : this.pedestals) {
                if (pedestal.func_70301_a(0).func_190926_b() || !ThaumcraftInvHelper.areItemStacksEqualForCrafting((ItemStack)pedestal.func_70301_a(0), (Object)this.recipeIngredients.get(a))) continue;
                if (this.itemCount == 0) {
                    this.itemCount = 5;
                    Common.INSTANCE.sendToAllAround((IMessage)new ISPacketFXInfusionSource(this.field_174879_c, pedestal.func_174877_v(), 0), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                } else if (this.itemCount-- <= 1) {
                    ItemStack is = pedestal.func_70301_a(0).func_77973_b().getContainerItem(pedestal.func_70301_a(0));
                    pedestal.func_70299_a(0, is == null || is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                    pedestal.func_70296_d();
                    pedestal.syncTile(false);
                    this.stacksUsed.add((Object)this.recipeIngredients.get(a));
                    this.recipeIngredients.remove(a);
                    this.func_70296_d();
                }
                return false;
            }
            Aspect[] ingEss = this.recipe.getAspects().getAspects();
            if (ingEss == null || ingEss.length <= 0 || this.field_145850_b.field_73012_v.nextInt(1 + a) != 0) continue;
            Aspect as = ingEss[this.field_145850_b.field_73012_v.nextInt(ingEss.length)];
            this.fluxStocked += 1.0f;
            this.essentiaNeeded.add(as, 1);
            this.stability -= 0.25f;
            this.syncTile(false);
            this.func_70296_d();
        }
        this.checkSurroundings = true;
        return false;
    }

    public boolean visStep() {
        if (this.getVis() < this.recipe.getVis()) {
            return false;
        }
        this.spendVis(this.recipe.getVis());
        return true;
    }

    public float getVis() {
        int sx = this.field_174879_c.func_177958_n() >> 4;
        int sz = this.field_174879_c.func_177952_p() >> 4;
        float vis = 0.0f;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                AuraChunk ac = AuraHandler.getAuraChunk((int)this.field_145850_b.field_73011_w.getDimension(), (int)(sx + xx), (int)(sz + zz));
                if (ac == null) continue;
                vis += ac.getVis();
            }
        }
        return vis;
    }

    public void spendVis(float vis) {
        float q = vis;
        float z = Math.max(1.0f, vis / 9.0f);
        int attempts = 0;
        while (q > 0.0f) {
            ++attempts;
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (z > q) {
                        z = q;
                    }
                    if (!((q = (float)((int)(q - AuraHandler.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(xx * 16, 0, zz * 16), (float)z, (boolean)false)))) <= 0.0f) && attempts <= 1000) continue;
                    return;
                }
            }
        }
    }

    public void inEvRandom() {
        this.fluxStocked += (float)this.field_145850_b.field_73012_v.nextInt(10);
        switch (this.field_145850_b.field_73012_v.nextInt(26)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.inEvEjectItem(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.inEvWarp();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.inEvZap(false);
                break;
            }
            case 10: 
            case 11: {
                this.inEvZap(true);
                break;
            }
            case 12: 
            case 13: {
                this.inEvEjectItem(1);
                break;
            }
            case 14: 
            case 15: {
                this.inEvEjectItem(2);
                break;
            }
            case 16: {
                this.inEvEjectItem(3);
                break;
            }
            case 17: {
                this.inEvEjectItem(4);
                break;
            }
            case 18: 
            case 19: {
                this.inEvHarm(false);
                break;
            }
            case 20: 
            case 21: {
                this.inEvEjectItem(5);
                break;
            }
            case 22: {
                this.inEvHarm(true);
                break;
            }
            case 23: {
                this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1.5f + this.field_145850_b.field_73012_v.nextFloat(), false);
                break;
            }
            case 24: 
            case 25: {
                this.invDamageEntity();
            }
        }
    }

    public void invDamageEntity() {
        if (this.entityContained != null) {
            this.entityContained.func_70097_a(DamageSource.field_76376_m, (float)this.field_145850_b.field_73012_v.nextInt(3));
        }
    }

    public void inEvZap(boolean all) {
        List targets = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(10.0, 10.0, 10.0));
        if (targets != null && !targets.isEmpty()) {
            for (EntityLivingBase target : targets) {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(this.field_174879_c, (Entity)target, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                target.func_70097_a(DamageSource.field_76376_m, (float)(4 + this.field_145850_b.field_73012_v.nextInt(4)));
                if (!all) continue;
            }
        }
    }

    public void inEvHarm(boolean all) {
        List targets = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(10.0, 10.0, 10.0));
        if (targets != null && !targets.isEmpty()) {
            for (EntityLivingBase target : targets) {
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    target.func_70690_d(new PotionEffect(PotionFluxTaint.instance, 120, 0, false, true));
                } else {
                    PotionEffect pe = new PotionEffect(PotionVisExhaust.instance, 2400, 0, true, true);
                    pe.getCurativeItems().clear();
                    target.func_70690_d(pe);
                }
                if (!all) continue;
            }
        }
    }

    public void inResAdd() {
        List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_186662_g(10.0));
        if (!targets.isEmpty()) {
            for (EntityPlayer player : targets) {
                IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
                if (knowledge.isResearchKnown("!INSTABILITY")) continue;
                knowledge.addResearch("!INSTABILITY");
                knowledge.sync((EntityPlayerMP)player);
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"got.instability")), true);
            }
        }
    }

    public void inEvWarp() {
        List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_186662_g(10.0));
        if (targets != null && !targets.isEmpty()) {
            EntityPlayer target = (EntityPlayer)targets.get(this.field_145850_b.field_73012_v.nextInt(targets.size()));
            if (this.field_145850_b.field_73012_v.nextFloat() < 0.25f) {
                ThaumcraftApi.internalMethods.addWarpToPlayer(target, 1, IPlayerWarp.EnumWarpType.NORMAL);
            } else {
                ThaumcraftApi.internalMethods.addWarpToPlayer(target, 2 + this.field_145850_b.field_73012_v.nextInt(4), IPlayerWarp.EnumWarpType.TEMPORARY);
            }
        }
    }

    public void inEvEjectItem(int type) {
        TilePedestal[] peds = this.pedestals.toArray(new TilePedestal[this.pedestals.size()]);
        for (int q = 0; q < 50 && !this.pedestals.isEmpty(); ++q) {
            Random rand = new Random();
            TilePedestal te = peds[rand.nextInt(peds.length)];
            BlockPos pos = te.func_174877_v();
            if (te.func_70301_a(0).func_190926_b()) continue;
            if (type <= 3 || type == 5) {
                InventoryUtils.dropItems((World)this.field_145850_b, (BlockPos)pos);
            } else {
                te.func_70299_a(0, ItemStack.field_190927_a);
            }
            te.func_70296_d();
            te.syncTile(false);
            if (type == 1 || type == 3) {
                this.field_145850_b.func_175656_a(pos.func_177984_a(), BlocksTC.fluxGoo.func_176223_P());
                this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.3f, 1.0f);
            } else if (type == 2 || type == 4) {
                int a = 5 + this.field_145850_b.field_73012_v.nextInt(5);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)pos, (float)a, (boolean)true);
            } else if (type == 5) {
                this.field_145850_b.func_72876_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 1.0f, false);
            }
            this.field_145850_b.func_175641_c(pos, this.field_145850_b.func_180495_p(pos).func_177230_c(), 11, 0);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(pos, pos.func_177984_a(), 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
            return;
        }
    }

    public void infusingFinish(CurativeInfusionRecipe recipe, boolean fail) {
        this.mode = 0;
        if (!fail) {
            recipe.onInfusionFinish(this);
        }
        this.infusing = false;
        this.essentiaNeeded = new AspectList();
        this.optionalComponents.clear();
        this.stacksUsed.clear();
        this.stability = 0.0f;
        this.syncTile(false);
        this.func_70296_d();
    }

    public boolean doNeedEssentia() {
        this.currentlySucking = null;
        int n = 0;
        Aspect[] aspectArray = this.essentiaNeeded.getAspects();
        int n2 = aspectArray.length;
        if (n < n2) {
            Aspect asp;
            this.currentlySucking = asp = aspectArray[n];
        }
        return this.currentlySucking != null;
    }

    public void dischargeCelestialAura() {
        this.celestialBody = CelestialBody.NONE;
        this.celestialAura = 0.0f;
    }

    public boolean drawnAllEssentia() {
        boolean drew = false;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(3).func_177967_a(enumfacing, 1));
            if (!(te instanceof TileVatConnector)) continue;
            TileVatConnector connector = (TileVatConnector)te;
            drew |= this.drawnEssentia(connector);
        }
        return drew;
    }

    public boolean drawnEssentia(TileVatConnector conn) {
        if (conn == null) {
            return false;
        }
        IEssentiaTransport te = null;
        for (EnumFacing dir : EnumFacing.values()) {
            te = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)conn.func_174877_v(), (EnumFacing)dir);
            if (te == null || te.getEssentiaAmount(dir.func_176734_d()) <= 0) continue;
            for (Aspect asp : this.essentiaNeeded.getAspects()) {
                int ess = te.takeEssentia(asp, 1, dir.func_176734_d());
                if (ess <= 0) continue;
                this.addToContainer(asp, ess);
                this.essentiaNeeded.reduce(asp, ess);
                if (this.essentiaNeeded.getAmount(asp) <= 0) {
                    this.essentiaNeeded.remove(asp);
                }
                return true;
            }
        }
        return false;
    }

    public void drawnCelestialAura() {
        if (this.getCelestialBody().equals(CelestialBody.NONE) && !this.infusing) {
            this.setType(IsorropiaHelper.getCurrentCelestialBody(this.field_145850_b));
        }
        if (this.canDrawnCelestialAura() && this.celestialAura < (float)this.celestialAuraCap) {
            this.celestialAura += this.getCelestialBody().auraDrainedFactor(this.recipePlayer, this.field_145850_b);
        }
    }

    public boolean canDrawnCelestialAura() {
        if (this.field_145850_b == null || !this.field_145850_b.func_175667_e(this.field_174879_c)) {
            return false;
        }
        return this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && this.field_145850_b.func_175678_i(this.field_174879_c.func_177981_b(2)) && !this.celestialBody.equals(CelestialBody.NONE) && this.celestialBody.canBeDrained(this.recipePlayer, this.field_145850_b);
    }

    public void destroyMultiBlock() {
        if (this.getEntityContained() != null) {
            this.killSubject();
        }
        this.createStructure();
    }

    public void createStructure() {
        BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -3, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 0, 1)).forEach(blockPos -> {
            if (!this.field_145850_b.func_175667_e((BlockPos)blockPos)) {
                return;
            }
            boolean isCenter = blockPos.func_177958_n() == this.field_174879_c.func_177958_n() && blockPos.func_177952_p() == this.field_174879_c.func_177952_p();
            int y = this.field_174879_c.func_177956_o() - blockPos.func_177956_o();
            if (isCenter) {
                if (y == 0 || y == 3) {
                    this.field_145850_b.func_175656_a((BlockPos)blockPos, BlocksTC.metalAlchemical.func_176223_P());
                } else {
                    this.field_145850_b.func_175656_a((BlockPos)blockPos, Blocks.field_150355_j.func_176223_P());
                }
            } else if (y == 0 || y == 3) {
                this.field_145850_b.func_175656_a((BlockPos)blockPos, BlocksTC.plankGreatwood.func_176223_P());
            } else {
                this.field_145850_b.func_175656_a((BlockPos)blockPos, Blocks.field_150359_w.func_176223_P());
            }
        });
    }

    public void killSubject() {
        if (this.infusing) {
            this.infusing = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.infusing ? 2.0f : 0.5f, this.infusing);
            AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)(this.infusing ? 155.0f : 50.0f), (boolean)true);
            if (this.getEntityContained() != null) {
                this.entityContained.func_70606_j(0.0f);
                if (this.entityContained instanceof EntityLiving) {
                    this.entityContained.func_70106_y();
                }
                this.setEntityContained(null, 0.0f);
            }
        } else {
            ISFXDispatcher.fluxExplosion(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        }
    }

    public EntityLivingBase getEntityContained() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.entityContained == null && this.entityUUID != null) {
            try {
                EntityLivingBase entity = this.field_145850_b.func_175644_a(EntityLivingBase.class, e -> e.func_110124_au().equals(this.entityUUID)).stream().findFirst().orElse(null);
                if (entity != null) {
                    this.setEntityContained(entity);
                    this.entityUUID = null;
                }
            }
            catch (Exception e2) {
                this.entityUUID = null;
            }
        }
        return this.entityContained;
    }

    public EntityLivingBase setEntityContained(EntityLivingBase entity) {
        return this.setEntityContained(entity, entity != null ? entity.field_70177_z : 0.0f);
    }

    public EntityLivingBase setEntityContained(EntityLivingBase entity, float rotation) {
        EntityLivingBase old = this.entityContained;
        if (!this.field_145850_b.field_72995_K) {
            this.entityContained = entity;
            if (this.entityContained != null) {
                if (this.entityContained instanceof EntityLiving) {
                    ((EntityLiving)this.entityContained).func_94061_f(true);
                }
                this.entityContained.field_70177_z = rotation;
                this.entityContained.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() - 2), (double)this.field_174879_c.func_177952_p() + 0.5);
            }
            if (old instanceof EntityLiving) {
                ((EntityLiving)old).func_94061_f(false);
            } else if (old != null && old.func_110143_aJ() > 0.0f) {
                old.func_70034_d(0.0f);
                old.field_70125_A = 0.0f;
                old.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5);
            }
        }
        return old;
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        if (!this.func_145830_o()) {
            this.func_145834_a(worldIn);
        }
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        this.mode = nbt.func_74762_e("mode");
        this.active = nbt.func_74767_n("active");
        this.startUp = nbt.func_74760_g("startUp");
        this.infusing = nbt.func_74767_n("infusing");
        this.stability = nbt.func_74760_g("stability");
        this.fluxStocked = nbt.func_74760_g("fluxStocked");
        this.celestialAura = nbt.func_74760_g("celestialAura");
        this.celestialAuraNeeded = nbt.func_74760_g("celestialAuraNeeded");
        this.expunge = nbt.func_74767_n("expunge");
        this.setType(IsorropiaAPI.getCelestialBodyByRegistryName(new ResourceLocation(nbt.func_74779_i("type"))));
        int id = nbt.func_74762_e("entityID");
        if ((this.getEntityContained() == null || this.getEntityContained().func_145782_y() != id) && id != 0 && this.field_145850_b != null) {
            this.setEntityContained((EntityLivingBase)this.field_145850_b.func_73045_a(id));
        }
        this.essentiaNeeded.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("mode", this.getMode());
        nbt.func_74757_a("active", this.isActive());
        nbt.func_74776_a("startUp", this.getStartUp());
        nbt.func_74757_a("infusing", this.isInfusing());
        nbt.func_74776_a("stability", this.stability);
        nbt.func_74776_a("fluxStocked", this.getFluxStocked());
        nbt.func_74776_a("celestialAura", this.getCelestialAura());
        nbt.func_74776_a("celestialAuraNeeded", this.getCelestialAuraNeeded());
        nbt.func_74778_a("type", this.getCelestialBody().getRegistryName().toString());
        nbt.func_74757_a("expunge", this.isExpunging());
        if (this.getEntityContained() != null) {
            nbt.func_74768_a("entityID", this.getEntityContained().func_145782_y());
        }
        this.essentiaNeeded.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        try {
            NBTTagCompound nbttagcompound1;
            int i;
            if (nbt.func_74764_b("mode")) {
                this.mode = nbt.func_74762_e("mode");
            }
            if (nbt.func_74764_b("stability")) {
                this.stability = nbt.func_74760_g("stability");
            }
            super.func_145839_a(nbt);
            NBTTagList nbttaglist = nbt.func_150295_c("recipein", 10);
            this.recipeIngredients = new ArrayList();
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                this.recipeIngredients.add(new ItemStack(nbttagcompound1));
            }
            nbttaglist = nbt.func_150295_c("stacksUsed", 10);
            this.stacksUsed = NonNullList.func_191196_a();
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                this.stacksUsed.add((Object)new ItemStack(nbttagcompound1));
            }
            this.recipeXP = nbt.func_74762_e("recipexp");
            UUID s = nbt.func_186857_a("recipeplayer");
            if (!this.field_145850_b.field_72995_K && s != null) {
                this.recipePlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(s);
            }
            this.expunge = nbt.func_74767_n("expunge");
            if (nbt.func_74764_b("recipe")) {
                this.recipe = IsorropiaAPI.creatureInfusionRecipes.get(new ResourceLocation(nbt.func_74779_i("recipe")));
            }
            if (nbt.func_74764_b("entity")) {
                this.entityUUID = nbt.func_74775_l("entity").func_186857_a("id");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound stackCompound;
        NBTTagList nbttaglist;
        super.func_189515_b(nbt);
        if (this.getEntityContained() != null) {
            NBTTagCompound entityData = new NBTTagCompound();
            if (this.getEntityContained() != null) {
                entityData.func_186854_a("id", this.getEntityContained().getPersistentID());
            }
            nbt.func_74782_a("entity", (NBTBase)entityData);
        }
        if (!this.recipeIngredients.isEmpty()) {
            nbttaglist = new NBTTagList();
            for (ItemStack stack : this.recipeIngredients) {
                if (stack.func_190926_b()) continue;
                stackCompound = new NBTTagCompound();
                stack.func_77955_b(stackCompound);
                nbttaglist.func_74742_a((NBTBase)stackCompound);
            }
            nbt.func_74782_a("recipein", (NBTBase)nbttaglist);
        }
        if (!this.stacksUsed.isEmpty()) {
            nbttaglist = new NBTTagList();
            for (ItemStack stack : this.stacksUsed) {
                if (stack.func_190926_b()) continue;
                stackCompound = new NBTTagCompound();
                stack.func_77955_b(stackCompound);
                nbttaglist.func_74742_a((NBTBase)stackCompound);
            }
            nbt.func_74782_a("stacksUsed", (NBTBase)nbttaglist);
        }
        nbt.func_74768_a("recipexp", this.recipeXP);
        if (this.recipePlayer != null) {
            nbt.func_186854_a("recipeplayer", this.recipePlayer.func_110124_au());
        }
        nbt.func_74757_a("expunge", this.expunge);
        if (this.recipe != null) {
            nbt.func_74778_a("recipe", ((ResourceLocation)IsorropiaAPI.creatureInfusionRecipes.entrySet().stream().filter(entry -> IsorropiaAPI.creatureInfusionRecipes.get(entry.getKey()) == this.recipe).findFirst().get().getKey()).toString());
        }
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getEntityContained() != null) {
            this.field_145850_b.func_72900_e((Entity)this.entityContained);
        }
    }

    public boolean doesContainerAccept(Aspect paramAspect) {
        return false;
    }

    public boolean takeFromContainer(Aspect paramAspect, int paramInt) {
        return false;
    }

    public boolean takeFromContainer(AspectList paramAspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect paramAspect, int paramInt) {
        return false;
    }

    public boolean doesContainerContain(AspectList paramAspectList) {
        return false;
    }

    public AspectList getAspects() {
        return this.getEssentiaNeeded();
    }

    public void setAspects(AspectList paramAspectList) {
    }

    public int containerContains(Aspect tag) {
        return this.essentiaNeeded.getAmount(tag);
    }

    public Aspect getSuctionType() {
        return this.currentlySucking;
    }

    public int addEssentia(Aspect aspect, int amount, EnumFacing face) {
        return amount - this.addToContainer(aspect, amount);
    }

    public void addStability() {
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getStabilityCap() {
        return this.stabilityCap;
    }

    public void setStabilityCap(int stabilityCap) {
        this.stabilityCap = stabilityCap;
    }

    public float getStartUp() {
        return this.startUp;
    }

    public void setStartUp(float startUp) {
        this.startUp = startUp;
    }

    public Map<String, SourceFX> getSourceFX() {
        return this.sourceFX;
    }

    public void setSourceFX(Map<String, SourceFX> sourceFX) {
        this.sourceFX = sourceFX;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public float getSymmetryStability() {
        return this.stabilityReplenish;
    }

    public AspectList getEssentiaNeeded() {
        return this.essentiaNeeded;
    }

    public int getCraftCount() {
        return this.craftCount;
    }

    public boolean isInfusing() {
        return this.infusing;
    }

    public EntityPlayer getRecipePlayer() {
        return this.recipePlayer;
    }

    public float getRawStability() {
        return this.stability;
    }

    public ICelestialBody getCelestialBody() {
        return this.celestialBody;
    }

    public void setType(ICelestialBody celestialBody) {
        if (!this.celestialBody.equals(celestialBody)) {
            if (!this.celestialBody.equals(CelestialBody.NONE) && !this.celestialBody.isAuraEquals(this.recipePlayer, this.field_145850_b, celestialBody)) {
                this.dischargeCelestialAura();
            }
            this.celestialBody = celestialBody;
        }
    }

    public float getCelestialAura() {
        return this.celestialAura;
    }

    public float getCelestialAuraNeeded() {
        return this.celestialAuraNeeded;
    }

    public float getFluxStocked() {
        return this.fluxStocked;
    }

    public void setFluxStocked(int fluxStocked) {
        this.fluxStocked = fluxStocked;
    }

    public UUID getEntityTag() {
        return this.entityUUID;
    }

    public void setEntityUUID(UUID entityTag) {
        this.entityUUID = entityTag;
    }

    public int getCelestialAuraCap() {
        return this.celestialAuraCap;
    }

    public void setCelestialAuraCap(int celestialAuraCap) {
        this.celestialAuraCap = celestialAuraCap;
    }

    public void setCelestialBody(ICelestialBody celestialBody) {
        this.celestialBody = celestialBody;
    }

    public void setCelestialAura(float celestialAura) {
        this.celestialAura = celestialAura;
    }

    public void setCelestialAuraNeeded(float celestialAuraNeeded) {
        this.celestialAuraNeeded = celestialAuraNeeded;
    }

    public boolean isExpunging() {
        return this.expunge;
    }

    public int getCurativeCount() {
        return this.curativeCount;
    }

    public void setCurativeCount(int curativeCount) {
        this.curativeCount = curativeCount;
    }

    public boolean isExpunge() {
        return this.expunge;
    }

    public void setExpunge(boolean expunge) {
        this.expunge = expunge;
    }

    public float getSoundExpunge() {
        return this.soundExpunge;
    }

    public void setSoundExpunge(float soundExpunge) {
        this.soundExpunge = soundExpunge;
    }

    public NonNullList<ItemStack> getStacksUsed() {
        return this.stacksUsed;
    }

    public void setStacksUsed(NonNullList<ItemStack> stacksUsed) {
        this.stacksUsed = stacksUsed;
    }

    public ICurativeEffectProvider getCurativeEffect() {
        return this.curativeEffect;
    }

    public void setCurativeEffect(ICurativeEffectProvider curativeEffect) {
        this.curativeEffect = curativeEffect;
    }

    public List<ItemStack> getLoots() {
        return this.loots;
    }

    public void setLoots(List<ItemStack> loots) {
        this.loots = loots;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public void setFluxStocked(float fluxStocked) {
        this.fluxStocked = fluxStocked;
    }

    public static class SourceFX {
        public BlockPos loc;
        public int ticks;
        public int color;
        public int entity;

        public SourceFX(BlockPos loc, int ticks, int color) {
            this.loc = loc;
            this.ticks = ticks;
            this.color = color;
        }
    }
}

