/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardLiquidAdvanced
extends ItemCardBase {
    public ItemCardLiquidAdvanced() {
        super(3, "card_liquid_advanced");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        List<FluidInfo> tanks = CrossModLoader.getAllTanks(world, target);
        if (tanks == null || tanks.size() < 1) {
            return CardState.NO_TARGET;
        }
        int i = 0;
        for (FluidInfo tank : tanks) {
            tank.write(reader, i);
            ++i;
        }
        reader.setInt("count", i);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        int count = reader.getInt("count");
        for (int i = 0; i < count; ++i) {
            this.addTankData(result, settings, reader, isServer, showLabels, i);
        }
        return result;
    }

    private void addTankData(List<PanelString> result, int settings, ICardReader reader, boolean isServer, boolean showLabels, int i) {
        if (!reader.hasField(String.format("_%dcapacity", i))) {
            return;
        }
        int capacity = reader.getInt(String.format("_%dcapacity", i));
        int amount = reader.getInt(String.format("_%damount", i));
        if ((settings & 1) > 0) {
            String name = reader.getString(String.format("_%dname", i));
            if (name.isEmpty()) {
                name = isServer ? "N/A" : I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
            }
            result.add(new PanelString("msg.ec.InfoPanelName", name, showLabels));
        }
        if ((settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelAmount", amount, "mB", showLabels));
        }
        if ((settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFree", capacity - amount, "mB", showLabels));
        }
        if ((settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", capacity, "mB", showLabels));
        }
        if ((settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", capacity == 0 ? 100.0 : (double)(amount * 100 / capacity), showLabels));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidName", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidAmount", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidFree", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidCapacity", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidPercentage", (Object[])new Object[0]), 16));
        return result;
    }
}

