/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.network;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCard
implements IMessage,
IMessageHandler<PacketCard, IMessage> {
    private NBTTagCompound tag;
    private int x;
    private int y;
    private int z;
    private int slot;
    private String className;

    public PacketCard() {
    }

    public PacketCard(ItemStack stack, BlockPos pos, int slot) {
        this.tag = ItemStackHelper.getTagCompound(stack);
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.slot = slot;
        this.className = stack.func_77973_b().getClass().getName();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readInt();
        this.className = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.className);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public IMessage onMessage(PacketCard message, MessageContext ctx) {
        TileEntity te = null;
        if (ctx.side == Side.SERVER) {
            te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
        }
        if (ctx.side == Side.CLIENT) {
            te = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
        }
        if (!(te instanceof TileEntityInfoPanel)) {
            return null;
        }
        TileEntityInfoPanel panel = (TileEntityInfoPanel)te;
        ItemStack stack = panel.func_70301_a(message.slot);
        if (!ItemCardMain.isCard(stack)) {
            return null;
        }
        if (!stack.func_77973_b().getClass().getName().equals(message.className)) {
            EnergyControl.logger.warn("Class mismatch: '{}' != '{}'", (Object)message.className, (Object)stack.func_77973_b().getClass().getName());
            return null;
        }
        stack.func_77982_d(message.tag);
        if (ctx.side == Side.CLIENT) {
            panel.resetCardData();
        }
        return null;
    }
}

