/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.websockets;

import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.websockets.SocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import java.net.URI;

public class SocketClient {
    private static EventLoopGroup group;
    private static Channel channel;

    public static void connect(String host, int port) {
        if (group == null) {
            group = new NioEventLoopGroup();
        }
        try {
            final SocketClientHandler handler = new SocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)new URI(String.format("ws://%s:%s/?token=%s&id=%s", host, port, EnergyControlConfig.webSocket.wsToken, EnergyControlConfig.webSocket.wsServerID)), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders()));
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, handler});
                }
            });
            channel = bootstrap.connect(host, port).sync().channel();
            handler.handshakeFuture().sync();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendMessage(String message) {
        if (channel == null) {
            return;
        }
        TextWebSocketFrame frame = new TextWebSocketFrame(message);
        channel.writeAndFlush((Object)frame);
    }

    public static void close() {
        if (group == null) {
            return;
        }
        if (!group.isShuttingDown()) {
            group.shutdownGracefully();
        }
    }
}

