/*
 * Decompiled with CFR 0.152.
 */
package com.warmthdawn.justenoughdrags.compact.ae2;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.fluids.client.gui.widgets.GuiFluidSlot;
import appeng.fluids.util.AEFluidStack;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class AEFluidGhostHandler<T extends AEBaseGui>
implements IGhostIngredientHandler<T> {
    private Container lastContainer;

    private static List<GuiCustomSlot> tryGetGuiSlot(AEBaseGui gui) {
        try {
            Field guiSlots = AEBaseGui.class.getDeclaredField("guiSlots");
            guiSlots.setAccessible(true);
            return (List)guiSlots.get(gui);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(T gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        FluidStack fluid = null;
        if (ingredient instanceof ItemStack) {
            ItemStack stack = ((ItemStack)ingredient).func_77946_l();
            fluid = FluidUtil.getFluidContained((ItemStack)stack);
        }
        if (ingredient instanceof FluidStack) {
            fluid = (FluidStack)ingredient;
        }
        if (fluid != null) {
            for (GuiCustomSlot slot : AEFluidGhostHandler.tryGetGuiSlot(gui)) {
                if (!(slot instanceof GuiFluidSlot) || !slot.isSlotEnabled()) continue;
                targets.add(new GhostTarget((GuiFluidSlot)slot, (GuiContainer)gui));
            }
        }
        this.lastContainer = ((AEBaseGui)gui).field_147002_h;
        return targets;
    }

    public void onComplete() {
        if (this.lastContainer != null) {
            this.lastContainer.func_75142_b();
        }
    }

    private static class GhostTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        protected final Rectangle rectangle;
        protected final GuiFluidSlot slot;

        public GhostTarget(GuiFluidSlot slot, GuiContainer gui) {
            this.rectangle = new Rectangle(slot.xPos() + gui.getGuiLeft(), slot.yPos() + gui.getGuiTop(), slot.getWidth(), slot.getHeight());
            this.slot = slot;
        }

        public Rectangle getArea() {
            return this.rectangle;
        }

        public void accept(I ingredient) {
            FluidStack fluid = null;
            if (ingredient instanceof ItemStack) {
                ItemStack stack = ((ItemStack)ingredient).func_77946_l();
                fluid = FluidUtil.getFluidContained((ItemStack)stack);
            }
            if (ingredient instanceof FluidStack) {
                fluid = ((FluidStack)ingredient).copy();
            }
            if (fluid != null) {
                this.slot.setFluidStack((IAEFluidStack)AEFluidStack.fromFluidStack((FluidStack)fluid));
            }
        }
    }
}

