/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.method.CostHelpers;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.reference.BlockReference;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.MethodWrapperPeripheral;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.executor.TaskRunner;
import org.squiddev.plethora.utils.Helpers;

public class PeripheralProvider
implements IPeripheralProvider {
    private static final Map<Class<?>, Boolean> blacklistCache = new HashMap();
    private static final Set<String> blacklistedNames = new HashSet<String>();

    public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        TileEntity te = world.func_175625_s(blockPos);
        if (te == null || te.func_145837_r()) {
            return null;
        }
        if (te instanceof IPeripheralTile && ((IPeripheralTile)te).getPeripheral(side) == null) {
            return null;
        }
        try {
            Class<?> klass = te.getClass();
            if (PeripheralProvider.isBlacklisted(klass)) {
                return null;
            }
            MethodRegistry registry = MethodRegistry.instance;
            WorldLocation location = new WorldLocation(world, blockPos);
            BlockReference reference = new BlockReference(location, world.func_180495_p(blockPos), te, side);
            IContextFactory factory = ((ContextFactory)ContextFactory.of(reference).withCostHandler(CostHelpers.getCostHandler((ICapabilityProvider)te, side))).addContext("origin", location);
            Pair<List<IMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
            if (!((List)paired.getLeft()).isEmpty()) {
                return new MethodWrapperPeripheral(Helpers.tryGetName(te).replace('.', '_'), te, paired, TaskRunner.SHARED);
            }
        }
        catch (RuntimeException e) {
            PlethoraCore.LOG.error("Error getting peripheral", (Throwable)e);
        }
        return null;
    }

    static void addToBlacklist(String klass) {
        blacklistedNames.add(klass);
    }

    private static boolean isBlacklisted(Class<?> klass) {
        Boolean cached = blacklistCache.get(klass);
        if (cached != null) {
            return cached;
        }
        String name = klass.getName();
        boolean blacklisted = blacklistedNames.contains(name) || Helpers.blacklisted(ConfigCore.Blacklist.blacklistTileEntities, name);
        blacklistCache.put(klass, blacklisted);
        return blacklisted;
    }
}

