/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.consumables;

import com.verdantartifice.thaumicwonders.common.items.base.ItemTW;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.common.lib.utils.RandomItemChooser;

public class ItemLetheWater
extends ItemTW {
    public ItemLetheWater() {
        super("lethe_water");
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && entityLiving instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityLiving;
            IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
            ResearchCategory category = this.selectCategory((EntityPlayer)player, knowledge);
            if (category == null) {
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.lethe_water.not_found"), player);
            } else {
                boolean success = knowledge.addKnowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, category, -IPlayerKnowledge.EnumKnowledgeType.THEORY.getProgression());
                if (success) {
                    player.func_71023_q(25);
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.lethe_water.forgot"), player);
                }
            }
            if (worldIn.field_73012_v.nextBoolean()) {
                worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 20);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                ItemStack bottle = new ItemStack(Items.field_151069_bo);
                if (!player.field_71071_by.func_70441_a(bottle)) {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, player.field_70165_t, player.field_70163_u, player.field_70161_v, bottle));
                }
            }
        }
        return stack;
    }

    @Nullable
    protected ResearchCategory selectCategory(EntityPlayer player, IPlayerKnowledge knowledge) {
        ArrayList<CategoryEntry> selectionList = new ArrayList<CategoryEntry>();
        for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
            int count = knowledge.getKnowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, category);
            if (count <= 0) continue;
            selectionList.add(new CategoryEntry(category, count));
        }
        if (selectionList.size() <= 0) {
            return null;
        }
        RandomItemChooser ric = new RandomItemChooser();
        CategoryEntry selected = (CategoryEntry)ric.chooseOnWeight(selectionList);
        if (selected == null) {
            return null;
        }
        return selected.category;
    }

    protected static class CategoryEntry
    implements RandomItemChooser.Item {
        public ResearchCategory category;
        public int weight;

        protected CategoryEntry(ResearchCategory category, int weight) {
            this.category = category;
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

