/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreHelper {
    public static boolean isOreNamed(@Nonnull ItemStack stack, @Nonnull String name) {
        List<String> oreNames = OreHelper.getOreNames(stack);
        return oreNames.contains(name);
    }

    @Nonnull
    public static List<String> getOreNames(@Nonnull ItemStack stack) {
        int[] oreIds;
        ArrayList<String> names = new ArrayList<String>();
        if (stack.func_190926_b()) {
            return names;
        }
        for (int id : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            names.add(OreDictionary.getOreName((int)id));
        }
        return names;
    }

    public static boolean isOreBlock(ItemStack stack) {
        for (String name : OreHelper.getOreNames(stack)) {
            if (name == null || !name.toUpperCase().startsWith("ORE")) continue;
            return true;
        }
        return false;
    }

    public static boolean isOreMatch(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        List<String> names1 = OreHelper.getOreNames(stack1);
        List<String> names2 = OreHelper.getOreNames(stack2);
        names1.retainAll(names2);
        return names1.size() > 0;
    }
}

