/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import com.verdantartifice.thaumicwonders.common.tiles.devices.IResearchEngine;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;

public abstract class AbstractTileResearchEngine
extends TileTW
implements IAspectContainer,
IEssentiaTransport,
ITickable,
IResearchEngine {
    protected int amount = 0;
    protected int tickCounter = 0;

    public abstract int getCost();

    public abstract int getCapacity();

    public abstract Aspect getAspect();

    @Override
    public boolean isFueled() {
        return this.amount >= this.getCost();
    }

    @Override
    public boolean deductCost() {
        return this.takeFromContainer(this.getAspect(), this.getCost());
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.amount = compound.func_74765_d("essentia");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74777_a("essentia", (short)this.amount);
        return compound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.tickCounter % 5 == 0 && this.amount < this.getCapacity()) {
            this.fill();
        }
    }

    private void fill() {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IEssentiaTransport otherTile;
            TileEntity te;
            if (!this.canInputFrom(face) || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face)) == null || !(te instanceof IEssentiaTransport) || !(otherTile = (IEssentiaTransport)te).canOutputTo(face.func_176734_d()) || otherTile.getEssentiaType(face.func_176734_d()) != this.getAspect() || otherTile.getEssentiaAmount(face.func_176734_d()) <= 0 || this.getSuctionAmount(face) <= otherTile.getSuctionAmount(face.func_176734_d()) || this.getSuctionAmount(face) < otherTile.getMinimumSuction()) continue;
            int taken = otherTile.takeEssentia(this.getAspect(), 1, face.func_176734_d());
            int leftover = this.addToContainer(this.getAspect(), taken);
            if (leftover > 0) {
                ThaumicWonders.LOGGER.info("{} spilling {} essentia on fill", (Object)this.field_145854_h.getRegistryName().func_110623_a(), (Object)leftover);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)leftover, (boolean)true);
            }
            this.syncTile(false);
            this.func_70296_d();
            if (this.amount >= this.getCapacity()) break;
        }
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        if (this.canInputFrom(face)) {
            return amt - this.addToContainer(aspect, amt);
        }
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        return this.isConnectable(face);
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return this.amount;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return this.getAspect();
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.amount >= this.getCapacity() ? 0 : 128;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return this.getAspect();
    }

    public boolean isConnectable(EnumFacing face) {
        return face == this.getFacing().func_176734_d();
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        if (toAdd == 0) {
            return 0;
        }
        if (this.amount >= this.getCapacity() || aspect != this.getAspect()) {
            this.syncTile(false);
            this.func_70296_d();
            return toAdd;
        }
        int added = Math.min(toAdd, this.getCapacity() - this.amount);
        this.amount += added;
        this.syncTile(false);
        this.func_70296_d();
        return toAdd - added;
    }

    public int containerContains(Aspect aspect) {
        return aspect == this.getAspect() ? this.amount : 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return aspect == this.getAspect();
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return aspect == this.getAspect() && this.amount >= amt;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (this.amount > 0) {
            list.add(this.getAspect(), this.amount);
        }
        return list;
    }

    public void setAspects(AspectList aspects) {
        if (aspects != null && aspects.size() > 0) {
            this.amount = aspects.getAmount(this.getAspect());
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (aspect == this.getAspect() && this.amount >= amt) {
            this.amount -= amt;
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

