/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTWInventory;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.InventoryUtils;

public class TilePrimordialAccretionChamber
extends TileTWInventory
implements IAspectContainer,
ITickable {
    private static final int CAPACITY = 125;
    private static final AspectList REQUIRED_FUEL = new AspectList().add(Aspect.AIR, 125).add(Aspect.EARTH, 125).add(Aspect.FIRE, 125).add(Aspect.WATER, 125).add(Aspect.ORDER, 125).add(Aspect.ENTROPY, 125);
    private static final int PLAY_EFFECTS = 4;
    protected int refineTime = 0;
    protected int maxRefineTime = 0;
    protected int speedyTime = 0;
    protected AspectList essentia = new AspectList();

    public TilePrimordialAccretionChamber() {
        super(32);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 1.3, (double)this.func_174877_v().func_177956_o() - 1.3, (double)this.func_174877_v().func_177952_p() - 1.3, (double)this.func_174877_v().func_177958_n() + 2.3, (double)this.func_174877_v().func_177956_o() + 2.3, (double)this.func_174877_v().func_177952_p() + 1.3);
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.essentia.readFromNBT(compound, "essentia");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        this.essentia.writeToNBT(compound, "essentia");
        return compound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int slot;
            boolean refinedFlag = false;
            if (this.refineTime > 0 && this.isEssentiaFull()) {
                --this.refineTime;
                refinedFlag = true;
            }
            if (this.maxRefineTime <= 0) {
                this.maxRefineTime = this.calcRefineTime();
            }
            if (this.refineTime > this.maxRefineTime) {
                this.refineTime = this.maxRefineTime;
            }
            if (this.refineTime <= 0 && refinedFlag) {
                for (slot = 0; slot < this.func_70302_i_(); ++slot) {
                    ItemStack stack = this.func_70301_a(slot);
                    if (stack == null || stack.func_190926_b() || !this.isEssentiaFull()) continue;
                    ItemStack resultStack = this.getResultStack(stack);
                    if (this.speedyTime > 0) {
                        --this.speedyTime;
                    }
                    this.takeFromContainer(REQUIRED_FUEL);
                    this.ejectItem(resultStack.func_77946_l());
                    this.field_145850_b.func_175641_c(this.func_174877_v(), BlocksTW.PRIMORDIAL_ACCRETION_CHAMBER, 4, 0);
                    this.func_70298_a(slot, resultStack.func_190916_E());
                    break;
                }
            }
            if (this.speedyTime <= 0) {
                this.speedyTime = (int)AuraHelper.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (float)20.0f, (boolean)false);
            }
            if (this.refineTime == 0 && !refinedFlag) {
                for (slot = 0; slot < this.func_70302_i_(); ++slot) {
                    if (this.canRefine(this.func_70301_a(slot))) {
                        this.refineTime = this.maxRefineTime = this.calcRefineTime();
                        break;
                    }
                    this.ejectItem(this.func_70301_a(slot).func_77946_l());
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
        }
    }

    private ItemStack getResultStack(ItemStack inputStack) {
        if (inputStack.func_77973_b() == ItemsTW.PRIMORDIAL_GRAIN) {
            int chance = this.field_145850_b.field_73012_v.nextInt(10);
            if (chance == 0) {
                return new ItemStack(ItemsTC.primordialPearl, 1, 5);
            }
            if (chance < 3) {
                return new ItemStack(ItemsTC.primordialPearl, 1, 6);
            }
            return new ItemStack(ItemsTC.primordialPearl, 1, 7);
        }
        return inputStack;
    }

    public ItemStack addItemsToInventory(ItemStack items) {
        if (this.canRefine(items)) {
            return ThaumcraftInvHelper.insertStackAt((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.UP, (ItemStack)items, (boolean)false);
        }
        this.ejectItem(items);
        return ItemStack.field_190927_a;
    }

    private boolean canRefine(ItemStack items) {
        return items != null && !items.func_190926_b() && items.func_77973_b() == ItemsTW.PRIMORDIAL_GRAIN && this.isEssentiaFull();
    }

    private void ejectItem(ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            EnumFacing facing = BlockStateUtils.getFacing((int)this.func_145832_p()).func_176734_d();
            InventoryUtils.ejectStackAt((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)facing, (ItemStack)itemStack);
        }
    }

    private int calcRefineTime() {
        return this.speedyTime > 0 ? 80 : 140;
    }

    public Aspect getCurrentSuction() {
        for (Aspect aspect : REQUIRED_FUEL.getAspectsSortedByName()) {
            if (this.doesContainerContainAmount(aspect, 125)) continue;
            return aspect;
        }
        return null;
    }

    public boolean isEssentiaFull() {
        return this.doesContainerContain(REQUIRED_FUEL);
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        if (toAdd == 0) {
            return 0;
        }
        if (this.essentia.getAmount(aspect) >= 125 || !this.doesContainerAccept(aspect)) {
            this.syncTile(false);
            this.func_70296_d();
            return toAdd;
        }
        int added = Math.min(toAdd, 125 - this.essentia.getAmount(aspect));
        this.essentia.add(aspect, added);
        this.syncTile(false);
        this.func_70296_d();
        return toAdd - added;
    }

    public int containerContains(Aspect aspect) {
        return this.doesContainerAccept(aspect) ? this.essentia.getAmount(aspect) : 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return REQUIRED_FUEL.getAmount(aspect) > 0;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return this.essentia.getAmount(aspect) >= amt;
    }

    public AspectList getAspects() {
        return this.essentia.copy();
    }

    public void setAspects(AspectList aspects) {
        if (aspects != null) {
            this.essentia = aspects.copy();
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (this.doesContainerContainAmount(aspect, amt)) {
            this.essentia.reduce(aspect, amt);
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 4) {
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    BlockPos targetPos = this.func_174877_v().func_177967_a(this.getFacing().func_176734_d(), 2);
                    FXDispatcher.INSTANCE.visSparkle(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), Aspect.MAGIC.getColor());
                }
            }
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.8f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
            return true;
        }
        return super.func_145842_c(id, type);
    }
}

