/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.capability;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import thecodex6824.thaumicaugmentation.api.augment.Augment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.CasterAugmentBuilder;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.ICustomCasterAugment;
import thecodex6824.thaumicaugmentation.api.util.DamageWrapper;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterEffectProvider;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterStrengthProvider;

public class AugmentCasterCustom
extends Augment
implements ICustomCasterAugment {
    protected ItemStack strength = ItemStack.field_190927_a;
    protected ItemStack effect = ItemStack.field_190927_a;
    protected ResourceLocation strengthLoc;
    protected ResourceLocation effectLoc;

    @Override
    public void onEquip(Entity user) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onEquip(this, user);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onEquip(this, user);
        }
    }

    @Override
    public void onUnequip(Entity user) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onUnequip(this, user);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onUnequip(this, user);
        }
    }

    @Override
    public boolean onCastPre(ItemStack caster, FocusWrapper focus, Entity user) {
        if (!this.strength.func_190926_b() && !this.effect.func_190926_b() && this.strengthLoc != null && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).apply(this, user, caster, focus, CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).calculateStrength(this, focus, user));
        }
        return false;
    }

    @Override
    public boolean onDamaged(Entity attacked, DamageSource source, DamageWrapper damage) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onDamaged(this, attacked, source, damage);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onDamaged(this, attacked, source, damage);
        }
        return false;
    }

    @Override
    public boolean onHurt(Entity attacked, DamageSource source, DamageWrapper damage) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onHurt(this, attacked, source, damage);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onHurt(this, attacked, source, damage);
        }
        return false;
    }

    @Override
    public boolean onDamagedEntity(DamageSource source, Entity attacked, DamageWrapper damage) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onDamagedEntity(this, source, attacked, damage);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onDamagedEntity(this, source, attacked, damage);
        }
        return false;
    }

    @Override
    public boolean onHurtEntity(DamageSource source, Entity attacked, DamageWrapper damage) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onHurtEntity(this, source, attacked, damage);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onHurtEntity(this, source, attacked, damage);
        }
        return false;
    }

    @Override
    public boolean onTick(Entity user) {
        if (!this.strength.func_190926_b() && this.strengthLoc != null) {
            CasterAugmentBuilder.getStrengthProvider(this.strengthLoc).onTick(this, user);
        }
        if (!this.effect.func_190926_b() && this.effectLoc != null) {
            CasterAugmentBuilder.getEffectProvider(this.effectLoc).onTick(this, user);
        }
        return false;
    }

    @Override
    public boolean isCompatible(ItemStack otherAugment) {
        IAugment a = (IAugment)otherAugment.getCapability(CapabilityAugment.AUGMENT, null);
        if (a != null && a instanceof ICustomCasterAugment) {
            ICustomCasterAugment aug = (ICustomCasterAugment)a;
            return !aug.getStrengthProvider().func_77977_a().equals(this.strength.func_77977_a());
        }
        return true;
    }

    @Override
    public void setStrengthProvider(ItemStack s) {
        this.strength = s.func_77946_l();
        this.strengthLoc = this.strength.func_77942_o() ? new ResourceLocation(this.strength.func_77978_p().func_74779_i("id")) : null;
    }

    @Override
    public ItemStack getStrengthProvider() {
        return this.strength;
    }

    @Override
    public void setEffectProvider(ItemStack e) {
        this.effect = e.func_77946_l();
        this.effectLoc = this.effect.func_77942_o() ? new ResourceLocation(this.effect.func_77978_p().func_74779_i("id")) : null;
    }

    @Override
    public ItemStack getEffectProvider() {
        return this.effect;
    }

    @Override
    public boolean hasAdditionalAugmentTooltip() {
        return true;
    }

    @Override
    public void appendAdditionalAugmentTooltip(List<String> tooltip) {
        tooltip.add(new TextComponentTranslation(this.strength.func_77977_a(), new Object[0]).func_150254_d());
        CasterAugmentBuilder.getStrengthProvider(ItemCustomCasterStrengthProvider.getProviderID(this.strength)).appendAdditionalTooltip(this.strength, tooltip);
        tooltip.add(new TextComponentTranslation(this.effect.func_77977_a(), new Object[0]).func_150254_d());
        CasterAugmentBuilder.getEffectProvider(ItemCustomCasterEffectProvider.getProviderID(this.effect)).appendAdditionalTooltip(this.effect, tooltip);
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("strength", 10)) {
            this.strength = new ItemStack(nbt.func_74775_l("strength"));
            ResourceLocation resourceLocation = this.strengthLoc = this.strength.func_77942_o() ? new ResourceLocation(this.strength.func_77978_p().func_74779_i("id")) : null;
        }
        if (nbt.func_150297_b("effect", 10)) {
            this.effect = new ItemStack(nbt.func_74775_l("effect"));
            this.effectLoc = this.effect.func_77942_o() ? new ResourceLocation(this.effect.func_77978_p().func_74779_i("id")) : null;
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.strength.func_190926_b()) {
            tag.func_74782_a("strength", (NBTBase)this.strength.serializeNBT());
        }
        if (!this.effect.func_190926_b()) {
            tag.func_74782_a("effect", (NBTBase)this.effect.serializeNBT());
        }
        return tag;
    }
}

