/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.tiles.essentia.TileTube;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.aspect.AspectUtil;
import thecodex6824.thaumicaugmentation.api.tile.IEssentiaTube;
import thecodex6824.thaumicaugmentation.common.network.PacketEssentiaUpdate;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class TileGlassTube
extends TileEntity
implements IEssentiaTube,
IInteractWithCaster,
ITickable {
    protected byte sides = (byte)63;
    protected Aspect containedAspect;
    protected int amount;
    protected int suction;
    protected Aspect suctionAspect;
    protected int ventingTicks;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected int ventingColor;
    protected float ventX = -1.0f;
    protected float ventY = -1.0f;
    protected int fluidStartTicks = 20;
    protected boolean fluidStartTicksUp = true;
    protected Aspect lastFluid;

    protected void syncEssentia() {
        PacketEssentiaUpdate update = new PacketEssentiaUpdate(this.field_174879_c, AspectUtil.getAspectID(this.containedAspect), this.amount);
        TANetwork.INSTANCE.sendToAllTracking((IMessage)update, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
    }

    public void func_73660_a() {
        if (this.ventingTicks > 0) {
            --this.ventingTicks;
        }
        if (!this.field_145850_b.field_72995_K && this.ventingTicks == 0) {
            if (++this.ticks % 2 == 0) {
                this.suction = 0;
                this.suctionAspect = null;
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    int suck;
                    TileEntity te;
                    if (!this.isConnectable(facing) || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)facing)) == null) continue;
                    IEssentiaTransport t = (IEssentiaTransport)te;
                    if ((this.getEssentiaAmount(facing) == 0 || t.getSuctionType(facing.func_176734_d()) == null || this.getEssentiaType(facing) == t.getSuctionType(facing.func_176734_d())) && (suck = t.getSuctionAmount(facing.func_176734_d())) > 0 && suck > this.getSuctionAmount(facing) + 1) {
                        Aspect a = t.getSuctionType(facing.func_176734_d());
                        this.setSuction(a, suck - 1);
                    }
                    suck = t.getSuctionAmount(facing.func_176734_d());
                    int ourSuck = this.getSuctionAmount(facing);
                    if (ourSuck <= 0 || ourSuck != suck && ourSuck != suck - 1 || this.getSuctionType(facing) == t.getSuctionType(facing.func_176734_d())) continue;
                    this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.suctionAspect != null ? this.suctionAspect.getColor() : 0xAAAAAA);
                    this.ventingTicks = 40;
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.1f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f);
                    this.func_70296_d();
                }
                if (this.containedAspect != null && this.amount == 0) {
                    this.containedAspect = null;
                }
            } else if (this.ticks % 5 == 0 && this.suction != 0 && this.amount == 0) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    int added;
                    IEssentiaTransport t;
                    TileEntity te;
                    if (!this.isConnectable(facing) || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)facing)) == null || !(t = (IEssentiaTransport)te).canOutputTo(facing.func_176734_d())) continue;
                    Aspect suckType = this.getSuctionType(facing);
                    int suck = this.getSuctionAmount(facing);
                    if (suckType != null && suckType != t.getEssentiaType(facing.func_176734_d()) && t.getEssentiaType(facing.func_176734_d()) != null || suck <= t.getSuctionAmount(facing.func_176734_d()) || suck <= t.getMinimumSuction()) continue;
                    if (suckType == null && (suckType = t.getEssentiaType(facing.func_176734_d())) == null) {
                        suckType = t.getEssentiaType(null);
                    }
                    if ((added = this.addEssentia(suckType, t.takeEssentia(suckType, 1, facing.func_176734_d()), facing)) <= 0) continue;
                    if (this.field_145850_b.field_73012_v.nextInt(100) == 0) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.creak, SoundCategory.AMBIENT, 1.0f, 1.3f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                    }
                    break;
                }
            }
        } else if (this.field_145850_b.field_72995_K && ThaumicAugmentation.proxy.isInGame()) {
            if (this.fluidStartTicksUp) {
                if (this.fluidStartTicks < 20) {
                    ++this.fluidStartTicks;
                }
            } else if (this.fluidStartTicks > 0) {
                --this.fluidStartTicks;
            }
            if (this.ventingTicks > 0) {
                if (this.ventX < 0.0f) {
                    this.ventX = this.field_145850_b.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                }
                if (this.ventY < 0.0f) {
                    this.ventY = this.field_145850_b.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                }
                double fX = -MathHelper.func_76126_a((float)this.ventX) * MathHelper.func_76134_b((float)this.ventY);
                double fZ = MathHelper.func_76134_b((float)this.ventX) * MathHelper.func_76134_b((float)this.ventY);
                double fY = -MathHelper.func_76126_a((float)this.ventY);
                FXDispatcher.INSTANCE.drawVentParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, fX / 5.0, fY / 5.0, fZ / 5.0, this.ventingColor);
            }
        }
    }

    public int addEssentia(Aspect aspect, int addAmount, @Nullable EnumFacing from) {
        if (this.amount == 0 && addAmount != 0 && this.canInputFrom(from)) {
            this.containedAspect = aspect;
            ++this.amount;
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.syncEssentia();
            }
            return 1;
        }
        return 0;
    }

    public boolean canInputFrom(@Nullable EnumFacing face) {
        return face != null && this.isSideOpen(face);
    }

    public boolean canOutputTo(@Nullable EnumFacing face) {
        return face != null && this.isSideOpen(face);
    }

    public int getEssentiaAmount(@Nullable EnumFacing face) {
        if (face != null) {
            return this.amount;
        }
        return 0;
    }

    @Nullable
    public Aspect getEssentiaType(@Nullable EnumFacing face) {
        if (face != null) {
            return this.containedAspect;
        }
        return null;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        if (face != null) {
            return this.suction;
        }
        return 0;
    }

    @Nullable
    public Aspect getSuctionType(EnumFacing face) {
        if (face != null) {
            return this.suctionAspect;
        }
        return null;
    }

    public boolean isConnectable(@Nullable EnumFacing face) {
        return face != null && this.isSideOpen(face);
    }

    @Override
    public boolean isSideOpen(EnumFacing side) {
        return (this.sides & 1 << side.func_176745_a()) >> side.func_176745_a() == 1;
    }

    public boolean onCasterRightClick(World world, ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing face, EnumHand hand) {
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d look = player.func_70040_Z();
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        RayTraceResult result = world.func_180495_p(pos).func_185910_a(world, pos, start, start.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach));
        if (result == null || result.func_178782_a() == null) {
            return false;
        }
        if (result.subHit >= 0 && result.subHit < 6) {
            world.func_184133_a(null, pos, SoundsTC.tool, SoundCategory.BLOCKS, 0.5f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
            player.func_184609_a(hand);
            this.func_70296_d();
            EnumFacing dir = EnumFacing.func_82600_a((int)result.subHit);
            this.setSideOpen(dir, !this.isSideOpen(dir));
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (tile != null) {
                if (tile instanceof TileTube) {
                    ((TileTube)tile).openSides[dir.func_176734_d().ordinal()] = this.isSideOpen(dir);
                    ((TileTube)tile).syncTile(true);
                    tile.func_70296_d();
                } else if (tile instanceof IEssentiaTube) {
                    ((IEssentiaTube)tile).setSideOpen(dir.func_176734_d(), this.isSideOpen(dir));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setEssentiaDirect(@Nullable Aspect aspect, int amount) {
        this.fluidStartTicksUp = aspect != null && amount != 0;
        this.lastFluid = this.containedAspect;
        this.containedAspect = aspect;
        this.amount = amount;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.syncEssentia();
        }
    }

    @Override
    public void setSideOpen(EnumFacing side, boolean open) {
        this.sides = open ? (byte)(this.sides | 1 << side.func_176745_a()) : (byte)(this.sides & ~(1 << side.func_176745_a()));
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void setSuction(Aspect aspect, int amount) {
        this.suctionAspect = aspect;
        this.suction = amount;
        this.func_70296_d();
    }

    public int takeEssentia(Aspect aspect, int takeAmount, EnumFacing face) {
        if (this.containedAspect == aspect && this.amount == 1 && takeAmount > 0 && this.canOutputTo(face)) {
            --this.amount;
            this.containedAspect = null;
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.syncEssentia();
            }
            return 1;
        }
        return 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int getFluidStartTicks() {
        return this.fluidStartTicks;
    }

    public void setFluidStartTicks(int newTicks) {
        this.fluidStartTicks = newTicks;
    }

    public Aspect getLastFluid() {
        return this.lastFluid;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.ventingTicks = 40;
            this.ventingColor = type;
            return true;
        }
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74774_a("sides", this.sides);
        tag.func_74778_a("containedAspect", this.containedAspect != null ? this.containedAspect.getTag() : "");
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.sides = tag.func_74771_c("sides");
        this.containedAspect = Aspect.getAspect((String)tag.func_74779_i("containedAspect"));
        this.amount = tag.func_74762_e("amount");
        this.lastFluid = this.containedAspect;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("sides", this.sides);
        tag.func_74778_a("containedAspect", this.containedAspect != null ? this.containedAspect.getTag() : "");
        tag.func_74768_a("amount", this.amount);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.sides = pkt.func_148857_g().func_74771_c("sides");
        this.containedAspect = Aspect.getAspect((String)pkt.func_148857_g().func_74779_i("containedAspect"));
        this.amount = pkt.func_148857_g().func_74762_e("amount");
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("sides", this.sides);
        compound.func_74778_a("containedAspect", this.containedAspect != null ? this.containedAspect.getTag() : "");
        compound.func_74768_a("amount", this.amount);
        compound.func_74778_a("suctionAspect", this.suctionAspect != null ? this.suctionAspect.getTag() : "");
        compound.func_74768_a("suction", this.suction);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.sides = compound.func_74771_c("sides");
        this.containedAspect = Aspect.getAspect((String)compound.func_74779_i("containedAspect"));
        this.amount = compound.func_74762_e("amount");
        this.suctionAspect = Aspect.getAspect((String)compound.func_74779_i("suctionAspect"));
        this.suction = compound.func_74762_e("suction");
    }

    public boolean hasFastRenderer() {
        return true;
    }
}

