/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.Deque;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import thaumcraft.api.aura.AuraHelper;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.ImpetusNode;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class TileImpetusMirror
extends TileEntity
implements ITickable {
    protected ImpetusNode node = new ImpetusNode(2, 2){

        @Override
        public boolean canConnectNodeAsInput(IImpetusNode toConnect) {
            return this.getNumInputs() < this.getMaxInputs() - 1 && !toConnect.getLocation().equals(TileImpetusMirror.this.linked) || this.inputs.contains(TileImpetusMirror.this.linked) && !toConnect.getLocation().equals(TileImpetusMirror.this.linked);
        }

        @Override
        public boolean canConnectNodeAsOutput(IImpetusNode toConnect) {
            return this.getNumOutputs() < this.getMaxOutputs() - 1 && !toConnect.getLocation().equals(TileImpetusMirror.this.linked) || this.outputs.contains(TileImpetusMirror.this.linked) && !toConnect.getLocation().equals(TileImpetusMirror.this.linked);
        }

        @Override
        public boolean canRemoveNodeAsInput(IImpetusNode toRemove) {
            return !toRemove.getLocation().equals(TileImpetusMirror.this.linked);
        }

        @Override
        public boolean canRemoveNodeAsOutput(IImpetusNode toRemove) {
            return !toRemove.getLocation().equals(TileImpetusMirror.this.linked);
        }

        @Override
        public boolean shouldPhysicalBeamLinkTo(IImpetusNode other) {
            return !other.getLocation().equals(TileImpetusMirror.this.linked);
        }

        @Override
        public boolean shouldEnforceBeamLimitsWith(IImpetusNode other) {
            return !other.getLocation().equals(TileImpetusMirror.this.linked);
        }

        @Override
        public void onConnected(IImpetusNode other) {
            if (!((TileImpetusMirror)TileImpetusMirror.this).field_145850_b.field_72995_K && !TileImpetusMirror.this.linked.isInvalid() && other.getLocation().equals(TileImpetusMirror.this.linked)) {
                TileImpetusMirror.this.open = true;
                TileImpetusMirror.this.needsSync = true;
            }
        }

        @Override
        public void onDisconnected(IImpetusNode other) {
            if (!((TileImpetusMirror)TileImpetusMirror.this).field_145850_b.field_72995_K && !TileImpetusMirror.this.linked.isInvalid() && other.getLocation().equals(TileImpetusMirror.this.linked)) {
                TileImpetusMirror.this.open = false;
                TileImpetusMirror.this.needsSync = true;
            }
        }

        @Override
        public Vec3d getBeamEndpoint() {
            Vec3d position = new Vec3d((double)TileImpetusMirror.this.field_174879_c.func_177958_n(), (double)TileImpetusMirror.this.field_174879_c.func_177956_o(), (double)TileImpetusMirror.this.field_174879_c.func_177952_p());
            IBlockState state = TileImpetusMirror.this.field_145850_b.func_180495_p(TileImpetusMirror.this.field_174879_c);
            if (state.func_177227_a().contains(IDirectionalBlock.DIRECTION)) {
                switch ((EnumFacing)TileImpetusMirror.this.field_145850_b.func_180495_p(TileImpetusMirror.this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
                    case DOWN: {
                        return position.func_72441_c(0.5, 0.98125, 0.5);
                    }
                    case EAST: {
                        return position.func_72441_c(0.01875, 0.5, 0.5);
                    }
                    case NORTH: {
                        return position.func_72441_c(0.5, 0.5, 0.98125);
                    }
                    case SOUTH: {
                        return position.func_72441_c(0.5, 0.5, 0.01875);
                    }
                    case WEST: {
                        return position.func_72441_c(0.98125, 0.5, 0.5);
                    }
                }
                return position.func_72441_c(0.5, 0.01875, 0.5);
            }
            return position.func_72441_c(0.5, 0.01875, 0.5);
        }

        @Override
        public long onTransaction(Deque<IImpetusNode> path, long energy, boolean simulate) {
            energy = Math.min(energy, 45L);
            TileImpetusMirror.this.fluxProgress += energy;
            TileImpetusMirror.this.func_70296_d();
            return energy;
        }
    };
    protected DimensionalBlockPos linked = DimensionalBlockPos.INVALID;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected boolean needsSync;
    protected boolean open;
    protected long fluxProgress;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks++ % 20 == 0) {
                TileImpetusMirror otherMirror;
                IImpetusNode otherNode;
                TileEntity tile;
                WorldServer targetWorld;
                if (!this.linked.isInvalid() && !this.node.getLocation().isInvalid() && (targetWorld = DimensionManager.getWorld((int)this.linked.getDimension())) != null && targetWorld.func_175667_e(this.linked.getPos()) && (tile = targetWorld.func_175625_s(this.linked.getPos())) instanceof TileImpetusMirror && (otherNode = (IImpetusNode)tile.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null && ((otherMirror = (TileImpetusMirror)tile).getLink().isInvalid() || !otherNode.getInputLocations().contains(otherMirror.getLink()))) {
                    otherMirror.setLink(this.node.getLocation());
                    this.func_70296_d();
                    this.needsSync = true;
                }
                while (this.fluxProgress >= 1000L) {
                    AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)(this.field_145850_b.field_73012_v.nextInt(3) + 1), (boolean)true);
                    this.fluxProgress -= 1000L;
                    this.func_70296_d();
                }
            }
            if (this.needsSync) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.needsSync = false;
            }
            if (this.ticks % 20 == 0) {
                NodeHelper.validate(this.node, this.field_145850_b);
            }
        }
    }

    public void setLink(DimensionalBlockPos linkTo) {
        if (!linkTo.equals(this.linked)) {
            TileImpetusMirror otherMirror;
            IImpetusNode otherNode;
            TileEntity tile;
            WorldServer targetWorld;
            if (!this.linked.isInvalid()) {
                IImpetusNode link = this.node.getGraph().findNodeByPosition(this.linked);
                if (link != null) {
                    this.node.removeInput(link);
                    this.node.removeOutput(link);
                } else {
                    this.node.removeInputLocation(this.linked);
                    this.node.removeOutputLocation(this.linked);
                }
                NodeHelper.syncRemovedImpetusNodeInput(this.node, this.linked);
                NodeHelper.syncRemovedImpetusNodeOutput(this.node, this.linked);
            }
            this.linked = linkTo;
            if (!this.linked.isInvalid() && (targetWorld = DimensionManager.getWorld((int)this.linked.getDimension())) != null && targetWorld.func_175667_e(this.linked.getPos()) && (tile = targetWorld.func_175625_s(this.linked.getPos())) instanceof TileImpetusMirror && (otherNode = (IImpetusNode)tile.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null && ((otherMirror = (TileImpetusMirror)tile).getLink().isInvalid() || !otherNode.getInputLocations().contains(otherMirror.getLink()))) {
                otherMirror.setLink(this.node.getLocation());
                this.node.addInput(otherNode);
                this.node.addOutput(otherNode);
                NodeHelper.syncAddedImpetusNodeInput(this.node, this.linked);
                NodeHelper.syncAddedImpetusNodeOutput(this.node, this.linked);
            }
            this.func_70296_d();
        }
    }

    public DimensionalBlockPos getLink() {
        return this.linked;
    }

    public boolean shouldShowOpenMirror() {
        return this.open;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.node);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.node);
        }
        this.node.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.node);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.node.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.node);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        if (!this.linked.isInvalid()) {
            tag.func_74783_a("link", this.linked.toArray());
        }
        tag.func_74772_a("flux", this.fluxProgress);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.node.deserializeNBT(nbt.func_74775_l("node"));
        this.linked = nbt.func_150297_b("link", 11) ? new DimensionalBlockPos(nbt.func_74759_k("link")) : DimensionalBlockPos.INVALID;
        this.fluxProgress = nbt.func_74763_f("flux");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        if (!this.linked.isInvalid()) {
            tag.func_74783_a("link", this.linked.toArray());
        }
        tag.func_74757_a("open", this.open);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NodeHelper.tryConnectNewlyLoadedPeers(this.node, this.field_145850_b);
        this.open = tag.func_74767_n("open");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.linked.isInvalid()) {
            tag.func_74783_a("link", this.linked.toArray());
        }
        tag.func_74757_a("open", this.open);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (this.field_145850_b.field_72995_K) {
            this.linked = packet.func_148857_g().func_150297_b("link", 11) ? new DimensionalBlockPos(packet.func_148857_g().func_74759_k("link")) : DimensionalBlockPos.INVALID;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.open = packet.func_148857_g().func_74767_n("open");
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.node);
        }
        return (T)super.getCapability(capability, facing);
    }
}

