/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.tile.INameableTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedInventory;
import thecodex6824.thaumicaugmentation.api.ward.tile.WardedInventory;
import thecodex6824.thaumicaugmentation.common.tile.TileWarded;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.util.AnimationHelper;

public class TileWardedChest
extends TileWarded
implements IAnimatedTile,
INameableTile {
    protected static final float ANIM_TIME = 0.5f;
    protected WardedInventory inventory = new WardedInventory(27);
    protected IAnimationStateMachine asm;
    protected TimeValues.VariableValue openTime = new TimeValues.VariableValue(-1.0f);
    protected String name;

    public TileWardedChest() {
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/warded_chest.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"anim_time", (Object)new TimeValues.VariableValue(0.5f), (Object)"open_time", (Object)this.openTime));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onOpenInventory() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
        }
    }

    public void onCloseInventory() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            float time = Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime());
            float partialProgress = this.openTime.apply(time) < 0.0f ? 0.0f : MathHelper.func_76131_a((float)(0.5f - (time - this.openTime.apply(time))), (float)0.0f, (float)0.5f);
            this.openTime.setValue(time - partialProgress);
            AnimationHelper.transitionSafely(this.asm, type == 1 ? "opening" : "closing");
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.name != null) {
            compound.func_74778_a("CustomName", this.name);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        if (compound.func_150297_b("CustomName", 8)) {
            this.name = compound.func_74779_i("CustomName");
        }
        super.func_145839_a(compound);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    @Override
    public boolean hasCustomName() {
        return this.name != null;
    }

    @Override
    @Nullable
    public String getCustomName() {
        return this.name;
    }

    @Override
    public void setCustomName(String name) {
        this.name = name;
        this.func_70296_d();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY || capability == CapabilityWardedInventory.WARDED_INVENTORY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        if (capability == CapabilityWardedInventory.WARDED_INVENTORY) {
            return (T)CapabilityWardedInventory.WARDED_INVENTORY.cast((Object)this.inventory);
        }
        return super.getCapability(capability, facing);
    }
}

