/*
 * Decompiled with CFR 0.152.
 */
package zzzank.mod.jei_area_fixer.mods;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import zzzank.mod.jei_area_fixer.AbstractJEIAreaProvider;
import zzzank.mod.jei_area_fixer.JEIAreaFixer;

public class GeneralButtonsArea
extends AbstractJEIAreaProvider<GuiContainer> {
    private final Map<Class<? extends GuiContainer>, List<GuiButton>> buttonsMap = new IdentityHashMap<Class<? extends GuiContainer>, List<GuiButton>>();
    private final Object2LongMap<Class<? extends GuiContainer>> timestamps = new Object2LongOpenHashMap();
    private static final long INTERVAL = 1000L;

    @Override
    @Nonnull
    protected Class<GuiContainer> getTarget() {
        return GuiContainer.class;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void readButtonInfos(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)event.getGui();
            this.buttonsMap.put(guiContainer.getClass(), event.getButtonList());
        }
    }

    @Override
    @Nullable
    protected List<Rectangle> getExclusionAreas(@Nonnull GuiContainer gui) {
        long lastTime;
        List<GuiButton> buttons = this.buttonsMap.get(gui.getClass());
        if (buttons == null || buttons.isEmpty()) {
            return Collections.emptyList();
        }
        long currTime = System.currentTimeMillis();
        if (currTime - (lastTime = this.timestamps.put(gui.getClass(), currTime)) > 1000L) {
            this.buttonsMap.remove(gui.getClass());
            return Collections.emptyList();
        }
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>(buttons.size());
        for (GuiButton button : buttons) {
            if (!button.field_146125_m && !button.field_146124_l) continue;
            bounds.add(JEIAreaFixer.rectFromButton(button));
        }
        return bounds;
    }
}

