/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.basalt;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.common.blocks.BlockStairsGeneric;
import com.ferreusveritas.cathedral.compat.CompatThermalExpansion;
import com.ferreusveritas.cathedral.features.BlockForm;
import com.ferreusveritas.cathedral.features.IFeature;
import com.ferreusveritas.cathedral.features.basalt.BlockBasalt;
import com.ferreusveritas.cathedral.features.basalt.BlockCheckered;
import com.ferreusveritas.cathedral.features.basalt.BlockDoubleSlabBasalt;
import com.ferreusveritas.cathedral.features.basalt.BlockDoubleSlabCheckered;
import com.ferreusveritas.cathedral.features.basalt.BlockSlabBasalt;
import com.ferreusveritas.cathedral.features.basalt.BlockSlabCheckered;
import com.ferreusveritas.cathedral.proxy.ModelHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Basalt
implements IFeature {
    public static final String featureName = "basalt";
    public Block blockCarved;
    public Block slabCarved;
    public Block slabCarvedDouble;
    public ArrayList<Block> stairsCarved = new ArrayList();
    public Block blockCheckered;
    public Block slabCheckered;
    public Block slabCheckeredDouble;
    public ArrayList<Block> stairsCheckered = new ArrayList();
    public final float basaltHardness = 2.5f;
    public final float basaltResistance = 20.0f;
    public final float marbleHardness = 2.0f;
    public final float marbleResistance = 10.0f;

    @Override
    public String getName() {
        return featureName;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void createBlocks() {
        this.blockCarved = new BlockBasalt(this.featureObjectName(BlockForm.BLOCK, "carved"));
        this.slabCarved = new BlockSlabBasalt(this.featureObjectName(BlockForm.SLAB, "carved")).func_149647_a(CathedralMod.tabBasalt).func_149711_c(2.5f).func_149752_b(20.0f);
        this.slabCarvedDouble = new BlockDoubleSlabBasalt(this.featureObjectName(BlockForm.DOUBLESLAB, "carved")).func_149647_a(CathedralMod.tabBasalt).func_149711_c(2.5f).func_149752_b(20.0f);
        for (BlockSlabBasalt.EnumType enumType : BlockSlabBasalt.EnumType.values()) {
            this.stairsCarved.add(new BlockStairsGeneric(this.featureObjectName(BlockForm.STAIRS, "carved_" + enumType.func_176610_l()), this.blockCarved.func_176223_P()).func_149647_a(CathedralMod.tabBasalt));
        }
        this.blockCheckered = new BlockCheckered(this.featureObjectName(BlockForm.BLOCK, "checkered"));
        this.slabCheckered = new BlockSlabCheckered(this.featureObjectName(BlockForm.SLAB, "checkered")).func_149647_a(CathedralMod.tabBasalt).func_149711_c(2.25f).func_149752_b(15.0f);
        this.slabCheckeredDouble = new BlockDoubleSlabCheckered(this.featureObjectName(BlockForm.DOUBLESLAB, "checkered")).func_149647_a(CathedralMod.tabBasalt).func_149711_c(2.5f).func_149752_b(20.0f);
        for (Enum enum_ : BlockSlabCheckered.EnumType.values()) {
            this.stairsCheckered.add(new BlockStairsGeneric(this.featureObjectName(BlockForm.STAIRS, "checkered_" + ((BlockSlabCheckered.EnumType)enum_).func_176610_l()), this.blockCheckered.func_176223_P()).func_149647_a(CathedralMod.tabBasalt));
        }
    }

    @Override
    public void createItems() {
    }

    @Override
    public void registerBlocks(IForgeRegistry<Block> registry) {
        registry.registerAll((IForgeRegistryEntry[])new Block[]{this.blockCarved, this.slabCarved, this.slabCarvedDouble});
        registry.registerAll((IForgeRegistryEntry[])this.stairsCarved.toArray(new Block[0]));
        registry.registerAll((IForgeRegistryEntry[])new Block[]{this.blockCheckered, this.slabCheckered, this.slabCheckeredDouble});
        registry.registerAll((IForgeRegistryEntry[])this.stairsCheckered.toArray(new Block[0]));
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        registry.register(new ItemMultiTexture(this.blockCarved, this.blockCarved, new ItemMultiTexture.Mapper(){

            public String apply(ItemStack stack) {
                return BlockBasalt.EnumType.byMetadata(stack.func_77960_j()).getUnlocalizedName();
            }
        }).setRegistryName(this.blockCarved.getRegistryName()));
        ItemSlab itemSlabBasalt = new ItemSlab(this.slabCarved, (BlockSlab)this.slabCarved, (BlockSlab)this.slabCarvedDouble);
        itemSlabBasalt.setRegistryName(this.slabCarved.getRegistryName());
        registry.register((IForgeRegistryEntry)itemSlabBasalt);
        for (BlockSlabBasalt.EnumType type : BlockSlabBasalt.EnumType.values()) {
            registry.register(new ItemBlock(this.stairsCarved.get(type.ordinal())).setRegistryName(this.stairsCarved.get(type.ordinal()).getRegistryName()));
        }
        registry.register(new ItemMultiTexture(this.blockCheckered, this.blockCheckered, new ItemMultiTexture.Mapper(){

            public String apply(ItemStack stack) {
                return BlockCheckered.EnumType.byMetadata(stack.func_77960_j()).getUnlocalizedName();
            }
        }).setRegistryName(this.blockCheckered.getRegistryName()));
        ItemSlab itemSlabCheckered = new ItemSlab(this.slabCheckered, (BlockSlab)this.slabCheckered, (BlockSlab)this.slabCheckeredDouble);
        itemSlabCheckered.setRegistryName(this.slabCheckered.getRegistryName());
        registry.register((IForgeRegistryEntry)itemSlabCheckered);
        for (BlockSlabCheckered.EnumType type : BlockSlabCheckered.EnumType.values()) {
            registry.register(new ItemBlock(this.stairsCheckered.get(type.ordinal())).setRegistryName(this.stairsCheckered.get(type.ordinal()).getRegistryName()));
        }
    }

    private void tryRegisterBlockOre(String oreName, ItemStack ore) {
        if (!ore.func_190926_b()) {
            OreDictionary.registerOre((String)oreName, (ItemStack)ore);
        }
    }

    public static ItemStack getItemBlockStack(String domain, String name, int metadata) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(domain, name));
        if (block != Blocks.field_150350_a) {
            return new ItemStack(block, 1, metadata);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getRawBasalt() {
        return Basalt.getItemBlockStack("chisel", "basalt2", 7);
    }

    public static ItemStack getRawMarble() {
        return Basalt.getItemBlockStack("chisel", "marble2", 7);
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> registry) {
        String basaltOre = "blockBasalt";
        String marbleOre = "blockMarble";
        this.tryRegisterBlockOre(basaltOre, Basalt.getRawBasalt());
        this.tryRegisterBlockOre(marbleOre, Basalt.getRawMarble());
        for (BlockSlabBasalt.EnumType enumType : BlockSlabBasalt.EnumType.values()) {
            Block baseBlock = (Block)Block.field_149771_c.func_82594_a((Object)enumType.getBaseResourceLocation());
            if (baseBlock == Blocks.field_150350_a) continue;
            ItemStack baseItemBlock = new ItemStack(baseBlock, 1, enumType.getBaseMeta());
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", this.slabCarved.getRegistryName().func_110623_a() + "." + enumType.getUnlocalizedName()), null, (ItemStack)new ItemStack(this.slabCarved, 6, enumType.getMetadata()), (Object[])new Object[]{"xxx", Character.valueOf('x'), baseItemBlock});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", this.stairsCarved.get(enumType.getMetadata()).getRegistryName().func_110623_a()), null, (ItemStack)new ItemStack(this.stairsCarved.get(enumType.getMetadata()), 8), (Object[])new Object[]{"x  ", "xx ", "xxx", Character.valueOf('x'), baseItemBlock});
        }
        for (boolean bl : new boolean[]{false, true}) {
            registry.register(new ShapedOreRecipe(null, new ItemStack(this.blockCheckered, 4, 0), new Object[]{bl ? "mb" : "bm", bl ? "bm" : "mb", Character.valueOf('b'), basaltOre, Character.valueOf('m'), marbleOre}).setRegistryName(this.blockCheckered.getRegistryName().func_110623_a() + (bl ? "A" : "B")));
        }
        for (BlockSlabCheckered.EnumType enumType : BlockSlabCheckered.EnumType.values()) {
            ItemStack baseItemBlock = new ItemStack(this.blockCheckered, 1, enumType.getBaseMeta());
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", this.slabCheckered.getRegistryName().func_110623_a() + "." + enumType.getUnlocalizedName()), null, (ItemStack)new ItemStack(this.slabCheckered, 6, enumType.getMetadata()), (Object[])new Object[]{"xxx", Character.valueOf('x'), baseItemBlock});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", this.stairsCheckered.get(enumType.getMetadata()).getRegistryName().func_110623_a()), null, (ItemStack)new ItemStack(this.stairsCheckered.get(enumType.getMetadata()), 8), (Object[])new Object[]{"x  ", "xx ", "xxx", Character.valueOf('x'), baseItemBlock});
        }
        ItemStack itemStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thermalfoundation", "material")), 1, 770);
        CompatThermalExpansion.addSmelterRecipe(2000, new ItemStack(Blocks.field_150348_b, 1, 0), itemStack, Basalt.getRawBasalt(), ItemStack.field_190927_a, 0);
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        for (BlockBasalt.EnumType enumType : BlockBasalt.EnumType.values()) {
            ModelHelper.regModel(Item.func_150898_a((Block)this.blockCarved), enumType.getMetadata(), new ResourceLocation("cathedral", this.blockCarved.getRegistryName().func_110623_a() + "." + enumType.getUnlocalizedName()));
        }
        for (Enum enum_ : BlockSlabBasalt.EnumType.values()) {
            ModelHelper.regModel(Item.func_150898_a((Block)this.slabCarved), ((BlockSlabBasalt.EnumType)enum_).getMetadata(), new ResourceLocation("cathedral", this.slabCarved.getRegistryName().func_110623_a() + "." + ((BlockSlabBasalt.EnumType)enum_).getUnlocalizedName()));
        }
        this.stairsCarved.forEach(s -> ModelHelper.regModel(s));
        for (Enum enum_ : BlockCheckered.EnumType.values()) {
            ModelHelper.regModel(Item.func_150898_a((Block)this.blockCheckered), ((BlockCheckered.EnumType)enum_).getMetadata(), new ResourceLocation("cathedral", this.blockCheckered.getRegistryName().func_110623_a() + "." + ((BlockCheckered.EnumType)enum_).getUnlocalizedName()));
        }
        for (Enum enum_ : BlockSlabCheckered.EnumType.values()) {
            ModelHelper.regModel(Item.func_150898_a((Block)this.slabCheckered), ((BlockSlabCheckered.EnumType)enum_).getMetadata(), new ResourceLocation("cathedral", this.slabCheckered.getRegistryName().func_110623_a() + "." + ((BlockSlabCheckered.EnumType)enum_).getUnlocalizedName()));
        }
        this.stairsCheckered.forEach(s -> ModelHelper.regModel(s));
    }

    @Override
    public void init() {
        for (BlockBasalt.EnumType enumType : BlockBasalt.EnumType.values()) {
            this.addChiselVariation(featureName, this.blockCarved, enumType.getMetadata());
        }
        for (Enum enum_ : BlockSlabBasalt.EnumType.values()) {
            this.addChiselVariation("basaltslab", this.slabCarved, ((BlockSlabBasalt.EnumType)enum_).getMetadata());
        }
        this.stairsCarved.forEach(s -> this.addChiselVariation("basaltstairs", (Block)s, 0));
        for (Enum enum_ : BlockCheckered.EnumType.values()) {
            this.addChiselVariation("basaltcheckered", this.blockCheckered, ((BlockCheckered.EnumType)enum_).getMetadata());
        }
        for (Enum enum_ : BlockSlabCheckered.EnumType.values()) {
            this.addChiselVariation("basaltcheckeredslab", this.slabCheckered, ((BlockSlabCheckered.EnumType)enum_).getMetadata());
        }
        this.stairsCheckered.forEach(s -> this.addChiselVariation("basaltcheckeredstairs", (Block)s, 0));
        for (String string : new String[]{featureName, "basalt2"}) {
            Block basalt = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("chisel", string));
            if (basalt == Blocks.field_150350_a) continue;
            basalt.func_149647_a(CathedralMod.tabBasalt);
        }
    }

    private void addChiselVariation(String group, Block block, int meta) {
        FMLInterModComms.sendMessage((String)"chisel", (String)"variation:add", (String)(group + "|" + block.getRegistryName() + "|" + meta));
    }

    @Override
    public void postInit() {
    }
}

