/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.common.blocks.MimicProperty;
import com.ferreusveritas.cathedral.features.cathedral.TileEntityDeckPrism;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDeckPrism
extends Block
implements ITileEntityProvider,
MimicProperty.IMimic {
    public static final String name = "deckprism";
    public static final IUnlistedProperty<EnumDyeColor> COLOR = new IUnlistedProperty<EnumDyeColor>(){

        public String getName() {
            return "color";
        }

        public boolean isValid(EnumDyeColor value) {
            return value != null;
        }

        public Class<EnumDyeColor> getType() {
            return EnumDyeColor.class;
        }

        public String valueToString(EnumDyeColor value) {
            return value.func_192396_c();
        }
    };

    public BlockDeckPrism() {
        super(Material.field_151592_s);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setRegistryName(new ResourceLocation("cathedral", name));
        this.func_149663_c(name);
        this.func_149647_a(CathedralMod.tabCathedral);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{MimicProperty.MIMIC, COLOR});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        return state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).withProperty((IUnlistedProperty)MimicProperty.MIMIC, (Object)this.getMimic(access, pos)).withProperty(COLOR, (Object)this.getPrismColor(access, pos)) : state;
    }

    @Override
    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return this.getDeckPrismTileEntity(access, pos).map(t -> t.getBaseBlock()).orElseGet(() -> Blocks.field_150348_b.func_176223_P());
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDeckPrism();
    }

    public EnumDyeColor getPrismColor(IBlockAccess access, BlockPos pos) {
        return this.getDeckPrismTileEntity(access, pos).map(t -> t.getGlassColor()).orElse(EnumDyeColor.WHITE);
    }

    public void setPrismColor(World world, BlockPos pos, EnumDyeColor color) {
        this.getDeckPrismTileEntity((IBlockAccess)world, pos).ifPresent(pt -> pt.setGlassColor(color));
    }

    public IBlockState getBaseBlock(IBlockAccess access, BlockPos pos) {
        return this.getDeckPrismTileEntity(access, pos).map(pt -> pt.getBaseBlock()).orElse(Blocks.field_150350_a.func_176223_P());
    }

    public void setBaseBlock(World world, BlockPos pos, IBlockState baseBlock) {
        this.getDeckPrismTileEntity((IBlockAccess)world, pos).ifPresent(pt -> pt.setBaseBlock(baseBlock));
    }

    protected Optional<TileEntityDeckPrism> getDeckPrismTileEntity(IBlockAccess access, BlockPos pos) {
        TileEntity tile = access.func_175625_s(pos);
        return tile instanceof TileEntityDeckPrism ? Optional.of((TileEntityDeckPrism)tile) : Optional.empty();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return this.getBaseBlock(access, pos).func_185900_c(access, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }

    public boolean func_149751_l(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess access, BlockPos pos) {
        IBlockState baseState = this.getBaseBlock(access, pos);
        return baseState.func_177230_c().func_149750_m(state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        int meta = this.getPrismColor((IBlockAccess)world, pos).func_176765_a();
        world.func_175656_a(pos, this.getBaseBlock((IBlockAccess)world, pos));
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this), 1, meta));
        return false;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            items.add((Object)new ItemStack((Block)this, 1, color.func_176765_a()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = this.getPrismColor((IBlockAccess)world, pos).func_176765_a();
        return new ItemStack((Block)this, 1, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)this.getPrismColor((IBlockAccess)world, pos));
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    for (int z = 0; z < 4; ++z) {
                        double delX = ((double)x + 0.5) / 4.0;
                        double delY = ((double)y + 0.5) / 4.0;
                        double delZ = ((double)z + 0.5) / 4.0;
                        ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)pos.func_177958_n() + delX, (double)pos.func_177956_o() + delY, (double)pos.func_177952_p() + delZ, delX - 0.5, delY - 0.5, delZ - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                        if (particle == null) continue;
                        particle.func_174846_a(pos).func_187117_a(texture);
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        if (pos != BlockPos.field_177992_a) {
            IBlockState particlesState = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)this.getPrismColor((IBlockAccess)world, pos));
            if (target.field_178784_b != null && target.field_178784_b.func_176740_k().func_176722_c()) {
                particlesState = this.getBaseBlock((IBlockAccess)world, pos);
            } else {
                double xx = Math.abs(target.field_72307_f.field_72450_a % 1.0);
                double zz = Math.abs(target.field_72307_f.field_72449_c % 1.0);
                if (xx < 0.3125 || xx > 0.6875 || zz < 0.3125 || zz > 0.6875) {
                    particlesState = this.getBaseBlock((IBlockAccess)world, pos);
                }
            }
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            AxisAlignedBB aabb = state.func_185900_c((IBlockAccess)world, pos);
            double xpos = (double)x + world.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - 0.2) + 0.1 + aabb.field_72340_a;
            double ypos = (double)y + world.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - 0.2) + 0.1 + aabb.field_72338_b;
            double zpos = (double)z + world.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - 0.2) + 0.1 + aabb.field_72339_c;
            switch (target.field_178784_b) {
                case DOWN: {
                    ypos = (double)y + aabb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    ypos = (double)y + aabb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    zpos = (double)z + aabb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    zpos = (double)z + aabb.field_72334_f + 0.1;
                    break;
                }
                case WEST: {
                    xpos = (double)x + aabb.field_72340_a - 0.1;
                    break;
                }
                case EAST: {
                    xpos = (double)x + aabb.field_72336_d + 0.1;
                }
            }
            ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), xpos, ypos, zpos, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)particlesState)});
            if (particle != null) {
                particle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
            }
        }
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        state = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)this.getPrismColor((IBlockAccess)world, pos));
        world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_176210_f((IBlockState)state)});
        return true;
    }
}

