/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.IVariantEnumType;
import com.ferreusveritas.cathedral.features.dwarven.FeatureTypes;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public enum EnumMaterial implements IStringSerializable,
IVariantEnumType
{
    STONE(0, "stone", 1.5f),
    SANDSTONE(1, "sandstone", 0.8f),
    REDSANDSTONE(2, "redsandstone", 0.8f),
    OBSIDIAN(3, "obsidian", 50.0f),
    NETHERBRICK(4, "netherbrick", 2.0f),
    QUARTZ(5, "quartz", 0.8f),
    ENDSTONE(6, "endstone", 3.0f),
    PACKEDICE(7, "packedice", 0.5f),
    SNOW(8, "snow", 0.2f),
    MARBLE(9, "marble", 1.5f),
    LIMESTONE(10, "limestone", 2.0f),
    BASALT(11, "basalt", 2.5f),
    DWEMER(12, "dwemer", 2.5f);

    private final int meta;
    private final String name;
    private final String unlocalizedName;
    private final float hardness;
    public static final PropertyEnum<EnumMaterial> VARIANT;

    private EnumMaterial(int index, String name, float hardness) {
        this.meta = index;
        this.name = name;
        this.unlocalizedName = name;
        this.hardness = hardness;
    }

    @Override
    public int getMetadata() {
        return this.meta;
    }

    public String toString() {
        return this.name;
    }

    public static EnumMaterial byMetadata(int meta) {
        return EnumMaterial.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)(EnumMaterial.values().length - 1))];
    }

    public static EnumMaterial byName(String name) {
        for (EnumMaterial mat : EnumMaterial.values()) {
            if (!mat.func_176610_l().equals(name)) continue;
            return mat;
        }
        return STONE;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getExplosionResistance(Entity exploder) {
        switch (this) {
            case STONE: {
                return Blocks.field_150348_b.func_149638_a(exploder);
            }
            case SANDSTONE: {
                return Blocks.field_150322_A.func_149638_a(exploder);
            }
            case REDSANDSTONE: {
                return Blocks.field_180395_cM.func_149638_a(exploder);
            }
            case OBSIDIAN: {
                return Blocks.field_150343_Z.func_149638_a(exploder);
            }
            case NETHERBRICK: {
                return Blocks.field_150385_bj.func_149638_a(exploder);
            }
            case QUARTZ: {
                return Blocks.field_150371_ca.func_149638_a(exploder);
            }
            case ENDSTONE: {
                return Blocks.field_150377_bs.func_149638_a(exploder);
            }
            case PACKEDICE: {
                return Blocks.field_150403_cj.func_149638_a(exploder);
            }
            case SNOW: {
                return Blocks.field_150433_aE.func_149638_a(exploder);
            }
            case MARBLE: {
                return 10.0f;
            }
            case LIMESTONE: {
                return 10.0f;
            }
            case BASALT: {
                return 20.0f;
            }
            case DWEMER: {
                return 20.0f;
            }
        }
        return 1.5f;
    }

    public ItemStack getRawMaterialBlock() {
        switch (this) {
            case STONE: {
                return new ItemStack(Blocks.field_150348_b);
            }
            case SANDSTONE: {
                return new ItemStack(Blocks.field_150322_A);
            }
            case REDSANDSTONE: {
                return new ItemStack(Blocks.field_180395_cM);
            }
            case OBSIDIAN: {
                return new ItemStack(Blocks.field_150343_Z);
            }
            case NETHERBRICK: {
                return new ItemStack(Blocks.field_150385_bj);
            }
            case QUARTZ: {
                return new ItemStack(Blocks.field_150371_ca);
            }
            case ENDSTONE: {
                return new ItemStack(Blocks.field_150377_bs);
            }
            case PACKEDICE: {
                return new ItemStack(Blocks.field_150403_cj);
            }
            case SNOW: {
                return new ItemStack(Blocks.field_150433_aE);
            }
            case MARBLE: {
                return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("chisel", "marble2")), 1, 7);
            }
            case LIMESTONE: {
                return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("chisel", "limestone2")), 1, 7);
            }
            case BASALT: {
                return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("chisel", "basalt2")), 1, 7);
            }
            case DWEMER: {
                return new ItemStack(CathedralMod.dwarven.blockCarved, 1, FeatureTypes.EnumCarvedType.PANEL.getMetadata());
            }
        }
        return ItemStack.field_190927_a;
    }

    public ResourceLocation getFlatTexture() {
        switch (this) {
            case STONE: {
                return new ResourceLocation("blocks/stone");
            }
            case SANDSTONE: {
                return new ResourceLocation("chisel:blocks/sandstoneyellow/raw");
            }
            case REDSANDSTONE: {
                return new ResourceLocation("chisel:blocks/sandstonered/raw");
            }
            case OBSIDIAN: {
                return new ResourceLocation("chisel:blocks/obsidian/panel");
            }
            case NETHERBRICK: {
                return new ResourceLocation("cathedral:blocks/cathedral/netherbrick_default");
            }
            case QUARTZ: {
                return new ResourceLocation("chisel:blocks/quartz/raw");
            }
            case ENDSTONE: {
                return new ResourceLocation("chisel:blocks/endstone/raw");
            }
            case PACKEDICE: {
                return new ResourceLocation("cathedral:blocks/extras/block_packedice_base");
            }
            case SNOW: {
                return new ResourceLocation("blocks/snow");
            }
            case MARBLE: {
                return new ResourceLocation("chisel:blocks/marble/raw");
            }
            case LIMESTONE: {
                return new ResourceLocation("chisel:blocks/limestone/raw");
            }
            case BASALT: {
                return new ResourceLocation("chisel:blocks/basalt/raw");
            }
            case DWEMER: {
                return new ResourceLocation("chisel:blocks/basalt/raw");
            }
        }
        return new ResourceLocation("blocks/dirt");
    }

    public ResourceLocation getBevelledTexture() {
        switch (this) {
            case STONE: {
                return new ResourceLocation("chisel:blocks/stone/tiles-large");
            }
            case SANDSTONE: {
                return new ResourceLocation("chisel:blocks/sandstoneyellow/tiles-large");
            }
            case REDSANDSTONE: {
                return new ResourceLocation("chisel:blocks/sandstonered/tiles-large");
            }
            case OBSIDIAN: {
                return new ResourceLocation("chisel:blocks/obsidian/panel");
            }
            case NETHERBRICK: {
                return new ResourceLocation("cathedral:blocks/cathedral/netherbrick_default");
            }
            case QUARTZ: {
                return new ResourceLocation("chisel:blocks/quartz/tiles-large");
            }
            case ENDSTONE: {
                return new ResourceLocation("chisel:blocks/endstone/tiles-large");
            }
            case PACKEDICE: {
                return new ResourceLocation("cathedral:blocks/extras/block_packedice_base");
            }
            case SNOW: {
                return new ResourceLocation("blocks/snow");
            }
            case MARBLE: {
                return new ResourceLocation("chisel:blocks/marble/tiles-large");
            }
            case LIMESTONE: {
                return new ResourceLocation("chisel:blocks/limestone/tiles-large");
            }
            case BASALT: {
                return new ResourceLocation("cathedral:blocks/basalt/block_carved_paver");
            }
            case DWEMER: {
                return new ResourceLocation("cathedral:blocks/dwemer/block_carved_panel");
            }
        }
        return new ResourceLocation("blocks/dirt");
    }

    static {
        VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMaterial.class);
    }
}

