/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.dwarven;

import com.ferreusveritas.cathedral.CathedralMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockShortDoor
extends BlockDoor {
    ItemDoor doorItem;

    public BlockShortDoor(Material materialIn, String name) {
        super(materialIn);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(CathedralMod.tabDwemer);
    }

    public BlockShortDoor setDoorItem(ItemDoor doorItem) {
        this.doorItem = doorItem;
        return this;
    }

    public ItemDoor getDoorItem() {
        return this.doorItem;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)this.doorItem);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.getDoorItem();
    }

    public BlockPos getPartnerPos(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean hingeOnRight = state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return hingeOnRight ? pos.func_177978_c() : pos.func_177968_d();
            }
            case SOUTH: {
                return hingeOnRight ? pos.func_177974_f() : pos.func_177976_e();
            }
            case WEST: {
                return hingeOnRight ? pos.func_177968_d() : pos.func_177978_c();
            }
            case NORTH: 
        }
        return hingeOnRight ? pos.func_177976_e() : pos.func_177974_f();
    }

    public void setDoorAjar(World worldIn, BlockPos pos, boolean open) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this) {
            IBlockState bottomState;
            BlockPos bottomPos = iblockstate.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
            IBlockState iBlockState = bottomState = pos == bottomPos ? iblockstate : worldIn.func_180495_p(bottomPos);
            if (bottomState.func_177230_c() == this && (Boolean)bottomState.func_177229_b((IProperty)BlockDoor.field_176519_b) != open) {
                BlockShortDoor partnerBlock;
                boolean isPartnerOpen;
                worldIn.func_180501_a(bottomPos, bottomState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(open)), 10);
                worldIn.func_175704_b(bottomPos, bottomPos.func_177984_a());
                worldIn.func_180498_a((EntityPlayer)null, open ? this.getOpenSound() : this.getCloseSound(), pos, 0);
                BlockPos partnerPos = this.getPartnerPos(bottomState, (IBlockAccess)worldIn, bottomPos);
                IBlockState partnerState = worldIn.func_180495_p(partnerPos);
                if (partnerState.func_177230_c() == this && (isPartnerOpen = (partnerBlock = (BlockShortDoor)partnerState.func_177230_c()).isDoorAjar(partnerState, (IBlockAccess)worldIn, partnerPos)) != open) {
                    partnerBlock.setDoorAjar(worldIn, partnerPos, open);
                }
            }
        }
    }

    public boolean isDoorAjar(IBlockState state, IBlockAccess access, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, access, pos);
        return actualState.func_177230_c() == this ? (Boolean)actualState.func_177229_b((IProperty)BlockDoor.field_176519_b) : false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos blockpos = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        this.setDoorAjar(worldIn, pos, !this.isDoorAjar(state, (IBlockAccess)worldIn, pos));
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = world.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (neighborBlock != this) {
                iblockstate.func_189546_a(world, blockpos, neighborBlock, fromPos);
            }
        } else {
            boolean invalid = false;
            BlockPos lowerPos = pos;
            BlockPos upperPos = pos.func_177984_a();
            BlockPos underPos = pos.func_177977_b();
            IBlockState lowerState = state;
            IBlockState upperState = world.func_180495_p(upperPos);
            IBlockState underState = world.func_180495_p(underPos);
            if (upperState.func_177230_c() != this) {
                world.func_175698_g(pos);
                invalid = true;
            }
            if (!underState.isSideSolid((IBlockAccess)world, underPos, EnumFacing.UP) && !(underState.func_177230_c() instanceof BlockStairs)) {
                world.func_175698_g(pos);
                invalid = true;
                if (upperState.func_177230_c() == this) {
                    world.func_175698_g(upperPos);
                }
            }
            if (invalid) {
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, lowerState, 0);
                }
            } else {
                boolean isPoweredWorld = world.func_175640_z(pos) || world.func_175640_z(upperPos);
                boolean isPoweredState = (Boolean)upperState.func_177229_b((IProperty)field_176522_N);
                if (neighborBlock != this && (isPoweredWorld || neighborBlock.func_176223_P().func_185897_m()) && isPoweredWorld != isPoweredState) {
                    world.func_180501_a(upperPos, upperState.func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(isPoweredWorld)), 2);
                    boolean isOpen = (Boolean)lowerState.func_177229_b((IProperty)BlockDoor.field_176519_b);
                    if (isPoweredWorld != isOpen) {
                        this.setDoorAjar(world, lowerPos, isPoweredWorld);
                    }
                }
            }
        }
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }
}

