/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.dwarven;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.common.blocks.BlockMultiVariant;
import com.ferreusveritas.cathedral.features.BlockForm;
import com.ferreusveritas.cathedral.features.IFeature;
import com.ferreusveritas.cathedral.features.dwarven.BlockDwarvenBars;
import com.ferreusveritas.cathedral.features.dwarven.BlockDwarvenGlass;
import com.ferreusveritas.cathedral.features.dwarven.BlockShortDoor;
import com.ferreusveritas.cathedral.features.dwarven.BlockTallDoor;
import com.ferreusveritas.cathedral.features.dwarven.FeatureTypes;
import com.ferreusveritas.cathedral.features.dwarven.ItemTallDoor;
import com.ferreusveritas.cathedral.proxy.ModelHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Dwarven
implements IFeature {
    public static final String featureName = "dwemer";
    public Block blockCarved;
    public Block lightNormal;
    public Block glassNormal;
    public Block barsNormal;
    public Block doorNormal;
    public Block doorTall;
    public Item itemDoorNormal;
    public Item itemDoorTall;

    @Override
    public String getName() {
        return featureName;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void createBlocks() {
        this.blockCarved = new BlockMultiVariant<FeatureTypes.EnumCarvedType>(Material.field_151576_e, FeatureTypes.EnumCarvedType.class, this.featureObjectName(BlockForm.BLOCK, "carved")){

            @Override
            public void makeVariantProperty() {
                this.variant = PropertyEnum.func_177709_a((String)"variant", FeatureTypes.EnumCarvedType.class);
            }
        }.func_149647_a(CathedralMod.tabDwemer).func_149711_c(CathedralMod.basalt.basaltHardness).func_149752_b(CathedralMod.basalt.basaltResistance);
        this.lightNormal = new BlockMultiVariant<FeatureTypes.EnumLightType>(Material.field_151576_e, FeatureTypes.EnumLightType.class, this.featureObjectName(BlockForm.LIGHT, "normal")){

            @Override
            public void makeVariantProperty() {
                this.variant = PropertyEnum.func_177709_a((String)"variant", FeatureTypes.EnumLightType.class);
            }
        }.func_149647_a(CathedralMod.tabDwemer).func_149711_c(CathedralMod.basalt.basaltHardness).func_149752_b(CathedralMod.basalt.basaltResistance).func_149715_a(1.0f);
        this.glassNormal = new BlockDwarvenGlass(this.featureObjectName(BlockForm.GLASS, "normal"));
        this.barsNormal = new BlockDwarvenBars(this.featureObjectName(BlockForm.BARS, "normal"));
        this.doorNormal = new BlockShortDoor(Material.field_151573_f, this.featureObjectName(BlockForm.DOOR, "normal")).func_149647_a(CathedralMod.tabDwemer).func_149711_c(3.5f).func_149752_b(CathedralMod.basalt.basaltResistance);
        this.doorTall = new BlockTallDoor(Material.field_151573_f, this.featureObjectName(BlockForm.DOOR, "tall")).func_149647_a(CathedralMod.tabDwemer).func_149711_c(3.5f).func_149752_b(CathedralMod.basalt.basaltResistance);
    }

    @Override
    public void createItems() {
    }

    @Override
    public void registerBlocks(IForgeRegistry<Block> registry) {
        registry.registerAll((IForgeRegistryEntry[])new Block[]{this.blockCarved, this.lightNormal, this.glassNormal, this.barsNormal, this.doorNormal, this.doorTall});
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)((BlockMultiVariant)this.blockCarved).getItemMultiTexture());
        registry.register((IForgeRegistryEntry)((BlockMultiVariant)this.lightNormal).getItemMultiTexture());
        registry.register((IForgeRegistryEntry)((BlockMultiVariant)this.glassNormal).getItemMultiTexture());
        registry.register(new ItemMultiTexture(this.barsNormal, this.barsNormal, new ItemMultiTexture.Mapper(){

            public String apply(ItemStack stack) {
                return BlockDwarvenBars.EnumType.byMetadata(stack.func_77960_j()).getUnlocalizedName();
            }
        }).setRegistryName(this.barsNormal.getRegistryName()));
        ItemDoor itemDoor = new ItemDoor(this.doorNormal);
        ItemTallDoor itemTallDoor = new ItemTallDoor(this.doorTall);
        ((Item)itemDoor.func_77655_b(this.doorNormal.func_149739_a()).setRegistryName(this.doorNormal.getRegistryName())).func_77637_a(CathedralMod.tabDwemer);
        ((Item)itemTallDoor.func_77655_b(this.doorTall.func_149739_a()).setRegistryName(this.doorTall.getRegistryName())).func_77637_a(CathedralMod.tabDwemer);
        ((BlockShortDoor)this.doorNormal).setDoorItem(itemDoor);
        ((BlockTallDoor)this.doorTall).setDoorItem(itemTallDoor);
        registry.register((IForgeRegistryEntry)itemDoor);
        registry.register((IForgeRegistryEntry)itemTallDoor);
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> registry) {
        String basaltOre = "blockBasalt";
        String metalIngot = OreDictionary.doesOreNameExist((String)"ingotDwemer") && !OreDictionary.getOres((String)"ingotDwemer").isEmpty() ? "ingotDwemer" : (OreDictionary.doesOreNameExist((String)"ingotDawnstone") && !OreDictionary.getOres((String)"ingotDawnstone").isEmpty() ? "ingotDawnstone" : (OreDictionary.doesOreNameExist((String)"ingotBrass") && !OreDictionary.getOres((String)"ingotBrass").isEmpty() ? "ingotBrass" : (OreDictionary.doesOreNameExist((String)"ingotBronze") && !OreDictionary.getOres((String)"ingotBronze").isEmpty() ? "ingotBronze" : "ingotGold")));
        registry.register(new ShapedOreRecipe(null, new ItemStack(this.blockCarved, 16, 0), new Object[]{"bbb", "bib", "bbb", Character.valueOf('b'), basaltOre, Character.valueOf('i'), metalIngot}).setRegistryName("cathedral", "dwemer_stone"));
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "dwemer_light"), null, (ItemStack)new ItemStack(this.lightNormal, 2, 0), (Object[])new Object[]{"xgx", "glg", "xgx", Character.valueOf('x'), new ItemStack(this.blockCarved, 1, 0), Character.valueOf('l'), Blocks.field_150426_aN, Character.valueOf('g'), new ItemStack((Block)Blocks.field_150399_cn, 1, 4)});
        registry.register(new ShapedOreRecipe(null, new ItemStack(this.barsNormal, 16, 0), new Object[]{"iii", "iii", Character.valueOf('i'), metalIngot}).setRegistryName("cathedral", "dwemer_bars"));
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "dwemer_door_tall"), null, (ItemStack)new ItemStack((Item)((BlockTallDoor)this.doorTall).getDoorItem(), 1), (Object[])new Object[]{"x", "x", "x", Character.valueOf('x'), new ItemStack(this.blockCarved, 1, 8)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "dwemer_door_normal"), null, (ItemStack)new ItemStack((Item)((BlockShortDoor)this.doorNormal).getDoorItem(), 1), (Object[])new Object[]{"x", "x", Character.valueOf('x'), new ItemStack(this.blockCarved, 1, 8)});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ((BlockMultiVariant)this.blockCarved).registerItemModels();
        ((BlockMultiVariant)this.lightNormal).registerItemModels();
        ((BlockMultiVariant)this.glassNormal).registerItemModels();
        for (BlockDwarvenBars.EnumType type : BlockDwarvenBars.EnumType.values()) {
            ModelHelper.regModel(Item.func_150898_a((Block)this.barsNormal), type.getMetadata(), new ResourceLocation("cathedral", this.barsNormal.getRegistryName().func_110623_a() + "." + type.getUnlocalizedName()));
        }
        ModelLoader.setCustomStateMapper((Block)this.doorNormal, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)this.doorTall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelHelper.regModel((Item)((BlockShortDoor)this.doorNormal).getDoorItem(), 0, this.doorNormal.getRegistryName());
        ModelHelper.regModel(((BlockTallDoor)this.doorTall).getDoorItem(), 0, this.doorTall.getRegistryName());
    }

    @Override
    public void init() {
        ((BlockMultiVariant)this.blockCarved).addChiselVariation(featureName);
        ((BlockMultiVariant)this.lightNormal).addChiselVariation("dwemerlight");
        ((BlockMultiVariant)this.glassNormal).addChiselVariation("glass");
        for (BlockDwarvenBars.EnumType type : BlockDwarvenBars.EnumType.values()) {
            this.addChiselVariation("dwemerbars", this.barsNormal, type.getMetadata());
        }
    }

    private void addChiselVariation(String group, Block block, int meta) {
        FMLInterModComms.sendMessage((String)"chisel", (String)"variation:add", (String)(group + "|" + block.getRegistryName() + "|" + meta));
    }

    @Override
    public void postInit() {
    }
}

