/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.dwarven;

import com.ferreusveritas.cathedral.features.dwarven.BlockTallDoor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemTallDoor
extends Item {
    private final Block block;

    public ItemTallDoor(Block block) {
        this.block = block;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, itemstack = player.func_184586_b(hand)) && this.block.func_176196_c(worldIn, pos)) {
            EnumFacing enumfacing = EnumFacing.func_176733_a((double)player.field_70177_z);
            int x = enumfacing.func_82601_c();
            int z = enumfacing.func_82599_e();
            boolean isRightHinge = x < 0 && hitZ < 0.5f || x > 0 && hitZ > 0.5f || z < 0 && hitX > 0.5f || z > 0 && hitX < 0.5f;
            ItemTallDoor.placeDoor(worldIn, pos, enumfacing, this.block, isRightHinge);
            SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void placeDoor(World worldIn, BlockPos lowerPos, EnumFacing facing, Block door, boolean isRightHinge) {
        boolean doorOnRight;
        BlockPos rightPos = lowerPos.func_177972_a(facing.func_176746_e());
        BlockPos leftPos = lowerPos.func_177972_a(facing.func_176735_f());
        int leftCount = (worldIn.func_180495_p(leftPos).func_185915_l() ? 1 : 0) + (worldIn.func_180495_p(leftPos.func_177984_a()).func_185915_l() ? 1 : 0);
        int rightCount = (worldIn.func_180495_p(rightPos).func_185915_l() ? 1 : 0) + (worldIn.func_180495_p(rightPos.func_177984_a()).func_185915_l() ? 1 : 0);
        boolean doorOnLeft = worldIn.func_180495_p(leftPos).func_177230_c() == door || worldIn.func_180495_p(leftPos.func_177984_a()).func_177230_c() == door;
        boolean bl = doorOnRight = worldIn.func_180495_p(rightPos).func_177230_c() == door || worldIn.func_180495_p(rightPos.func_177984_a()).func_177230_c() == door;
        if ((!doorOnLeft || doorOnRight) && rightCount <= leftCount) {
            if (doorOnRight && !doorOnLeft || rightCount < leftCount) {
                isRightHinge = false;
            }
        } else {
            isRightHinge = true;
        }
        BlockPos middlePos = lowerPos.func_177984_a();
        BlockPos upperPos = lowerPos.func_177981_b(2);
        boolean powered = worldIn.func_175640_z(lowerPos) || worldIn.func_175640_z(middlePos) || worldIn.func_175640_z(upperPos);
        IBlockState iblockstate = door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(isRightHinge ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)).func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(powered));
        worldIn.func_180501_a(lowerPos, iblockstate.func_177226_a(BlockTallDoor.THIRD, (Comparable)((Object)BlockTallDoor.EnumDoorThird.LOWER)), 2);
        worldIn.func_180501_a(middlePos, iblockstate.func_177226_a(BlockTallDoor.THIRD, (Comparable)((Object)BlockTallDoor.EnumDoorThird.MIDDLE)), 2);
        worldIn.func_180501_a(upperPos, iblockstate.func_177226_a(BlockTallDoor.THIRD, (Comparable)((Object)BlockTallDoor.EnumDoorThird.UPPER)), 2);
        worldIn.func_175685_c(lowerPos, door, false);
        worldIn.func_175685_c(middlePos, door, false);
        worldIn.func_175685_c(upperPos, door, false);
    }
}

