/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.roofing;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.BlockForm;
import com.ferreusveritas.cathedral.features.IFeature;
import com.ferreusveritas.cathedral.features.roofing.BlockShinglesHorizontal;
import com.ferreusveritas.cathedral.features.roofing.BlockShinglesSlab;
import com.ferreusveritas.cathedral.features.roofing.BlockShinglesStairs;
import com.ferreusveritas.cathedral.features.roofing.ItemRoofingSlab;
import com.ferreusveritas.cathedral.proxy.ModelHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Roofing
implements IFeature {
    public static final String featureName = "roofing";
    public BlockShinglesStairs roofingShinglesStairsNatural;
    public BlockShinglesStairs[] roofingShinglesStairsColored = new BlockShinglesStairs[EnumDyeColor.values().length];
    public BlockShinglesHorizontal roofingShinglesHorizontalNatural;
    public BlockShinglesHorizontal[] roofingShinglesHorizontalColored = new BlockShinglesHorizontal[EnumDyeColor.values().length];
    public BlockShinglesSlab roofingShinglesSlabNatural;
    public BlockShinglesSlab[] roofingShinglesSlabColored = new BlockShinglesSlab[EnumDyeColor.values().length];
    public Item clayTile;
    public Item firedTile;

    @Override
    public String getName() {
        return featureName;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void createBlocks() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.roofingShinglesStairsColored[color.func_176765_a()] = new BlockShinglesStairs(color, this.featureObjectName(BlockForm.SHINGLES, color.func_176610_l()));
            this.roofingShinglesHorizontalColored[color.func_176765_a()] = new BlockShinglesHorizontal(color, this.featureObjectName(BlockForm.BLOCK, color.func_176610_l()));
            this.roofingShinglesSlabColored[color.func_176765_a()] = new BlockShinglesSlab(color, this.featureObjectName(BlockForm.SLAB, color.func_176610_l()));
        }
        this.roofingShinglesStairsNatural = new BlockShinglesStairs(null, this.featureObjectName(BlockForm.SHINGLES, "natural"));
        this.roofingShinglesHorizontalNatural = new BlockShinglesHorizontal(null, this.featureObjectName(BlockForm.BLOCK, "natural"));
        this.roofingShinglesSlabNatural = new BlockShinglesSlab(null, this.featureObjectName(BlockForm.SLAB, "natural"));
    }

    @Override
    public void createItems() {
        this.clayTile = ((Item)new Item().setRegistryName("claytile")).func_77655_b("claytile").func_77637_a(CathedralMod.tabRoofing);
        this.firedTile = ((Item)new Item().setRegistryName("firedtile")).func_77655_b("firedtile").func_77637_a(CathedralMod.tabRoofing);
    }

    @Override
    public void registerBlocks(IForgeRegistry<Block> registry) {
        registry.registerAll((IForgeRegistryEntry[])this.roofingShinglesStairsColored);
        registry.register((IForgeRegistryEntry)this.roofingShinglesStairsNatural);
        registry.registerAll((IForgeRegistryEntry[])this.roofingShinglesHorizontalColored);
        registry.register((IForgeRegistryEntry)this.roofingShinglesHorizontalNatural);
        registry.register((IForgeRegistryEntry)this.roofingShinglesSlabNatural);
        registry.registerAll((IForgeRegistryEntry[])this.roofingShinglesSlabColored);
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        registry.registerAll((IForgeRegistryEntry[])new Item[]{this.clayTile, this.firedTile});
        registry.register(new ItemBlock((Block)this.roofingShinglesStairsNatural).setRegistryName(this.roofingShinglesStairsNatural.getRegistryName()));
        registry.register(new ItemBlock((Block)this.roofingShinglesHorizontalNatural).setRegistryName(this.roofingShinglesHorizontalNatural.getRegistryName()));
        registry.register(new ItemRoofingSlab((Block)this.roofingShinglesSlabNatural, this.roofingShinglesSlabNatural, this.roofingShinglesHorizontalNatural).setRegistryName(this.roofingShinglesSlabNatural.getRegistryName()));
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            registry.register(new ItemBlock((Block)this.roofingShinglesStairsColored[i]).setRegistryName(this.roofingShinglesStairsColored[i].getRegistryName()));
            registry.register(new ItemBlock((Block)this.roofingShinglesHorizontalColored[i]).setRegistryName(this.roofingShinglesHorizontalColored[i].getRegistryName()));
            registry.register(new ItemRoofingSlab((Block)this.roofingShinglesSlabColored[i], this.roofingShinglesSlabColored[i], this.roofingShinglesHorizontalColored[i]).setRegistryName(this.roofingShinglesSlabColored[i].getRegistryName()));
        }
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> registry) {
        BlockShinglesHorizontal block = this.roofingShinglesHorizontalNatural;
        BlockShinglesStairs stairs = this.roofingShinglesStairsNatural;
        BlockShinglesSlab slab = this.roofingShinglesSlabNatural;
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "claytile"), null, (ItemStack)new ItemStack(this.clayTile, 16, 0), (Object[])new Object[]{" x ", "x x", Character.valueOf('x'), Items.field_151119_aD});
        GameRegistry.addSmelting((ItemStack)new ItemStack(this.clayTile), (ItemStack)new ItemStack(this.firedTile), (float)0.1f);
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_block_natural"), null, (ItemStack)new ItemStack((Block)block), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(this.firedTile)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_stairs_natural"), null, (ItemStack)new ItemStack((Block)stairs, 4), (Object[])new Object[]{"x ", "xx", Character.valueOf('x'), new ItemStack((Block)block)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_slab_natural"), null, (ItemStack)new ItemStack((Block)slab, 4), (Object[])new Object[]{"xx", Character.valueOf('x'), new ItemStack((Block)block)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_slab_natural_back"), null, (ItemStack)new ItemStack((Block)block), (Object[])new Object[]{"x", "x", Character.valueOf('x'), new ItemStack((Block)slab)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_stairs_natural_back"), null, (ItemStack)new ItemStack((Block)block, 3), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Block)stairs)});
        OreDictionary.registerOre((String)"clayshingles", (ItemStack)new ItemStack((Block)this.roofingShinglesHorizontalNatural));
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (EnumDyeColor color : EnumDyeColor.values()) {
            String colorName = color.func_176610_l();
            block = this.roofingShinglesHorizontalColored[color.func_176765_a()];
            stairs = this.roofingShinglesStairsColored[color.func_176765_a()];
            slab = this.roofingShinglesSlabColored[color.func_176765_a()];
            OreDictionary.registerOre((String)"clayshingles", (ItemStack)new ItemStack((Block)this.roofingShinglesHorizontalColored[color.func_176765_a()]));
            registry.register(new ShapedOreRecipe(null, new ItemStack((Block)this.roofingShinglesHorizontalColored[color.func_176765_a()], 8, 0), new Object[]{"xxx", "xcx", "xxx", Character.valueOf('x'), "clayshingles", Character.valueOf('c'), dyes[color.func_176767_b()]}).setRegistryName("clayshingles_" + colorName));
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_block_" + colorName), null, (ItemStack)new ItemStack((Block)block), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(this.firedTile)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_stairs_" + colorName), null, (ItemStack)new ItemStack((Block)stairs, 4), (Object[])new Object[]{"x ", "xx", Character.valueOf('x'), new ItemStack((Block)block)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_slab_" + colorName), null, (ItemStack)new ItemStack((Block)slab, 4), (Object[])new Object[]{"xx", Character.valueOf('x'), new ItemStack((Block)block)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_slab_" + colorName + "_back"), null, (ItemStack)new ItemStack((Block)block), (Object[])new Object[]{"x", "x", Character.valueOf('x'), new ItemStack((Block)slab)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", "roof_stairs_" + colorName + "_back"), null, (ItemStack)new ItemStack((Block)block, 3), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Block)stairs)});
        }
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelHelper.regModel(this.clayTile);
        ModelHelper.regModel(this.firedTile);
        ModelHelper.regModel((Block)this.roofingShinglesStairsNatural);
        ModelHelper.regModel((Block)this.roofingShinglesHorizontalNatural);
        ModelHelper.regModel((Block)this.roofingShinglesSlabNatural);
        for (BlockShinglesStairs blockShinglesStairs : this.roofingShinglesStairsColored) {
            ModelHelper.regModel((Block)blockShinglesStairs);
        }
        for (BlockShinglesHorizontal blockShinglesHorizontal : this.roofingShinglesHorizontalColored) {
            ModelHelper.regModel((Block)blockShinglesHorizontal);
        }
        for (BlockShinglesSlab blockShinglesSlab : this.roofingShinglesSlabColored) {
            ModelHelper.regModel((Block)blockShinglesSlab);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }
}

