/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos;

import eu.ha3.matmos.ConfigManager;
import eu.ha3.matmos.abstraction.util.ASoundCategory;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.expansion.Stable;
import eu.ha3.matmos.core.expansion.VolumeUpdatable;
import eu.ha3.matmos.core.preinit.SoundSystemReplacerTransformer;
import eu.ha3.matmos.core.sound.LoopingStreamedSoundManager;
import eu.ha3.matmos.core.sound.Simulacrum;
import eu.ha3.matmos.core.sound.SoundManagerListener;
import eu.ha3.matmos.debug.Pluggable;
import eu.ha3.matmos.game.user.UserControl;
import eu.ha3.matmos.game.user.VisualDebugger;
import eu.ha3.matmos.lib.eu.ha3.easy.StopWatchStatistic;
import eu.ha3.matmos.lib.eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.Identity;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.OperatorCaster;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.UpdatableIdentity;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonIdentity;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonImpl;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonVersion;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsBlockChangeEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsClientTickEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsInGameChangeEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsSoundEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsSoundSetupEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.event.BlockChangeEvent;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.chat.Chatter;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.update.NotifiableHaddon;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.update.UpdateNotifier;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.ConfigProperty;
import eu.ha3.matmos.util.MAtUtil;
import eu.ha3.matmos.util.NoOpLogger;
import eu.ha3.matmos.util.TickProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.settings.GameSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import paulscode.sound.SoundSystemConfig;

public class Matmos
extends HaddonImpl
implements SupportsFrameEvents,
SupportsClientTickEvents,
SupportsInGameChangeEvents,
SupportsBlockChangeEvents,
SupportsSoundEvents,
SupportsSoundSetupEvents,
NotifiableHaddon,
Stable {
    private static final boolean _COMPILE_IS_UNSTABLE = false;
    public static final boolean VERBOSE_ENGINE_LOGGING = Boolean.parseBoolean(System.getProperty("matmos.log.engine", "false"));
    public static final boolean VERBOSE_SOUNDPACK_LOGGING = Boolean.parseBoolean(System.getProperty("matmos.log.soundpack", "false"));
    public static final Logger LOGGER = LogManager.getLogger((String)"matmos");
    public static Logger DEVLOGGER = NoOpLogger.INSTANCE;
    public static Logger ALIASLOGGER = NoOpLogger.INSTANCE;
    public static final Logger DEBUGLOGGER = VERBOSE_ENGINE_LOGGING ? LOGGER : NoOpLogger.INSTANCE;
    protected static final String NAME = "MAtmos";
    protected static final String VERSION = "36.0.1";
    protected static final String FOR = "1.12.2";
    protected static final String ADDRESS = "https://github.com/makamys/MAtmos";
    protected static final String UPDATE_JSON = "https://raw.githubusercontent.com/makamys/MAtmos/master/updatejson/update-matmos.json";
    public static final Identity identity = new HaddonIdentity("MAtmos", "36.0.1", "1.12.2", "https://github.com/makamys/MAtmos");
    private final ConfigProperty config = ConfigManager.getConfig();
    private final Chatter chatter = new Chatter(this, "<MAtmos> ");
    private final UpdateNotifier updateNotifier = new UpdateNotifier((NotifiableHaddon)this, new HaddonVersion("1.12.2-36.0.1"), "https://raw.githubusercontent.com/makamys/MAtmos/master/updatejson/update-matmos.json");
    private final LoopingStreamedSoundManager soundManager = new LoopingStreamedSoundManager();
    private Optional<Simulacrum> simulacrum = Optional.empty();
    private boolean isUnderwaterMode;
    private boolean isDebugMode;
    private boolean queuedActivate;
    private boolean queuedActivateParameter;
    private static List<SupportsBlockChangeEvents> blockChangeListeners = new LinkedList<SupportsBlockChangeEvents>();
    private static List<SoundManagerListener> soundManagerListeners = new LinkedList<SoundManagerListener>();
    private UserControl userControl;
    private boolean hasFirstTickPassed;
    private StopWatchStatistic timeStat = new StopWatchStatistic();
    private Object queueLock = new Object();
    private List<Runnable> queue = new ArrayList<Runnable>();
    private boolean hasResourcePacks_FixMe;

    @Override
    public void onLoad() {
        if (SoundSystemReplacerTransformer.hasMadeChanges()) {
            LOGGER.info("Overriding SoundSystem was successful!");
        } else {
            LOGGER.info("SoundSystem was not overridden.");
        }
        ((OperatorCaster)this.op()).setTickEnabled(true);
        ((OperatorCaster)this.op()).setFrameEnabled(true);
        TimeStatistic timeMeasure = new TimeStatistic(Locale.ENGLISH);
        this.userControl = new UserControl(this);
        this.updateNotifier.fillDefaults(this.config);
        this.config.setProperty("version.last", VERSION);
        this.config.setProperty("version.warnunstable", (Object)3);
        this.config.commit();
        this.resetAmbientVolume();
        this.updateNotifier.loadConfig(this.config);
        this.userControl.load();
        soundManagerListeners.add(this.soundManager);
        soundManagerListeners.add(new SoundManagerListener(){

            @Override
            public void onLoadSoundSystem(boolean load) {
                if (!load && Matmos.this.isActivated()) {
                    Matmos.this.refresh();
                }
            }
        });
        LOGGER.info("Took " + timeMeasure.getSecondsAsString(3) + " seconds to setup MAtmos base.");
    }

    private void resetAmbientVolume() {
        this.setSoundLevelAmbient(this.config.getFloat("minecraftsound.ambient.volume"));
    }

    private void overrideAmbientVolume() {
        if (this.config.getFloat("minecraftsound.ambient.volume") <= 0.0f) {
            return;
        }
        this.setSoundLevelAmbient(0.01f);
    }

    private void setSoundLevelAmbient(float level) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        settings.func_186712_a(ASoundCategory.AMBIENT, level);
        settings.func_186712_a(ASoundCategory.AMBIENT, level);
    }

    public void start() {
        this.refresh();
    }

    public void refresh() {
        this.deactivate();
        this.activate(false);
    }

    @Override
    public boolean isActivated() {
        return this.simulacrum.isPresent();
    }

    @Override
    public void activate() {
        this.activate(true);
    }

    public void activate(boolean reloadConfigs) {
        if (this.isActivated()) {
            return;
        }
        if (!Minecraft.func_71410_x().func_147118_V().field_147694_f.field_148617_f) {
            this.queuedActivate = true;
            this.queuedActivateParameter = reloadConfigs;
            return;
        }
        this.queuedActivate = false;
        LOGGER.info("Loading...");
        if (reloadConfigs) {
            this.config.load();
        }
        DEVLOGGER = VERBOSE_SOUNDPACK_LOGGING || ConfigManager.getConfig().getInteger("debug.mode") == 1 ? LOGGER : NoOpLogger.INSTANCE;
        ALIASLOGGER = ConfigManager.getConfig().getBoolean("log.category.aliasmap") ? LOGGER : NoOpLogger.INSTANCE;
        this.simulacrum = Optional.of(new Simulacrum(this));
        LOGGER.info("Loaded.");
    }

    @Override
    public void deactivate() {
        if (!this.isActivated()) {
            return;
        }
        LOGGER.info("Stopping...");
        this.simulacrum.get().dispose();
        this.soundManager.dispose();
        this.simulacrum = Optional.empty();
        LOGGER.info("Stopped.");
    }

    @Override
    public void onFrame(float semi) {
        if (!this.isActivated() || this.util().isGamePaused()) {
            return;
        }
        TickProfiler.start();
        this.simulacrum.get().onFrame(semi);
        this.userControl.onFrame(semi);
        TickProfiler.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTick() {
        TickProfiler.start(true);
        this.userControl.onTick();
        if (this.queuedActivate) {
            this.activate(this.queuedActivateParameter);
        }
        if (this.isActivated()) {
            if (!this.queue.isEmpty()) {
                Object object = this.queueLock;
                synchronized (object) {
                    while (!this.queue.isEmpty()) {
                        this.queue.remove(0).run();
                    }
                }
            }
            this.timeStat.reset();
            this.simulacrum.get().onTick();
            this.timeStat.stop();
            if (MAtUtil.isUnderwaterAnyGamemode()) {
                if (!this.isUnderwaterMode) {
                    this.isUnderwaterMode = true;
                    this.overrideAmbientVolume();
                }
            } else if (this.isUnderwaterMode) {
                this.isUnderwaterMode = false;
                this.resetAmbientVolume();
            }
            if (!this.hasFirstTickPassed) {
                this.hasFirstTickPassed = true;
                this.updateNotifier.attempt();
                boolean bl = this.isDebugMode = this.config.getInteger("debug.mode") > 0;
                if (this.isDebugMode()) {
                    this.getChatter().printChat(ATextFormatting.GOLD, "Developer mode is enabled in the Advanced options.");
                    this.getChatter().printChatShort("This affects performance. Your game may run slower.");
                }
                if (!this.simulacrum.get().hasResourcePacks()) {
                    this.hasResourcePacks_FixMe = true;
                    if (this.simulacrum.get().hasDisabledResourcePacks()) {
                        this.chatter.printChat(ATextFormatting.RED, "Resource Pack not enabled yet!");
                        this.chatter.printChatShort(ATextFormatting.WHITE, "You need to activate \"MAtmos Resource Pack\" in the Minecraft Options menu for it to run.");
                    } else {
                        this.chatter.printChat(ATextFormatting.RED, "Resource Pack missing from resourcepacks/!");
                        this.chatter.printChatShort(ATextFormatting.WHITE, "You may have forgotten to put the Resource Pack file into your resourcepacks/ folder.");
                    }
                }
            }
            if (this.hasResourcePacks_FixMe && this.simulacrum.get().hasResourcePacks()) {
                this.hasResourcePacks_FixMe = false;
                this.chatter.printChat(ATextFormatting.GREEN, "It should work now!");
            }
        } else if (this.isUnderwaterMode) {
            this.isUnderwaterMode = false;
            this.resetAmbientVolume();
        }
        this.soundManager.onTick();
        TickProfiler.end();
    }

    @Override
    public void dispose() {
        if (this.isActivated()) {
            this.simulacrum.get().dispose();
        }
    }

    @Override
    public void interrupt() {
        if (this.isActivated()) {
            this.simulacrum.get().interruptBrutally();
        }
    }

    public Map<String, Expansion> getExpansionList() {
        if (this.isActivated()) {
            return this.simulacrum.get().getExpansions();
        }
        return Collections.EMPTY_MAP;
    }

    public boolean isInitialized() {
        return true;
    }

    @Override
    public Identity getIdentity() {
        return identity;
    }

    @Override
    public Chatter getChatter() {
        return this.chatter;
    }

    @Override
    public ConfigProperty getConfig() {
        return ConfigManager.getConfig();
    }

    @Override
    public void saveConfig() {
        if (this.config.commit()) {
            LOGGER.info("Saving configuration...");
            this.config.save();
        }
    }

    public LoopingStreamedSoundManager getSoundManager() {
        return this.soundManager;
    }

    public VolumeUpdatable getGlobalVolumeControl() {
        return this.simulacrum.get().getGlobalVolumeControl();
    }

    public boolean hasResourcePacksLoaded() {
        return this.isActivated() && this.simulacrum.get().hasResourcePacks();
    }

    public boolean hasNonethelessResourcePacksInstalled() {
        return this.isActivated() && this.simulacrum.get().hasDisabledResourcePacks();
    }

    public void synchronize() {
        if (this.isActivated()) {
            this.simulacrum.get().synchronize();
        }
    }

    public void saveExpansions() {
        if (this.isActivated()) {
            this.simulacrum.get().saveConfig();
        }
    }

    public void addUpdateNotifierJob(UpdatableIdentity id) {
        this.updateNotifier.addJob(id);
    }

    public void attemptUpdateNotifier() {
        this.updateNotifier.attempt();
    }

    public VisualDebugger getVisualDebugger() {
        return this.simulacrum.get().getVisualDebugger();
    }

    public StopWatchStatistic getLag() {
        return this.timeStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueForNextTick(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.add(runnable);
        }
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void changedDebugMode() {
        boolean bl = this.isDebugMode = this.config.getInteger("debug.mode") > 0;
        if (this.isDebugMode()) {
            this.getChatter().printChat(ATextFormatting.GOLD, "Dev/Editor mode enabled.");
            this.getChatter().printChatShort("Enabling this mode may cause Minecraft to run slower.");
        } else {
            this.getChatter().printChat(ATextFormatting.GOLD, "Dev/Editor mode disabled.");
        }
        this.refresh();
    }

    public boolean isEditorAvailable() {
        return this.util().isPresent("eu.ha3.matmos.editor.EditorMaster");
    }

    public Runnable instantiateRunnableEditor(Pluggable pluggable) {
        return (Runnable)this.util().getInstantiator("eu.ha3.matmos.editor.EditorMaster", Pluggable.class).instantiate(pluggable);
    }

    public Optional<Expansion> getExpansionEffort(String expansionName) {
        if (!this.isActivated() || !this.simulacrum.get().getExpansions().containsKey(expansionName)) {
            return Optional.empty();
        }
        return Optional.of(this.simulacrum.get().getExpansions().get(expansionName));
    }

    @Override
    public void onInGameChange(boolean inGame) {
        if (inGame) {
            if (this.config.getBoolean("start.enabled")) {
                this.start();
            }
        } else {
            this.deactivate();
        }
    }

    @Override
    public void onBlockChanged(BlockChangeEvent event) {
        blockChangeListeners.forEach(l -> l.onBlockChanged(event));
    }

    public static void addBlockChangeListener(SupportsBlockChangeEvents l) {
        blockChangeListeners.add(l);
    }

    public static void removeBlockChangeListener(SupportsBlockChangeEvents l) {
        blockChangeListeners.remove(l);
    }

    @Override
    public boolean onSound(ISound sound, String name, SoundManager manager) {
        boolean badSound = this.shouldSuppressRain() && this.simulacrum.isPresent() && !this.simulacrum.get().getExpansions().isEmpty() && Arrays.asList(this.config.getString("rain.soundlist").split(",")).contains(name);
        return !badSound;
    }

    @Override
    public void onSoundSetup(SoundManager soundManager) {
        int streamingChans;
        int normalChans;
        String channelChangeOption = this.config.getString("soundsystem.changechannelcount");
        boolean doChange = false;
        if (channelChangeOption.equals("true")) {
            LOGGER.trace("Changing sound system channel count unconditionally because option is set to 'true'");
        } else if (channelChangeOption.equals("auto")) {
            normalChans = SoundSystemConfig.getNumberNormalChannels();
            streamingChans = SoundSystemConfig.getNumberStreamingChannels();
            if (normalChans == 28 && streamingChans == 4) {
                doChange = true;
                LOGGER.trace("Changing sound system channel count because no one else changed it");
            } else {
                LOGGER.trace("Not changing sound system channel count because someone else changed it (to " + normalChans + " normal + " + streamingChans + " streaming)");
            }
        } else {
            LOGGER.trace("Not changing sound system channel count because option is set to false");
        }
        if (doChange) {
            normalChans = this.config.getInteger("soundsystem.changechannelcount.normal");
            streamingChans = this.config.getInteger("soundsystem.changechannelcount.streaming");
            int totalChans = 64;
            if (normalChans == -1 && streamingChans == -1) {
                streamingChans = 11;
            }
            if (normalChans == -1) {
                normalChans = 64 - streamingChans;
            }
            if (streamingChans == -1) {
                streamingChans = 64 - normalChans;
            }
            SoundSystemConfig.setNumberStreamingChannels((int)streamingChans);
            SoundSystemConfig.setNumberNormalChannels((int)normalChans);
            LOGGER.info("Changing SoundSystem channel count to " + normalChans + " normal + " + streamingChans + " streaming.");
        }
        if (this.config.getBoolean("soundsystem.changestreamqueueformatsmatch")) {
            SoundSystemConfig.setStreamQueueFormatsMatch((boolean)true);
        }
    }

    public boolean shouldSuppressRain() {
        String suppressOption = this.config.getString("rain.suppress");
        return suppressOption.equals("true") || suppressOption.equals("auto") && this.simulacrum.isPresent() && this.simulacrum.get().hasRainMuteableExpansions();
    }

    public static List<SoundManagerListener> getSoundManagerListeners() {
        return soundManagerListeners;
    }
}

