/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core;

import eu.ha3.matmos.core.Named;
import eu.ha3.matmos.core.VersionListener;
import eu.ha3.matmos.core.Versioned;
import java.util.HashSet;
import java.util.Set;

public abstract class Component
implements Named,
Versioned {
    private final String name;
    private final Set<VersionListener> listeners;
    private int version;

    public Component(String name) {
        this.name = name;
        this.listeners = new HashSet<VersionListener>();
        this.version = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[(" + this.getClass().toString() + ") " + this.name + "]";
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public void incrementVersion() {
        ++this.version;
        for (VersionListener listener : this.listeners) {
            listener.onIncrement(this);
        }
    }

    @Override
    public void registerVersionListener(VersionListener listener) {
        this.listeners.add(listener);
    }
}

