/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Dependable;
import eu.ha3.matmos.core.Dynamic;
import eu.ha3.matmos.core.Evaluated;
import eu.ha3.matmos.core.MappedProvider;
import eu.ha3.matmos.core.Named;
import eu.ha3.matmos.core.Operator;
import eu.ha3.matmos.core.PossibilityList;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.ProviderCollection;
import eu.ha3.matmos.core.Providers;
import eu.ha3.matmos.core.ReferenceTime;
import eu.ha3.matmos.core.Simulated;
import eu.ha3.matmos.core.SoundRelay;
import eu.ha3.matmos.core.event.Event;
import eu.ha3.matmos.core.expansion.ExpansionIdentity;
import eu.ha3.matmos.core.expansion.ExpansionManager;
import eu.ha3.matmos.core.logic.Condition;
import eu.ha3.matmos.core.logic.Junction;
import eu.ha3.matmos.core.logic.Machine;
import eu.ha3.matmos.core.sfx.BlockChangeSound;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.Sheet;
import eu.ha3.matmos.core.sheet.SheetCommander;
import eu.ha3.matmos.core.sheet.SheetDataPackage;
import eu.ha3.matmos.core.sheet.SheetEntry;
import eu.ha3.matmos.core.sheet.SheetIndex;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.event.BlockChangeEvent;
import eu.ha3.matmos.util.BetterStreams;
import eu.ha3.matmos.util.MAtUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.item.Item;

public class Knowledge
implements Evaluated,
Simulated {
    private DataPackage data;
    private final Map<String, Dynamic> dynamicMapped = new HashMap<String, Dynamic>();
    private final Map<String, PossibilityList> possibilityMapped = new HashMap<String, PossibilityList>();
    private final Map<String, Condition> conditionMapped = new HashMap<String, Condition>();
    private final Map<String, Junction> junctionMapped = new HashMap<String, Junction>();
    private final Map<String, Machine> machineMapped = new HashMap<String, Machine>();
    private final Map<String, Event> eventMapped = new HashMap<String, Event>();
    private final Map<String, BlockChangeSound> blockChangeMapped = new HashMap<String, BlockChangeSound>();
    private final Map<String, String> conditionValueOverrides = new HashMap<String, String>();
    private final SheetCommander<String> sheetCommander = new SheetCommander<String>(){

        @Override
        public int version(SheetIndex sheetIndex) {
            return Knowledge.this.data.getSheet(sheetIndex.getSheet()).version(sheetIndex.getIndex());
        }

        @Override
        public boolean listHas(String constantX, String value) {
            return Knowledge.this.possibilityMapped.containsKey(constantX) ? ((PossibilityList)Knowledge.this.possibilityMapped.get(constantX)).listHas(value) : false;
        }

        @Override
        public String get(SheetIndex sheetIndex) {
            return Knowledge.this.data.getSheet(sheetIndex.getSheet()).get(sheetIndex.getIndex());
        }

        @Override
        public boolean exists(SheetIndex sheetIndex) {
            return Knowledge.this.data.getSheet(sheetIndex.getSheet()).exists(sheetIndex.getIndex());
        }
    };
    private final Provider<Dynamic> dynamicProvider = new MappedProvider<Dynamic>(this.dynamicMapped);
    private final Provider<Condition> conditionProvider = new MappedProvider<Condition>(this.conditionMapped);
    private final Provider<Junction> junctionProvider = new MappedProvider<Junction>(this.junctionMapped);
    private final Provider<Machine> machineProvider = new MappedProvider<Machine>(this.machineMapped);
    private final Provider<Event> eventProvider = new MappedProvider<Event>(this.eventMapped);
    private final ProviderCollection providerCollection;
    private final SoundRelay relay;

    public Knowledge(SoundRelay relay, ReferenceTime time) {
        this.relay = relay;
        this.providerCollection = new Providers(time, relay, this.sheetCommander, this.conditionProvider, this.junctionProvider, this.machineProvider, this.eventProvider, this.dynamicProvider);
    }

    public void setData(DataPackage data) {
        this.data = data;
    }

    public ProviderCollection obtainProviders() {
        return this.providerCollection;
    }

    public SheetCommander<String> obtainSheetCommander() {
        return this.sheetCommander;
    }

    public void addKnowledge(List<Named> namedThings) {
        for (Named n : namedThings) {
            if (n instanceof Condition) {
                this.conditionMapped.put(n.getName(), (Condition)n);
                continue;
            }
            if (n instanceof Junction) {
                this.junctionMapped.put(n.getName(), (Junction)n);
                continue;
            }
            if (n instanceof Machine) {
                this.machineMapped.put(n.getName(), (Machine)n);
                continue;
            }
            if (n instanceof Event) {
                this.eventMapped.put(n.getName(), (Event)n);
                continue;
            }
            if (n instanceof PossibilityList) {
                this.possibilityMapped.put(n.getName(), (PossibilityList)((Object)n));
                continue;
            }
            if (n instanceof Dynamic) {
                this.dynamicMapped.put(n.getName(), (Dynamic)n);
                continue;
            }
            if (n instanceof BlockChangeSound) {
                this.blockChangeMapped.put(n.getName(), (BlockChangeSound)n);
                continue;
            }
            System.err.println("Cannot handle named element: " + n.getName() + " " + n.getClass());
        }
    }

    public void addKnowledge(Knowledge other) {
        LinkedList<Named> things = new LinkedList<Named>();
        things.addAll(other.conditionMapped.values());
        things.addAll(other.junctionMapped.values());
        things.addAll(other.machineMapped.values());
        things.addAll(other.eventMapped.values());
        for (PossibilityList p : other.possibilityMapped.values()) {
            things.add((Named)((Object)p));
        }
        things.addAll(other.dynamicMapped.values());
        this.addKnowledge(things);
    }

    private void createInvertedJunctions() {
        TreeSet<String> junctionsToInvert = new TreeSet<String>();
        LinkedList<Named> newStuff = new LinkedList<Named>();
        for (String machineName : this.machineMapped.keySet()) {
            Machine m = this.machineMapped.get(machineName);
            for (String dep : m.getDependencies()) {
                if (!dep.startsWith("!")) continue;
                junctionsToInvert.add(dep.substring(1));
            }
        }
        for (String junctionName : junctionsToInvert) {
            Junction junction = this.junctionMapped.get(junctionName);
            if (junction != null) {
                newStuff.add(junction.getInverted());
                continue;
            }
            Matmos.DEVLOGGER.warn("Missing junction: " + junctionName);
        }
        this.addKnowledge(newStuff);
    }

    private void buildIDList() {
        HashSet<String> sheetIndexes = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        for (Condition condition : this.conditionMapped.values()) {
            sheetIndexes.add(condition.getIndex().getIndex());
        }
        for (Dynamic dynamic : this.dynamicMapped.values()) {
            for (SheetIndex si : dynamic.getIndexes()) {
                sheetIndexes.add(si.getIndex());
            }
        }
        for (PossibilityList possibility : this.possibilityMapped.values()) {
            for (String entry : possibility.getList()) {
                sheetIndexes.add(entry);
            }
        }
        for (String index : sheetIndexes) {
            if (index.contains("^")) {
                index = index.substring(0, index.indexOf(94));
            }
            nameSet.add(index);
        }
        if (this.data instanceof SheetDataPackage) {
            ArrayList<Integer> referencedBlockIDs = new ArrayList<Integer>();
            ArrayList<Integer> referencedItemIDs = new ArrayList<Integer>();
            nameSet.stream().forEach(s -> {
                int itemID;
                int blockID = Block.func_149682_b((Block)Block.func_149684_b((String)s));
                if (blockID != -1) {
                    referencedBlockIDs.add(blockID);
                }
                if ((itemID = Item.func_150891_b((Item)MAtUtil.itemRegistryGet(s))) != -1) {
                    referencedItemIDs.add(itemID);
                }
            });
            ((SheetDataPackage)this.data).addReferencedIDs(referencedBlockIDs, referencedItemIDs);
        }
    }

    public void compile() {
        this.buildIDList();
        this.createInvertedJunctions();
        this.purge(this.machineMapped, this.junctionMapped, "junctions");
        this.purge(this.junctionMapped, this.conditionMapped, "conditions");
    }

    public Set<String> calculateRequiredModules() {
        return BetterStreams.of(this.conditionMapped, this.dynamicMapped).flatten(a -> a.getDependencies()).asSet();
    }

    private void purge(Map<String, ? extends Dependable> superior, Map<String, ? extends Dependable> inferior, String inferiorName) {
        TreeSet<String> requirements = new TreeSet<String>();
        TreeSet<String> unused = new TreeSet<String>();
        TreeSet<String> missing = new TreeSet<String>();
        for (Dependable dependable : superior.values()) {
            requirements.addAll(dependable.getDependencies());
        }
        unused.addAll(inferior.keySet());
        unused.removeAll(requirements);
        unused.removeIf(s -> s.startsWith("_"));
        missing.addAll(requirements);
        missing.removeAll(inferior.keySet());
        if (missing.size() > 0) {
            Matmos.DEVLOGGER.warn("Missing " + inferiorName + ": " + Arrays.toString(missing.toArray()));
        }
        if (unused.size() > 0) {
            Matmos.DEVLOGGER.warn("Unused " + inferiorName + ": " + Arrays.toString(unused.toArray()));
            unused.forEach(inferior::remove);
        }
    }

    public void cacheSounds(ExpansionIdentity identity) {
        IResourcePack resourcePack = identity.getPack();
        this.eventMapped.values().forEach(event -> event.cacheSounds(resourcePack));
    }

    @Override
    public void simulate() {
        this.relay.routine();
        this.machineMapped.values().forEach(Machine::simulate);
    }

    @Override
    public void evaluate() {
        if (this.dynamicMapped.size() > 0) {
            Sheet dynamic = this.data.getSheet("_DYNAMIC");
            for (Dynamic o : this.dynamicMapped.values()) {
                o.evaluate();
                dynamic.set(o.getName(), Long.toString(o.getInformation()));
            }
        }
        BetterStreams.of(this.conditionMapped, this.junctionMapped, this.machineMapped).forEach(Evaluated::evaluate);
    }

    public void onBlockChanged(BlockChangeEvent event) {
        event.oldBlock = ExpansionManager.dealias(event.oldBlock, this.data);
        event.newBlock = ExpansionManager.dealias(event.newBlock, this.data);
        this.blockChangeMapped.forEach((k, v) -> v.onBlockChange(event));
    }

    public void setOverrideOff(boolean overrideOff) {
        this.machineMapped.forEach((s, m) -> {
            if (overrideOff) {
                m.overrideForceOff();
            } else {
                m.overrideFinish();
            }
        });
    }

    public boolean hasOverrideRainCondition() {
        return this.conditionMapped.values().stream().anyMatch(c -> c.getIndex().getSheet().equals("meta_option") && c.getIndex().getIndex().equals("override_rain"));
    }

    public void setConditionValueOverrides(Map<String, String> overrides) {
        this.conditionValueOverrides.clear();
        this.conditionValueOverrides.putAll(overrides);
    }

    public Map<String, String> getConditionValueOverrides() {
        return this.conditionValueOverrides;
    }

    public static List<Named> getBuiltins(ProviderCollection providers) {
        return Arrays.asList(new Condition("_RAYCAST_SCAN_OUTDOORS", providers.getSheetCommander(), new SheetEntry("scan_raycast", ".is_outdoors"), Operator.EQUAL, "1"), new Condition("_FLOOD_SCAN_DEEP_INDOORS", providers.getSheetCommander(), new SheetEntry("scan_air", ".is_near_surface"), Operator.EQUAL, "0"), new Junction("_DEEP_INDOORS", providers.getCondition(), Arrays.asList("_FLOOD_SCAN_DEEP_INDOORS"), Arrays.asList("_RAYCAST_SCAN_OUTDOORS")), new Junction("_INDOORS", providers.getCondition(), Arrays.asList(new String[0]), Arrays.asList("_RAYCAST_SCAN_OUTDOORS", "_FLOOD_SCAN_DEEP_INDOORS")), new Junction("_OUTDOORS", providers.getCondition(), Arrays.asList("_RAYCAST_SCAN_OUTDOORS"), Arrays.asList(new String[0])));
    }
}

