/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.event;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Component;
import eu.ha3.matmos.core.SoundRelay;
import eu.ha3.matmos.core.event.EventInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;

public class Event
extends Component
implements EventInterface {
    private static Random random = new Random();
    public final List<String> paths;
    public final float volMin;
    public final float volMax;
    public final float pitchMin;
    public final float pitchMax;
    public final int distance;
    private final SoundRelay relay;

    public Event(String name, SoundRelay relay, List<String> paths, float volMin, float volMax, float pitchMin, float pitchMax, int distance) {
        super(name);
        this.relay = relay;
        this.paths = paths;
        this.volMin = volMin;
        this.volMax = volMax;
        this.pitchMin = pitchMin;
        this.pitchMax = pitchMax;
        this.distance = distance;
    }

    @Override
    public void cacheSounds(IResourcePack resourcePack) {
        IResourcePack def = Minecraft.func_71410_x().func_110438_M().field_110620_b;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String path : this.paths) {
            ResourceLocation location = new ResourceLocation("minecraft", "sounds/" + path);
            if (resourcePack.func_110589_b(location) || def.func_110589_b(location)) {
                this.relay.cacheSound(path);
                continue;
            }
            Matmos.LOGGER.warn("File: " + path + " appears to be missing from: " + resourcePack.func_130077_b() + " [This sound will not be cached or played in-game]");
            toRemove.add(path);
        }
        this.paths.removeAll(toRemove);
    }

    @Override
    public void playSound(float volMod, float pitchMod) {
        if (this.paths.isEmpty()) {
            return;
        }
        float volume = this.volMax - this.volMin;
        float pitch = this.pitchMax - this.pitchMin;
        volume = this.volMin + (volume > 0.0f ? random.nextFloat() * volume : 0.0f);
        pitch = this.pitchMin + (pitch > 0.0f ? random.nextFloat() * pitch : 0.0f);
        String path = this.paths.get(random.nextInt(this.paths.size()));
        this.relay.playSound(path, volume *= volMod, pitch *= pitchMod, this.distance);
    }
}

