/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.expansion;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Evaluated;
import eu.ha3.matmos.core.Knowledge;
import eu.ha3.matmos.core.ProviderCollection;
import eu.ha3.matmos.core.ReferenceTime;
import eu.ha3.matmos.core.Simulated;
import eu.ha3.matmos.core.SystemClock;
import eu.ha3.matmos.core.event.EventInterface;
import eu.ha3.matmos.core.expansion.ExpansionDebugUnit;
import eu.ha3.matmos.core.expansion.ExpansionIdentity;
import eu.ha3.matmos.core.expansion.FolderExpansionDebugUnit;
import eu.ha3.matmos.core.expansion.JsonExpansionDebugUnit;
import eu.ha3.matmos.core.expansion.Stable;
import eu.ha3.matmos.core.expansion.VolumeContainer;
import eu.ha3.matmos.core.expansion.VolumeUpdatable;
import eu.ha3.matmos.core.expansion.agents.LoadingAgent;
import eu.ha3.matmos.core.expansion.agents.RawJsonLoadingAgent;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sound.LoopingStreamedSoundManager;
import eu.ha3.matmos.core.sound.SoundHelperRelay;
import eu.ha3.matmos.data.IDataCollector;
import eu.ha3.matmos.lib.eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsBlockChangeEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.event.BlockChangeEvent;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.ConfigProperty;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.util.ResourceLocation;

public class Expansion
implements VolumeUpdatable,
Stable,
Simulated,
Evaluated,
SupportsBlockChangeEvents {
    private static ReferenceTime TIME = new SystemClock();
    private final ExpansionIdentity identity;
    private final DataPackage data;
    private final IDataCollector collector;
    private final SoundHelperRelay capabilities;
    private final VolumeContainer masterVolume;
    private final ConfigProperty myConfiguration = new ConfigProperty();
    private float volume;
    private boolean isSuccessfullyBuilt;
    private boolean isActive;
    private boolean reliesOnLegacyModules;
    private Knowledge knowledge;
    private LoadingAgent agent;
    private LoadingAgent jsonAgent;
    private Exception loadException;

    public Expansion(ExpansionIdentity identity, DataPackage data, IDataCollector collector, LoopingStreamedSoundManager soundManager, VolumeContainer masterVolume, File configurationSource) {
        this.identity = identity;
        this.masterVolume = masterVolume;
        this.data = data;
        this.collector = collector;
        this.capabilities = new SoundHelperRelay(soundManager);
        this.newKnowledge();
        this.myConfiguration.setProperty("volume", (Object)1);
        this.myConfiguration.commit();
        try {
            this.myConfiguration.setSource(configurationSource.getCanonicalPath());
            this.myConfiguration.load();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Matmos.addBlockChangeListener(this);
        this.setVolumeAndUpdate(this.myConfiguration.getFloat("volume"));
    }

    public void setLoadingAgent(LoadingAgent agent) {
        this.agent = agent;
    }

    public void refreshKnowledge() {
        boolean reactivate = this.isActivated();
        this.deactivate();
        this.newKnowledge();
        this.isSuccessfullyBuilt = false;
        if (reactivate) {
            this.activate();
        }
    }

    public void pushDebugJsonAndRefreshKnowledge(String jsonString) {
        this.jsonAgent = new RawJsonLoadingAgent(jsonString);
        this.refreshKnowledge();
    }

    private void newKnowledge() {
        this.knowledge = new Knowledge(this.capabilities, TIME);
        this.knowledge.setData(this.data);
        this.knowledge.addKnowledge(Knowledge.getBuiltins(this.knowledge.obtainProviders()));
        this.knowledge.setConditionValueOverrides(this.collectConditionValueOverrides());
    }

    private Map<String, String> collectConditionValueOverrides() {
        String OVERRIDE_CONDITION_PREFIX = "override.condition.";
        HashMap<String, String> overrides = new HashMap<String, String>();
        this.myConfiguration.getAllProperties().forEach((k, v) -> {
            if (k.startsWith(OVERRIDE_CONDITION_PREFIX)) {
                overrides.put(k.substring(OVERRIDE_CONDITION_PREFIX.length()), (String)v);
            }
        });
        return overrides;
    }

    public Map<String, String> getConditionValueOverrides() {
        return this.knowledge.getConditionValueOverrides();
    }

    private void buildKnowledge() {
        if (this.agent == null) {
            return;
        }
        this.newKnowledge();
        this.loadException = null;
        if (this.jsonAgent == null) {
            this.loadException = this.agent.load(this.identity, this.knowledge);
        } else {
            this.loadException = this.jsonAgent.load(this.identity, this.knowledge);
            this.jsonAgent = null;
        }
        boolean bl = this.isSuccessfullyBuilt = this.loadException == null;
        if (!this.isSuccessfullyBuilt) {
            this.newKnowledge();
        }
        this.knowledge.cacheSounds(this.identity);
        this.knowledge.compile();
    }

    public void playSample() {
        if (!this.isActivated()) {
            return;
        }
        EventInterface event = this.knowledge.obtainProviders().getEvent().get("__SAMPLE");
        if (event != null) {
            event.playSound(1.0f, 1.0f);
        }
    }

    public String getName() {
        return this.identity.getUniqueName();
    }

    public String getFriendlyName() {
        return this.identity.getFriendlyName();
    }

    public Exception getLoadException() {
        return this.loadException;
    }

    public void saveConfig() {
        this.myConfiguration.setProperty("volume", Float.valueOf(this.volume));
        this.myConfiguration.getAllProperties().entrySet().removeIf(e -> ((String)e.getKey()).startsWith("override.condition."));
        this.knowledge.getConditionValueOverrides().forEach((k, v) -> this.myConfiguration.setProperty("override.condition." + k, v));
        if (this.myConfiguration.commit()) {
            this.myConfiguration.save();
        }
    }

    public boolean reliesOnLegacyModules() {
        return this.reliesOnLegacyModules;
    }

    @Override
    public void simulate() {
        if (!this.isActive) {
            return;
        }
        try {
            this.knowledge.simulate();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.deactivate();
        }
    }

    @Override
    public void evaluate() {
        if (!this.isActive) {
            return;
        }
        try {
            this.knowledge.evaluate();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.deactivate();
        }
    }

    @Override
    public boolean isActivated() {
        return this.isActive;
    }

    @Override
    public void activate() {
        if (this.isActive) {
            return;
        }
        if (this.getVolume() <= 0.0f) {
            return;
        }
        if (!this.isSuccessfullyBuilt && this.agent != null) {
            Matmos.DEVLOGGER.info("Building expansion " + this.getName() + "...");
            TimeStatistic stat = new TimeStatistic(Locale.ENGLISH);
            this.buildKnowledge();
            if (this.isSuccessfullyBuilt) {
                Matmos.DEVLOGGER.info("Expansion " + this.getName() + " built (" + stat.getSecondsAsString(3) + "s).");
            } else {
                Matmos.LOGGER.warn("Expansion " + this.getName() + " failed to build!!! (" + stat.getSecondsAsString(3) + "s).");
            }
        }
        if (this.collector != null) {
            Set<String> requiredModules = this.knowledge.calculateRequiredModules();
            this.collector.addModuleStack(this.identity.getUniqueName(), requiredModules);
            Matmos.DEVLOGGER.info("Expansion " + this.identity.getUniqueName() + " requires " + requiredModules.size() + " found modules: " + Arrays.toString(requiredModules.toArray()));
            Object[] legacyModules = (String[])requiredModules.stream().filter(module -> module.startsWith("legacy")).sorted().toArray(String[]::new);
            if (legacyModules.length > 0) {
                Matmos.DEVLOGGER.warn("Expansion " + this.identity.getUniqueName() + " uses LEGACY modules: " + Arrays.toString(legacyModules));
                this.reliesOnLegacyModules = true;
            }
        }
        this.capabilities.activate();
        this.isActive = true;
    }

    @Override
    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        if (this.collector != null) {
            this.collector.removeModuleStack(this.identity.getUniqueName());
        }
        this.capabilities.deactivate();
        this.isActive = false;
    }

    @Override
    public void dispose() {
        this.deactivate();
        this.capabilities.cleanUp();
        this.newKnowledge();
        this.setLoadingAgent(null);
        Matmos.removeBlockChangeListener(this);
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolumeAndUpdate(float volume) {
        this.volume = volume;
        this.updateVolume();
    }

    @Override
    public void updateVolume() {
        this.capabilities.applyVolume(this.masterVolume.getVolume() * this.getVolume() * this.identity.getVolumeModifier());
    }

    public void setOverrideOff(boolean overrideOff) {
        this.knowledge.setOverrideOff(overrideOff);
    }

    @Override
    public void interrupt() {
        this.capabilities.interrupt();
    }

    public ProviderCollection obtainProvidersForDebugging() {
        return this.knowledge.obtainProviders();
    }

    public ExpansionDebugUnit obtainDebugUnit() {
        try {
            if (this.identity.getPack() instanceof FolderResourcePack) {
                FolderResourcePack frp = (FolderResourcePack)this.identity.getPack();
                String folderName = frp.func_130077_b();
                final File folder = new File(Minecraft.func_71410_x().field_71412_D, "resourcepacks/" + folderName);
                if (folder.exists() && folder.isDirectory()) {
                    System.out.println(this.identity.getLocation().func_110623_a());
                    final File file = new File(folder, "assets/matmos/" + this.identity.getLocation().func_110623_a());
                    return new FolderExpansionDebugUnit(){

                        @Override
                        public Knowledge getKnowledge() {
                            return Expansion.this.knowledge;
                        }

                        @Override
                        public DataPackage getData() {
                            return Expansion.this.data;
                        }

                        @Override
                        public File getExpansionFile() {
                            return file;
                        }

                        @Override
                        public File getExpansionFolder() {
                            return folder;
                        }
                    };
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new JsonExpansionDebugUnit(){

            @Override
            public Knowledge getKnowledge() {
                return Expansion.this.knowledge;
            }

            @Override
            public DataPackage getData() {
                return Expansion.this.data;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getJsonString() {
                try (Scanner sc = new Scanner(Expansion.this.identity.getPack().func_110590_a(Expansion.this.identity.getLocation()));){
                    String string = sc.useDelimiter("\\Z").next();
                    return string;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Jason unavailable.");
                    return "{}";
                }
            }
        };
    }

    public boolean hasMoreInfo() {
        return this.identity.getPack().func_110589_b(new ResourceLocation("matmos", "info.txt"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInfo() {
        try (Scanner sc = new Scanner(this.identity.getPack().func_110590_a(new ResourceLocation("matmos", "info.txt")));){
            String string = sc.useDelimiter("\\Z").next();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error while fetching info.txt";
        }
    }

    public boolean isRainMuteable() {
        return this.knowledge.hasOverrideRainCondition();
    }

    @Override
    public void onBlockChanged(BlockChangeEvent event) {
        this.knowledge.onBlockChanged(event);
    }
}

