/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.logic;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Dependable;
import eu.ha3.matmos.core.MultistateComponent;
import eu.ha3.matmos.core.Operator;
import eu.ha3.matmos.core.logic.Visualized;
import eu.ha3.matmos.core.sheet.SheetCommander;
import eu.ha3.matmos.core.sheet.SheetIndex;
import eu.ha3.matmos.util.math.Numbers;
import java.util.Collection;
import java.util.HashSet;

public class Condition
extends MultistateComponent
implements Dependable,
Visualized {
    private final SheetIndex indexX;
    private final Operator operatorX;
    private final String constantX;
    private final Long constantLongX;
    private final SheetCommander<String> sheetCommander;
    private int siVersion = Integer.MIN_VALUE;
    private final Collection<String> dependencies;

    public Condition(String name, SheetCommander<String> sheetCommander, SheetIndex index, Operator operator, String constant) {
        super(name);
        this.sheetCommander = sheetCommander;
        this.indexX = index;
        this.operatorX = operator;
        this.constantX = constant;
        this.constantLongX = Numbers.toLong(constant);
        this.dependencies = new HashSet<String>();
        this.dependencies.add(index.getSheet());
    }

    @Override
    public void evaluate() {
        if (this.sheetCommander.version(this.indexX) == this.siVersion) {
            return;
        }
        boolean pre = this.isActive;
        this.isActive = this.testIfTrue();
        if (pre != this.isActive) {
            this.incrementVersion();
            Matmos.DEBUGLOGGER.debug("C: " + this.getName() + " -> " + this.isActive);
        }
    }

    private boolean testIfTrue() {
        try {
            Long longValue;
            String value = this.sheetCommander.get(this.indexX);
            switch (this.operatorX) {
                case IN_LIST: {
                    return this.sheetCommander.listHas(this.constantX, value);
                }
                case NOT_IN_LIST: {
                    return !this.sheetCommander.listHas(this.constantX, value);
                }
            }
            if (this.constantLongX != null && (longValue = Numbers.toLong(value)) != null) {
                return this.operatorX.test(longValue, this.constantLongX);
            }
            return this.operatorX.test(value, this.constantX);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getFeed() {
        String value = this.sheetCommander.get(this.indexX);
        String op = this.operatorX.getSymbol();
        return this.indexX.getSheet() + ">" + this.indexX.getIndex() + ":[" + value + "] " + op + " " + this.constantX;
    }

    public SheetIndex getIndex() {
        return this.indexX;
    }
}

