/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sheet;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.GenericSheet;
import eu.ha3.matmos.core.sheet.Sheet;
import eu.ha3.matmos.core.sheet.VirtualSheet;
import eu.ha3.matmos.util.math.Numbers;

public class DeltaSheet
extends GenericSheet
implements VirtualSheet {
    private final DataPackage data;
    private final String actualSheet;
    private final String deltaSheet;

    public DeltaSheet(DataPackage data, String actualSheet, String deltaSheet) {
        this.data = data;
        this.actualSheet = actualSheet;
        this.deltaSheet = deltaSheet;
    }

    @Override
    public void apply() {
        for (String key : this.values.keySet()) {
            Sheet actual = this.data.getSheet(this.actualSheet);
            String previousValue = actual.getOrDefault(key, "0");
            String newValue = (String)this.values.get(key);
            actual.set(key, newValue);
            this.data.getSheet(this.deltaSheet).set(key, this.computeDelta(previousValue, newValue));
        }
        this.clear();
    }

    protected String computeDelta(String previousValue, String newValue) {
        Long newLong = Numbers.toLong(newValue);
        if (newLong != null) {
            if (newValue.equals(previousValue)) {
                return "0";
            }
            Long previousLong = Numbers.toLong(previousValue);
            if (previousLong != null) {
                return Long.toString(newLong - previousLong);
            }
        }
        return newValue.equals(previousValue) ? "NOT_MODIFIED" : "MODIFIED";
    }
}

