/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sound;

import eu.ha3.matmos.core.SystemClock;
import eu.ha3.matmos.core.sound.StreamingSound;
import eu.ha3.matmos.util.math.HelperFadeCalculator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class NoAttenuationMovingSound
extends MovingSound
implements StreamingSound {
    private boolean usesPause;
    private final HelperFadeCalculator helper = new HelperFadeCalculator(new SystemClock());
    private float desiredVolume;
    private float desiredPitch;
    private float volumeMod;
    private boolean underwater;
    private boolean notYetPlayed = true;

    protected NoAttenuationMovingSound(ResourceLocation myResource, float volume, float pitch, boolean isLooping, boolean usesPause, boolean underwater) {
        super(SoundEvents.field_187674_a, underwater ? SoundCategory.MASTER : SoundCategory.AMBIENT);
        this.field_147664_a = myResource;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.field_147659_g = isLooping;
        this.field_147665_h = 0;
        this.desiredVolume = volume;
        this.desiredPitch = pitch;
        this.field_147662_b = 1.0E-5f;
        this.field_147663_c = pitch;
        this.usesPause = usesPause;
        this.underwater = underwater;
    }

    public NoAttenuationMovingSound copy() {
        return new NoAttenuationMovingSound(this.func_147650_b(), this.desiredVolume, this.desiredPitch, this.field_147659_g, this.usesPause, this.underwater);
    }

    public void func_73660_a() {
        EntityPlayerSP e = Minecraft.func_71410_x().field_71439_g;
        this.field_147660_d = (float)e.field_70165_t;
        this.field_147661_e = (float)e.field_70163_u;
        this.field_147658_f = (float)e.field_70161_v;
        this.field_147662_b = this.helper.calculateFadeFactor() * this.desiredVolume * this.volumeMod;
        if (this.field_147662_b < 0.01f && this.usesPause) {
            this.field_147663_c = 0.0f;
        }
        if (this.field_147662_b > 0.01f && this.usesPause) {
            this.field_147663_c = this.desiredPitch;
        }
        if (this.helper.isDoneFadingOut() && this.field_147659_g && !this.func_147667_k()) {
            this.dispose();
        }
    }

    @Override
    public void play(float fadeIn) {
        this.setVolume(this.desiredVolume, fadeIn);
    }

    @Override
    public void stop(float fadeOut) {
        this.setVolume(0.0f, fadeOut);
    }

    public void setVolume(float volume, float fadeTime) {
        this.helper.fadeTo(volume / this.desiredVolume, (long)(fadeTime * 1000.0f));
    }

    @Override
    public void applyVolume(float volumeMod) {
        this.volumeMod = volumeMod;
    }

    public float getTargetVolume() {
        return this.helper.getTargetFade() * this.desiredVolume;
    }

    @Override
    public void dispose() {
        this.field_147668_j = true;
    }

    @Override
    public void interrupt() {
        this.field_147668_j = true;
    }

    public Sound func_184364_b() {
        this.notYetPlayed = false;
        return super.func_184364_b();
    }

    public boolean notYetPlayed() {
        return this.notYetPlayed;
    }

    public boolean popNotYetPlayed() {
        boolean wasNotYetPlayed = this.notYetPlayed;
        if (this.notYetPlayed) {
            this.notYetPlayed = false;
        }
        return wasNotYetPlayed;
    }

    @Override
    public ITickableSound asTickable() {
        return this;
    }
}

