/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sound;

import eu.ha3.matmos.ConfigManager;
import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.ResourcePackDealer;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.expansion.ExpansionManager;
import eu.ha3.matmos.core.expansion.SoundpackIdentity;
import eu.ha3.matmos.core.expansion.VolumeUpdatable;
import eu.ha3.matmos.data.modules.ModuleRegistry;
import eu.ha3.matmos.game.user.VisualDebugger;
import eu.ha3.matmos.lib.eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsTickEvents;
import java.io.File;
import java.util.Locale;
import java.util.Map;

public class Simulacrum
implements SupportsTickEvents,
SupportsFrameEvents {
    private ExpansionManager expansionManager;
    private ModuleRegistry dataGatherer;
    private VisualDebugger visualDebugger;
    private boolean isBrutallyInterrupted;
    private boolean hasResourcePacks;
    private boolean hasDisabledResourcePacks;
    private boolean hasRainMuteableExpansions;
    public static final String USERCONFIG_FOLDER = "expansions_userconfig";

    public Simulacrum(Matmos mod) {
        this.expansionManager = new ExpansionManager(new File(ConfigManager.getConfigFolder(), USERCONFIG_FOLDER), ConfigManager.getConfigFolder(), mod.getSoundManager());
        this.expansionManager.setVolumeAndUpdate(mod.getConfig().getFloat("globalvolume.scale"));
        TimeStatistic stat = new TimeStatistic(Locale.ENGLISH);
        this.dataGatherer = new ModuleRegistry(mod);
        this.dataGatherer.load();
        this.visualDebugger = new VisualDebugger(mod, this.dataGatherer);
        this.expansionManager.setData(this.dataGatherer.getData());
        this.expansionManager.setCollector(this.dataGatherer);
        this.expansionManager.loadExpansions();
        this.hasResourcePacks = true;
        if (this.expansionManager.getExpansions().size() == 0) {
            ResourcePackDealer dealer = new ResourcePackDealer();
            if (dealer.findResourcePacks().count() == 0L) {
                this.hasResourcePacks = false;
                this.hasDisabledResourcePacks = dealer.findDisabledResourcePacks().size() > 0;
            }
        } else {
            for (SoundpackIdentity id : this.expansionManager.getSoundpackIdentities()) {
                mod.addUpdateNotifierJob(id);
            }
        }
        this.expansionManager.synchronize();
        this.hasRainMuteableExpansions = this.expansionManager.getExpansions().values().stream().anyMatch(e -> e.isRainMuteable());
        Matmos.LOGGER.info("Expansions loaded (" + stat.getSecondsAsString(1) + "s).");
    }

    public void interruptBrutally() {
        this.isBrutallyInterrupted = true;
    }

    public void dispose() {
        if (!this.isBrutallyInterrupted) {
            this.expansionManager.dispose();
        }
    }

    @Override
    public void onFrame(float semi) {
        this.expansionManager.onFrame(semi);
        this.visualDebugger.onFrame(semi);
    }

    @Override
    public void onTick() {
        this.dataGatherer.process();
        this.expansionManager.onTick();
    }

    public boolean hasResourcePacks() {
        return this.hasResourcePacks;
    }

    public boolean hasDisabledResourcePacks() {
        return this.hasDisabledResourcePacks;
    }

    public boolean hasRainMuteableExpansions() {
        return this.hasRainMuteableExpansions;
    }

    public Map<String, Expansion> getExpansions() {
        return this.expansionManager.getExpansions();
    }

    public void synchronize() {
        this.expansionManager.synchronize();
    }

    public void saveConfig() {
        this.expansionManager.saveConfig();
    }

    public VisualDebugger getVisualDebugger() {
        return this.visualDebugger;
    }

    public VolumeUpdatable getGlobalVolumeControl() {
        return this.expansionManager;
    }
}

