/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.core.expansion.ExpansionManager;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.SheetDataPackage;
import eu.ha3.matmos.data.modules.AbstractThingCountModule;
import eu.ha3.matmos.data.modules.VirtualCountModule;
import eu.ha3.matmos.util.MAtUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class BlockCountModule
extends AbstractThingCountModule<Pair<Block, Integer>> {
    private static final int INITIAL_SIZE = 4096;
    private boolean[] wasZero = new boolean[4096];
    private int[] counts = new int[4096];
    private int[] zeroMetadataCounts = new int[4096];
    private TreeMap<Integer, Integer>[] metadatas = new TreeMap[4096];
    int size = 4096;
    VirtualCountModule<Pair<Block, Integer>> thousand;
    SheetDataPackage sheetData;
    int blocksCounted = 0;

    public BlockCountModule(DataPackage data, String name) {
        this(data, name, false);
    }

    public BlockCountModule(DataPackage data, String name, boolean doNotUseDelta) {
        this(data, name, doNotUseDelta, null);
    }

    public BlockCountModule(DataPackage data, String name, boolean doNotUseDelta, VirtualCountModule<Pair<Block, Integer>> thousand) {
        super(data, name, doNotUseDelta);
        this.thousand = thousand;
        data.getSheet(name).setDefaultValue("0");
        if (!doNotUseDelta) {
            data.getSheet(name + "_delta").setDefaultValue("0");
        }
        this.sheetData = (SheetDataPackage)data;
    }

    @Override
    protected void doProcess() {
        this.count();
        this.apply();
    }

    @Override
    public void increment(Pair<Block, Integer> blockMeta) {
        this.increment(blockMeta, 1);
    }

    @Override
    public void increment(Pair<Block, Integer> blockMeta, int amount) {
        Block block = (Block)blockMeta.getLeft();
        int meta = (Integer)blockMeta.getRight();
        int id = ExpansionManager.dealiasToID(block, (DataPackage)this.sheetData);
        if (id >= this.size) {
            this.resize(id + 1);
        }
        int n = id;
        this.counts[n] = this.counts[n] + amount;
        if (meta != -1 && meta != 0) {
            if (this.metadatas[id] == null) {
                this.metadatas[id] = new TreeMap();
            }
            Integer metaCount = this.metadatas[id].get(meta);
            this.metadatas[id].put(meta, metaCount == null ? 0 : metaCount + amount);
        } else if (meta == 0) {
            int n2 = id;
            this.zeroMetadataCounts[n2] = this.zeroMetadataCounts[n2] + amount;
        }
        this.blocksCounted += amount;
    }

    @Override
    public int get(Pair<Block, Integer> blockMeta) {
        Block block = (Block)blockMeta.getLeft();
        int meta = (Integer)blockMeta.getRight();
        int id = Block.func_149682_b((Block)block);
        if (id >= this.size) {
            return 0;
        }
        if (meta == -1) {
            return this.counts[id];
        }
        return this.metadatas[id].get(meta);
    }

    @Override
    public void count() {
    }

    @Override
    public void apply() {
        for (int i = 0; i < this.counts.length; ++i) {
            float flaot;
            String name;
            boolean isZero = true;
            if (this.counts[i] > 0 || !this.wasZero[i]) {
                isZero &= this.counts[i] == 0;
                name = MAtUtil.nameOf(Block.func_149729_e((int)i));
                this.setValue(name, this.counts[i]);
                if (this.thousand != null) {
                    flaot = (float)this.counts[i] / (float)this.blocksCounted * 1000.0f;
                    this.thousand.setValue(name, (int)Math.ceil(flaot));
                }
            }
            if (this.zeroMetadataCounts[i] > 0 || !this.wasZero[i]) {
                isZero &= this.zeroMetadataCounts[i] == 0;
                name = MAtUtil.asPowerMeta(Block.func_149729_e((int)i), 0);
                this.setValue(name, this.zeroMetadataCounts[i]);
                if (this.thousand != null) {
                    flaot = (float)this.zeroMetadataCounts[i] / (float)this.blocksCounted * 1000.0f;
                    this.thousand.setValue(name, (int)Math.ceil(flaot));
                }
            }
            if (this.metadatas[i] != null) {
                for (Map.Entry<Integer, Integer> entry : this.metadatas[i].entrySet()) {
                    int value = entry.getValue();
                    isZero &= value == 0;
                    if (value <= 0 && this.wasZero[i]) continue;
                    String name2 = MAtUtil.asPowerMeta(Block.func_149729_e((int)i), (int)entry.getKey());
                    this.setValue(name2, value);
                    if (this.thousand == null) continue;
                    float flaot2 = (float)value / (float)this.blocksCounted * 1000.0f;
                    this.thousand.setValue(name2, (int)Math.ceil(flaot2));
                }
            }
            this.wasZero[i] = isZero;
        }
        this.blocksCounted = 0;
        Arrays.fill(this.counts, 0);
        Arrays.fill(this.zeroMetadataCounts, 0);
        Arrays.stream(this.metadatas).forEach(m -> {
            if (m != null) {
                m.replaceAll((k, v) -> 0);
            }
        });
    }

    private void resize(int newSize) {
        int stepSize = 1024;
        newSize = (int)Math.ceil((double)newSize / (double)stepSize) * stepSize;
        this.wasZero = Arrays.copyOf(this.wasZero, newSize);
        this.counts = Arrays.copyOf(this.counts, newSize);
        this.zeroMetadataCounts = Arrays.copyOf(this.zeroMetadataCounts, newSize);
        this.metadatas = Arrays.copyOf(this.metadatas, newSize);
        this.size = newSize;
    }
}

