/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.scanners;

import eu.ha3.matmos.data.scanners.Scan;
import eu.ha3.matmos.data.scanners.ScanAir;
import eu.ha3.matmos.data.scanners.ScannerModule;
import eu.ha3.matmos.util.MAtUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class ScanRaycast
extends Scan {
    private static final Random rnd = new Random();
    int startX;
    int startY;
    int startZ;
    Vec3d center;
    int xSize;
    int ySize;
    int zSize;
    int startNearness;
    int maxRange;
    int raysCast = 0;
    int raysToCast;
    int directScore;
    int indirectScore;
    int distanceSqSum;
    private int THRESHOLD_SCORE;
    private int THRESHOLD_INDIRECT_SCORE;
    private Vec3d[] rays;
    private Set<BlockPos> scanned;

    @Override
    void initScan(int x, int y, int z, int xsizeIn, int ysizeIn, int zsizeIn, int opspercallIn) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.center = new Vec3d((double)this.startX + 0.5, (double)this.startY + 0.5, (double)this.startZ + 0.5);
        this.xSize = xsizeIn;
        this.ySize = ysizeIn;
        this.zSize = zsizeIn;
        this.raysToCast = this.opspercall * 20;
        this.raysCast = 0;
        this.distanceSqSum = 0;
        if (this.rays == null || this.rays.length != this.raysToCast) {
            rnd.setSeed(1L);
            this.rays = new Vec3d[this.raysToCast];
            for (int i = 0; i < this.raysToCast; ++i) {
                double squareDist;
                double vx = 0.0;
                double vy = 0.0;
                double vz = 0.0;
                while ((squareDist = vx * vx + vy * vy + vz * vz) < 0.01 || squareDist > 1.0) {
                    vx = 2.0 * (rnd.nextDouble() - 0.5);
                    vy = 2.0 * (rnd.nextDouble() - 0.5);
                    vz = 2.0 * (rnd.nextDouble() - 0.5);
                }
                this.rays[i] = new Vec3d(vx, vy, vz).func_72432_b();
            }
        }
        if (this.scanned == null) {
            this.scanned = new HashSet<BlockPos>(this.raysToCast + 1, 1.0f);
        }
        this.finalProgress = 1;
        this.startNearness = 60;
        this.maxRange = 100;
        this.directScore = 0;
        this.indirectScore = 0;
        this.THRESHOLD_SCORE = 10000;
        this.THRESHOLD_INDIRECT_SCORE = 10;
        this.scanned.clear();
    }

    private Vec3d getRay(int index) {
        return this.rays[index];
    }

    private Optional<Vec3d> getNormalVector(RayTraceResult result) {
        if (result == null) {
            return Optional.empty();
        }
        switch (result.field_178784_b) {
            case DOWN: {
                return Optional.of(new Vec3d(0.0, -1.0, 0.0));
            }
            case UP: {
                return Optional.of(new Vec3d(0.0, 1.0, 0.0));
            }
            case NORTH: {
                return Optional.of(new Vec3d(0.0, 0.0, 1.0));
            }
            case SOUTH: {
                return Optional.of(new Vec3d(0.0, 0.0, -1.0));
            }
            case WEST: {
                return Optional.of(new Vec3d(-1.0, 0.0, 0.0));
            }
            case EAST: {
                return Optional.of(new Vec3d(1.0, 0.0, 0.0));
            }
        }
        return Optional.empty();
    }

    @Override
    protected boolean doRoutine() {
        for (int ops = 0; ops < this.opspercall && this.raysCast < this.raysToCast; ++ops) {
            this.castRay(this.getRay(this.raysCast));
            ++this.raysCast;
        }
        if (this.raysCast >= this.raysToCast) {
            this.progress = 1;
            this.pipeline.setValue(".is_outdoors", this.directScore > this.THRESHOLD_SCORE ? 1 : 0);
            this.pipeline.setValue(".__score", this.directScore);
            this.pipeline.setValue(".__indirect_score", this.indirectScore);
            this.pipeline.setValue("._is_near_surface_own", this.indirectScore > this.THRESHOLD_INDIRECT_SCORE ? 1 : 0);
            this.pipeline.setValue(".spaciousness", this.distanceSqSum);
        }
        return true;
    }

    private int calculateWeight(int dx, int dy, int dz, int maxRange) {
        int distanceSquared = dx * dx + dy * dy + dz * dz;
        float distanceScale = 1.0f;
        float weight = MathHelper.func_76131_a((float)(1.0f / (1.0f + (float)distanceSquared / distanceScale)), (float)0.0f, (float)1.0f);
        return (int)(weight * 1000.0f);
    }

    public static RayTraceResult rayTraceNonSolid(Vec3d start, Vec3d end) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        RayTraceResult result = w.func_147447_a(start, end, true, false, true);
        Vec3d delta = end.func_178788_d(start);
        double infNorm = Math.max(Math.abs(delta.field_72450_a), Math.max(Math.abs(delta.field_72448_b), Math.abs(delta.field_72449_c)));
        delta = delta.func_186678_a(0.01 / infNorm);
        while (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && ScanAir.isTransparentToSound(w.func_180495_p(result.func_178782_a()), (IBlockAccess)w, new BlockPos(result.field_72307_f), true)) {
            result = w.func_147447_a(delta.func_178787_e(result.field_72307_f), end, true, true, true);
        }
        return result;
    }

    private boolean scanNearRayHit(RayTraceResult result, int scanDistance, boolean direct) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        BlockPos hitBlock = result.func_178782_a();
        this.distanceSqSum = (int)((double)this.distanceSqSum + hitBlock.func_177954_c(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c));
        Block[] blockBuf = new Block[1];
        int[] metaBuf = new int[1];
        int[] pos = new int[3];
        boolean centerSolid = false;
        boolean foundSky = false;
        int airPenalty = 0;
        int solidPenalty = 55;
        for (int scanDir = 0; scanDir < 6; ++scanDir) {
            int nearness = this.startNearness;
            for (int offset = 0; offset <= scanDistance; ++offset) {
                boolean solid;
                if (offset == 0 && scanDir != 0) continue;
                int scanAxis = scanDir >= 3 ? scanDir - 3 : scanDir;
                pos[0] = hitBlock.func_177958_n();
                pos[1] = hitBlock.func_177956_o();
                pos[2] = hitBlock.func_177952_p();
                int n = scanAxis;
                pos[n] = pos[n] + offset * (scanDir >= 3 ? -1 : 1);
                BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
                if (this.scanned.contains(blockPos)) continue;
                this.scanned.add(blockPos);
                int dx = this.startX - pos[0];
                int dy = this.startY - pos[1];
                int dz = this.startZ - pos[2];
                if (direct) {
                    ((ScannerModule)this.pipeline).inputAndReturnBlockMeta(pos[0], pos[1], pos[2], this.calculateWeight(dx, dy, dz, this.maxRange), blockBuf, metaBuf);
                } else {
                    blockBuf[0] = MAtUtil.getBlockAt(new BlockPos(pos[0], pos[1], pos[2]));
                    metaBuf[0] = MAtUtil.getMetaAt(new BlockPos(pos[0], pos[1], pos[2]), -1);
                }
                Block block = blockBuf[0];
                IBlockState bs = w.func_180495_p(blockPos);
                boolean bl = solid = bs.func_185890_d((IBlockAccess)w, blockPos) != Block.field_185506_k && !(block instanceof BlockLeaves);
                if (solid && offset == 0 && scanDir == 0) {
                    centerSolid = true;
                } else if (centerSolid && scanDir != 0 && offset == 1) {
                    nearness -= centerSolid ? solidPenalty : airPenalty;
                }
                if ((nearness -= solid ? solidPenalty : airPenalty) <= 0 || !(block instanceof BlockAir) || !MAtUtil.canSeeSky(blockPos)) continue;
                int hitScore = nearness;
                if (direct) {
                    this.directScore += hitScore;
                } else {
                    ++this.indirectScore;
                }
                foundSky = true;
            }
        }
        return foundSky;
    }

    private void castRay(Vec3d dir) {
        Vec3d end = this.center.func_178787_e(dir.func_186678_a((double)this.maxRange));
        RayTraceResult result = ScanRaycast.rayTraceNonSolid(this.center, end);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            Vec3d normal;
            boolean foundSky = this.scanNearRayHit(result, 2, true);
            if (!foundSky && !(normal = this.getNormalVector(result).orElse(Vec3d.field_186680_a)).equals((Object)Vec3d.field_186680_a)) {
                Vec3d otherSide = normal.func_186678_a(-1.1).func_178787_e(result.field_72307_f);
                RayTraceResult continuedResult = ScanRaycast.rayTraceNonSolid(otherSide, end);
                if (continuedResult != null) {
                    this.scanNearRayHit(continuedResult, 1, false);
                } else if (dir.field_72448_b > 0.0) {
                    this.indirectScore += 7;
                }
            }
        } else {
            this.distanceSqSum += this.maxRange * this.maxRange;
            if (dir.field_72448_b > 0.0) {
                Vec3d rayEnd = this.center.func_178787_e(dir.func_186678_a((double)this.maxRange));
                BlockPos rayEndBlockPos = new BlockPos(MathHelper.func_76128_c((double)rayEnd.field_72450_a), MathHelper.func_76128_c((double)rayEnd.field_72448_b), MathHelper.func_76128_c((double)rayEnd.field_72449_c));
                if (MAtUtil.canSeeSky(rayEndBlockPos)) {
                    this.directScore += this.startNearness * 13;
                }
            }
        }
    }
}

