/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.scanners;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.modules.AbstractThingCountModule;
import eu.ha3.matmos.data.modules.BlockCountModule;
import eu.ha3.matmos.data.modules.ExternalStringCountModule;
import eu.ha3.matmos.data.modules.Module;
import eu.ha3.matmos.data.modules.PassOnceModule;
import eu.ha3.matmos.data.modules.ThousandStringCountModule;
import eu.ha3.matmos.data.modules.VirtualCountModule;
import eu.ha3.matmos.data.scanners.Progress;
import eu.ha3.matmos.data.scanners.Scan;
import eu.ha3.matmos.data.scanners.ScanOperations;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import eu.ha3.matmos.util.MAtUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class ScannerModule
implements PassOnceModule,
ScanOperations,
Progress {
    public static final String THOUSAND_SUFFIX = "_p1k";
    public static final String WEIGHTED_SUFFIX = "_w";
    public static final String ABOVE_SUFFIX = "_above";
    public static final String BELOW_SUFFIX = "_below";
    private static final int WORLD_LOADING_DURATION = 100;
    private final String passOnceName;
    private final Set<Submodule> requiredSubmodules;
    private final int movement;
    private final int passivePulse;
    private final int pulse;
    private final int xS;
    private final int yS;
    private final int zS;
    private final int blocksPerCall;
    private final AbstractThingCountModule base;
    private final BlockCountModule weighted;
    private final AbstractThingCountModule thousand;
    private final BlockCountModule above;
    private final BlockCountModule below;
    private final Set<String> subModules = new HashSet<String>();
    private int ticksSinceBoot;
    private boolean firstScan;
    private boolean workInProgress;
    private int lastScanTime = -1;
    private int dimension = Integer.MIN_VALUE;
    private int xx = Integer.MIN_VALUE;
    private int yy = Integer.MIN_VALUE;
    private int zz = Integer.MIN_VALUE;
    private final Scan scanner;

    private Module initSubmodule(Submodule sm, String baseName, DataPackage data) {
        boolean useExternalStringCountModule = false;
        if (sm != Submodule.BASE && !this.requiredSubmodules.contains((Object)sm)) {
            return null;
        }
        AbstractThingCountModule result = null;
        String submoduleName = baseName;
        switch (sm) {
            case BASE: {
                if (useExternalStringCountModule) {
                    result = new ExternalStringCountModule(data, baseName, true);
                    break;
                }
                result = new BlockCountModule(data, baseName, true, (VirtualCountModule)this.thousand);
                break;
            }
            case THOUSAND: {
                submoduleName = baseName + THOUSAND_SUFFIX;
                if (useExternalStringCountModule) {
                    result = new ThousandStringCountModule(data, submoduleName, true);
                    break;
                }
                result = new VirtualCountModule(data, submoduleName, true);
                break;
            }
            case WEIGHTED: {
                submoduleName = baseName + WEIGHTED_SUFFIX;
                result = new BlockCountModule(data, submoduleName, true, null);
                break;
            }
            case ABOVE: {
                submoduleName = baseName + ABOVE_SUFFIX;
                result = new BlockCountModule(data, submoduleName, true, null);
                break;
            }
            case BELOW: {
                submoduleName = baseName + BELOW_SUFFIX;
                result = new BlockCountModule(data, submoduleName, true, null);
            }
        }
        if (result != null) {
            this.subModules.add(submoduleName);
            data.getSheet(submoduleName).setDefaultValue("0");
        }
        return result;
    }

    private ScannerModule(Class<? extends Scan> scannerClass, Object scannerArgument, boolean hasScannerArgument, DataPackage data, String passOnceName, String baseName, List<Submodule> requiredSubmodules, int movement, int passivePulse, int pulse, int xS, int yS, int zS, int blocksPerCall) {
        this.passOnceName = passOnceName;
        this.requiredSubmodules = new HashSet<Submodule>(requiredSubmodules);
        this.movement = movement;
        this.passivePulse = passivePulse;
        this.pulse = pulse;
        this.xS = xS;
        this.yS = yS;
        this.zS = zS;
        this.blocksPerCall = blocksPerCall;
        this.thousand = (AbstractThingCountModule)this.initSubmodule(Submodule.THOUSAND, baseName, data);
        this.weighted = (BlockCountModule)this.initSubmodule(Submodule.WEIGHTED, baseName, data);
        this.base = (AbstractThingCountModule)this.initSubmodule(Submodule.BASE, baseName, data);
        this.above = (BlockCountModule)this.initSubmodule(Submodule.ABOVE, baseName, data);
        this.below = (BlockCountModule)this.initSubmodule(Submodule.BELOW, baseName, data);
        Scan theScanner = null;
        try {
            theScanner = hasScannerArgument ? scannerClass.getConstructor(Object.class).newInstance(scannerArgument) : scannerClass.newInstance();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.scanner = theScanner;
        this.scanner.setPipeline(this);
        this.ticksSinceBoot = 0;
        this.firstScan = true;
    }

    public ScannerModule(Class<? extends Scan> scannerClass, Object scannerArgument, DataPackage data, String passOnceName, String baseName, List<Submodule> requiredSubmodules, int movement, int passivePulse, int pulse, int xS, int yS, int zS, int blocksPerCall) {
        this(scannerClass, scannerArgument, true, data, passOnceName, baseName, requiredSubmodules, movement, passivePulse, pulse, xS, yS, zS, blocksPerCall);
    }

    public ScannerModule(Class<? extends Scan> scannerClass, DataPackage data, String passOnceName, String baseName, List<Submodule> requiredSubmodules, int movement, int passivePulse, int pulse, int xS, int yS, int zS, int blocksPerCall) {
        this(scannerClass, null, false, data, passOnceName, baseName, requiredSubmodules, movement, passivePulse, pulse, xS, yS, zS, blocksPerCall);
    }

    @Override
    public String getName() {
        return this.passOnceName;
    }

    @Override
    public Set<String> getSubModules() {
        return this.subModules;
    }

    @Override
    public void process() {
        if (this.tryToReboot()) {
            Matmos.DEVLOGGER.info("Detected large movement or teleportation. Rebooted module " + this.getName());
            return;
        }
        if (this.ticksSinceBoot < 100) {
            ++this.ticksSinceBoot;
            return;
        }
        this.tryToBoot();
        if (this.workInProgress) {
            this.scanner.routine();
        }
        ++this.ticksSinceBoot;
    }

    private boolean tryToReboot() {
        int x = MAtUtil.getPlayerX();
        int y = MAtUtil.clampToBounds(MAtUtil.getPlayerY());
        int z = MAtUtil.getPlayerZ();
        if (Minecraft.func_71410_x().field_71439_g.field_71093_bK != this.dimension) {
            this.reboot();
            return true;
        }
        int max = Math.max(Math.abs(this.xx - x), Math.abs(this.yy - y));
        if ((max = Math.max(max, Math.abs(this.zz - z))) > 128) {
            this.reboot();
            return true;
        }
        return false;
    }

    private void reboot() {
        this.scanner.stopScan();
        this.workInProgress = false;
        this.ticksSinceBoot = 0;
        this.firstScan = true;
        this.dimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        this.xx = MAtUtil.getPlayerX();
        this.yy = MAtUtil.clampToBounds(MAtUtil.getPlayerY());
        this.zz = MAtUtil.getPlayerZ();
    }

    private void tryToBoot() {
        if (this.workInProgress) {
            return;
        }
        if (this.ticksSinceBoot % this.pulse == 0) {
            boolean go = false;
            if (this.firstScan) {
                this.firstScan = false;
                go = true;
            } else if (this.movement >= 0) {
                int x = MAtUtil.getPlayerX();
                int y = MAtUtil.clampToBounds(MAtUtil.getPlayerY());
                int z = MAtUtil.getPlayerZ();
                int max = Math.max(Math.abs(this.xx - x), Math.abs(this.yy - y));
                go = (max = Math.max(max, Math.abs(this.zz - z))) > this.movement || this.passivePulse >= 0 && max > 0 && this.lastScanTime != -1 && (this.ticksSinceBoot - this.lastScanTime) / this.pulse > this.passivePulse;
            } else {
                go = true;
            }
            if (go) {
                this.workInProgress = true;
                this.lastScanTime = this.ticksSinceBoot;
                this.xx = MAtUtil.getPlayerX();
                this.yy = MAtUtil.clampToBounds(MAtUtil.getPlayerY());
                this.zz = MAtUtil.getPlayerZ();
                this.scanner.startScan(this.xx, this.yy, this.zz, this.xS, this.yS, this.zS, this.blocksPerCall);
            }
        }
    }

    @Override
    public void input(int x, int y, int z) {
        this.inputAndReturnBlockMeta(x, y, z, 1, null, null);
    }

    @Override
    public void input(int x, int y, int z, int weight) {
        this.inputAndReturnBlockMeta(x, y, z, weight, null, null);
    }

    public void inputAndReturnBlockMeta(int x, int y, int z, Block[] blockOut, int[] metaOut) {
        this.inputAndReturnBlockMeta(x, y, z, 1, blockOut, metaOut);
    }

    public void inputAndReturnBlockMeta(int x, int y, int z, int weight, Block[] blockOut, int[] metaOut) {
        Block block = MAtUtil.getBlockAt(new BlockPos(x, y, z));
        int meta = MAtUtil.getMetaAt(new BlockPos(x, y, z), -1);
        if (this.base instanceof BlockCountModule) {
            this.base.increment(Pair.of((Object)block, (Object)meta));
        } else if (this.base instanceof ExternalStringCountModule) {
            String name = MAtUtil.nameOf(block);
            this.base.increment(name);
            this.base.increment(MAtUtil.asPowerMeta(block, meta));
            if (this.thousand != null) {
                this.thousand.increment(name);
            }
        }
        if (this.weighted != null) {
            this.weighted.increment((Pair<Block, Integer>)Pair.of((Object)block, (Object)meta), weight);
        } else if (weight != 1) {
            IDontKnowHowToCode.warnOnce("Module " + this.getName() + " doesn't have a weighted counter, but the scanner tried to input a block with a weight.");
        }
        if (this.above != null && y >= this.yy) {
            this.above.increment((Pair<Block, Integer>)Pair.of((Object)block, (Object)meta));
        } else if (this.below != null && y < this.yy) {
            this.below.increment((Pair<Block, Integer>)Pair.of((Object)block, (Object)meta));
        }
        if (blockOut != null) {
            blockOut[0] = block;
        }
        if (metaOut != null) {
            metaOut[0] = meta;
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void finish() {
        this.base.apply();
        if (this.thousand != null) {
            this.thousand.apply();
        }
        if (this.weighted != null) {
            this.weighted.apply();
        }
        if (this.above != null) {
            this.above.apply();
        }
        if (this.below != null) {
            this.below.apply();
        }
        this.workInProgress = false;
    }

    @Override
    public int getProgress_Current() {
        return this.scanner.getProgress_Current();
    }

    @Override
    public int getProgress_Total() {
        return this.scanner.getProgress_Total();
    }

    @Override
    public void setValue(String key, int value) {
        if (!key.startsWith(".")) {
            Matmos.LOGGER.error("Illegal scanner sheet key name: \"" + key + "\". Key must start with a '.' character.");
        } else {
            this.base.setValue(key, value);
        }
    }

    public static enum Submodule {
        BASE,
        THOUSAND,
        WEIGHTED,
        ABOVE,
        BELOW;

    }
}

