/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.dealias;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.dealias.ObjectAliasMap;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ResourceLocation;

public class ItemAliasMap
extends ObjectAliasMap {
    protected void guessAliases() {
        int swordID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("iron_sword")));
        int wswordID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("wooden_sword")));
        int pickID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("iron_pickaxe")));
        int wpickID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("wooden_pickaxe")));
        int shovelID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("iron_shovel")));
        int wshovelID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("wooden_shovel")));
        int axeID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("iron_axe")));
        int waxeID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("wooden_axe")));
        int hoeID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("iron_hoe")));
        int whoeID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("wooden_hoe")));
        int bowID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("bow")));
        int appleID = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("apple")));
        for (Object o : Item.field_150901_e) {
            if (!(o instanceof Item)) continue;
            int id = Item.field_150901_e.func_148757_b((Object)((Item)o));
            String name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)((Item)o))).toString();
            if (name.startsWith("minecraft:")) continue;
            boolean wooden = name.toLowerCase().contains("wood");
            int target = -1;
            Set toolClasses = ((Item)o).getToolClasses(new ItemStack((Item)o));
            Matmos.ALIASLOGGER.debug("Tool classes for " + name + " (" + id + "): " + Arrays.toString(toolClasses.toArray()));
            if (o instanceof ItemSword || toolClasses.contains("sword")) {
                target = wooden ? wswordID : swordID;
            } else if (o instanceof ItemPickaxe || toolClasses.contains("pickaxe")) {
                target = wooden ? wpickID : pickID;
            } else if (o instanceof ItemSpade || toolClasses.contains("shovel")) {
                target = wooden ? wshovelID : shovelID;
            } else if (o instanceof ItemAxe || toolClasses.contains("axe")) {
                target = wooden ? waxeID : axeID;
            } else if (o instanceof ItemHoe || toolClasses.contains("hoe")) {
                target = wooden ? whoeID : hoeID;
            } else if (o instanceof ItemBow || toolClasses.contains("bow")) {
                target = bowID;
            } else if (((Item)o).func_77661_b(new ItemStack((Item)o)) == EnumAction.EAT) {
                target = appleID;
            }
            if (target == -1) continue;
            Matmos.ALIASLOGGER.debug("Guessing alias " + Item.field_150901_e.func_177774_c(Item.field_150901_e.func_148754_a(target)) + " for " + name);
            this.dealiasMap.put(id, target);
        }
    }

    @Override
    public String getLogPrefix() {
        return "[ItemAliasMap] ";
    }

    @Override
    public int getIDFromName(String s) {
        return Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s)));
    }

    @Override
    public int getItemID(Item i) {
        return Item.func_150891_b((Item)i);
    }

    @Override
    public String getNameFromID(int i) {
        return String.valueOf(Item.field_150901_e.func_177774_c(Item.field_150901_e.func_148754_a(i)));
    }
}

