/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.debug;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.expansion.FolderExpansionDebugUnit;
import eu.ha3.matmos.debug.Pluggable;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import java.io.File;
import java.util.Optional;

public class PluggableIntoMAtmos
implements Pluggable {
    private Matmos mod;
    private String expansionName;
    private boolean isReadOnly;
    private File file;
    private File workingDirectory;

    public PluggableIntoMAtmos(Matmos mod, Expansion expansion) {
        this.mod = mod;
        if (expansion.obtainDebugUnit() instanceof FolderExpansionDebugUnit) {
            this.file = ((FolderExpansionDebugUnit)expansion.obtainDebugUnit()).getExpansionFile();
            this.workingDirectory = ((FolderExpansionDebugUnit)expansion.obtainDebugUnit()).getExpansionFolder();
            this.isReadOnly = false;
        } else {
            this.isReadOnly = true;
        }
        this.expansionName = expansion.getName();
    }

    @Override
    public void pushJson(String json) {
        this.mod.queueForNextTick(() -> {
            Optional<Expansion> opt = this.mod.getExpansionEffort(this.expansionName);
            if (opt.isPresent()) {
                Expansion expansion = opt.get();
                this.mod.getChatter().printChat(ATextFormatting.AQUA, "Reloading from editor state: " + expansion.getName() + " " + this.getTimestamp());
                expansion.pushDebugJsonAndRefreshKnowledge(json);
            }
        });
    }

    @Override
    public void reloadFromDisk() {
        this.mod.queueForNextTick(() -> this.mod.getExpansionEffort(this.expansionName).ifPresent(expansion -> {
            this.mod.getChatter().printChat(ATextFormatting.BLUE, "Reloading from disk: ", expansion.getName() + " " + this.getTimestamp());
            expansion.refreshKnowledge();
        }));
    }

    protected String getTimestamp() {
        return ATextFormatting.BLACK + "(" + System.currentTimeMillis() + ")";
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public File getWorkingDirectoryIfAvailable() {
        return this.workingDirectory;
    }

    @Override
    public File getFileIfAvailable() {
        return this.file;
    }

    @Override
    public void onEditorClosed() {
    }
}

