/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.gui;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.expansion.ExpansionDebugUnit;
import eu.ha3.matmos.core.expansion.FolderExpansionDebugUnit;
import eu.ha3.matmos.debug.SoundsJsonGenerator;
import eu.ha3.matmos.game.user.VisualExpansionDebugging;
import eu.ha3.matmos.gui.GuiExpansionOverrides;
import eu.ha3.matmos.gui.GuiMatMenu;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import java.io.File;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;

public class GuiExpansionDetails
extends GuiScreen {
    private final GuiMatMenu parentScreen;
    private final Matmos mod;
    private final Expansion expansion;
    private final VisualExpansionDebugging debug;

    public GuiExpansionDetails(GuiMatMenu menu, Matmos mod, Expansion expansion) {
        this.parentScreen = menu;
        this.mod = mod;
        this.expansion = expansion;
        this.debug = new VisualExpansionDebugging(this.mod, expansion.getName());
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -268435456, -1879048192);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"mat.mode.dev", (Object[])new Object[]{this.expansion.getFriendlyName(), this.expansion.getName()}), this.field_146294_l / 2, 4, 0xFFFFFF);
        this.debug.onFrame(0.0f);
        super.func_73863_a(par1, par2, par3);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        int h = new ScaledResolution(this.field_146297_k).func_78328_b() - 22;
        this.field_146292_n.add(new GuiButton(200, 2, h, 70, 20, I18n.func_135052_a((String)"mat.options.close", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(201, 74, h, 70, 20, I18n.func_135052_a((String)"mat.options.osd", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(202, 146, h, 70, 20, I18n.func_135052_a((String)"mat.options.reload", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(203, 218, h, 110, 20, I18n.func_135052_a((String)"mat.options.editor", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(204, 330, h, 96, 20, I18n.func_135052_a((String)"mat.options.sounds", (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton button) {
        ExpansionDebugUnit debugUnit;
        if (button.field_146127_k == 200) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
        } else if (button.field_146127_k == 201) {
            this.mod.getVisualDebugger().debugModeExpansion(this.debug);
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 202) {
            this.expansion.refreshKnowledge();
        } else if (button.field_146127_k == 203) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiExpansionOverrides(this, this.mod, this.expansion));
        } else if (button.field_146127_k == 204 && (debugUnit = this.expansion.obtainDebugUnit()) instanceof FolderExpansionDebugUnit) {
            File expFolder = ((FolderExpansionDebugUnit)debugUnit).getExpansionFolder();
            File minecraftFolder = new File(expFolder, "assets/minecraft/");
            if (minecraftFolder.exists()) {
                File soundsFolder = new File(minecraftFolder, "sounds/");
                File jsonFile = new File(minecraftFolder, "sounds.json");
                if (soundsFolder.exists()) {
                    try {
                        new SoundsJsonGenerator(soundsFolder, jsonFile).run();
                        this.mod.getChatter().printChat(I18n.func_135052_a((String)"mat.generator.done", (Object[])new Object[]{jsonFile.getAbsolutePath()}));
                        this.mod.getChatter().printChatShort(I18n.func_135052_a((String)"mat.generator.plswait", (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        IDontKnowHowToCode.whoops__printExceptionToChat(this.mod.getChatter(), e, (Object)this);
                    }
                } else {
                    this.mod.getChatter().printChat(ATextFormatting.RED, I18n.func_135052_a((String)"mat.folders.sounds", (Object[])new Object[0]));
                }
            } else {
                this.mod.getChatter().printChat(ATextFormatting.RED, I18n.func_135052_a((String)"mat.folders.mc", (Object[])new Object[0]));
            }
        }
    }
}

