/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.gui;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.expansion.VolumeUpdatable;
import eu.ha3.matmos.gui.GuiExpansionDetails;
import eu.ha3.matmos.gui.GuiExpansionInfo;
import eu.ha3.matmos.gui.GuiModules;
import eu.ha3.matmos.gui.GuiMore;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import eu.ha3.matmos.lib.eu.ha3.mc.gui.HGuiSliderControl;
import eu.ha3.matmos.lib.eu.ha3.mc.gui.HSliderListener;
import eu.ha3.matmos.util.MAtUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.resources.I18n;

public class GuiMatMenu
extends GuiScreen {
    private GuiScreen parentScreen;
    private Matmos mod;
    private int buttonId = -1;
    private int pageFromZero;
    private final int IDS_PER_PAGE = 5;
    private final List<Expansion> expansionList = new ArrayList<Expansion>();
    private static int in_memory_page = 0;
    private boolean isBlank;

    public GuiMatMenu(GuiScreen par1GuiScreen, Matmos matmos) {
        this(par1GuiScreen, matmos, in_memory_page);
    }

    public GuiMatMenu(GuiScreen par1GuiScreen, Matmos matmos, int pageFromZero) {
        this.parentScreen = par1GuiScreen;
        this.mod = matmos;
        in_memory_page = this.pageFromZero = pageFromZero;
    }

    public void func_73866_w_() {
        if (!this.mod.isActivated()) {
            this.isBlank = true;
            return;
        }
        int _GAP = 2;
        int _UNIT = 20;
        int _ELEMENT_WIDTH = 310;
        int _MIX = 22;
        int _LEFT = this.field_146294_l / 2 - 155;
        int _RIGHT = this.field_146294_l / 2 + 155;
        int _PREVNEWTWIDTH = 103;
        int _ASPLIT = 2;
        int _AWID = 154;
        int _SEPARATOR = 10;
        Map<String, Expansion> expansions = this.mod.getExpansionList();
        int id = 0;
        VolumeUpdatable globalVolumeControl = this.mod.getGlobalVolumeControl();
        HGuiSliderControl sliderControl = new HGuiSliderControl(id, _LEFT, 22, 310, 20, "", globalVolumeControl.getVolume() * 0.5f);
        sliderControl.setListener((slider, value) -> {
            globalVolumeControl.setVolumeAndUpdate(value * 2.0f);
            slider.updateDisplayString();
            this.mod.getConfig().setProperty("globalvolume.scale", Float.valueOf(globalVolumeControl.getVolume()));
        });
        sliderControl.setDisplayStringProvider(() -> I18n.func_135052_a((String)"mat.options.volume", (Object[])new Object[]{(int)Math.floor(globalVolumeControl.getVolume() * 100.0f) + "%"}));
        sliderControl.updateDisplayString();
        this.field_146292_n.add(sliderControl);
        ++id;
        ArrayList<String> sortedNames = new ArrayList<String>(expansions.keySet());
        Collections.sort(sortedNames);
        for (int expansionIndex = this.pageFromZero * 5; expansionIndex < this.pageFromZero * 5 + 5 && expansionIndex < sortedNames.size(); ++expansionIndex) {
            String uniqueIdentifier = (String)sortedNames.get(expansionIndex);
            final Expansion expansion = expansions.get(uniqueIdentifier);
            this.expansionList.add(expansion);
            HGuiSliderControl sliderControl2 = new HGuiSliderControl(id, _LEFT + 22, 22 * (id + 1), 266, 20, "", expansion.getVolume() * 0.5f);
            sliderControl2.setListener(new HSliderListener(){

                @Override
                public void sliderValueChanged(HGuiSliderControl slider, float value) {
                    expansion.setVolumeAndUpdate(value * 2.0f);
                    if (value > 0.0f && !expansion.isActivated()) {
                        expansion.activate();
                    }
                    slider.updateDisplayString();
                }

                @Override
                public void sliderReleased(HGuiSliderControl hGuiSliderControl) {
                    if (GuiMatMenu.this.isAutopreviewEnabled()) {
                        expansion.playSample();
                    }
                }
            });
            sliderControl2.setDisplayStringProvider(() -> {
                String display = expansion.getFriendlyName() + ": ";
                display = expansion.getVolume() == 0.0f ? (expansion.isActivated() ? display + "Will be disabled" : display + "Disabled") : display + (int)Math.floor(expansion.getVolume() * 100.0f) + "%";
                return ATextFormatting.ITALIC + display;
            });
            sliderControl2.updateDisplayString();
            this.field_146292_n.add(sliderControl2);
            if (!this.mod.isDebugMode()) {
                this.field_146292_n.add(new GuiButton(Make.make(() -> {
                    if (expansion.isActivated()) {
                        expansion.playSample();
                    }
                }), _RIGHT - 20, 22 * (id + 1), 20, 20, "?"));
                if (expansion.hasMoreInfo()) {
                    this.field_146292_n.add(new GuiButton(Make.make(() -> this.field_146297_k.func_147108_a((GuiScreen)new GuiExpansionInfo(this, this.mod, expansion))), _RIGHT + 2, 22 * (id + 1), 20, 20, "..."));
                }
            } else {
                this.field_146292_n.add(new GuiButton(Make.make(() -> this.field_146297_k.func_147108_a((GuiScreen)new GuiExpansionDetails(this, this.mod, expansion))), _RIGHT - 20, 22 * (id + 1), 20, 20, ATextFormatting.GOLD + "+"));
            }
            ++id;
        }
        if (!this.mod.isDebugMode()) {
            this.field_146292_n.add(new GuiButton(220, _RIGHT - 20, 154, 20, 20, this.isAutopreviewEnabled() ? "^o^" : "^_^"));
        } else {
            this.field_146292_n.add(new GuiButton(230, _RIGHT - 20, 154, 40, 20, ATextFormatting.GOLD + "OSD"));
        }
        if (this.pageFromZero != 0) {
            this.field_146292_n.add(new GuiButton(201, _LEFT + 22, 154, 103, 20, I18n.func_135052_a((String)"mat.options.prev", (Object[])new Object[0])));
        }
        if (this.pageFromZero * 5 + 5 < sortedNames.size()) {
            this.field_146292_n.add(new GuiButton(202, _RIGHT - 22 - 103, 154, 103, 20, I18n.func_135052_a((String)"mat.options.next", (Object[])new Object[0])));
        }
        this.field_146292_n.add(new GuiButton(210, _LEFT, 186, 154, 20, I18n.func_135052_a((String)("mat.options.start." + this.mod.getConfig().getBoolean("start.enabled")), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(211, _LEFT + 154 + 2, 186, 154, 20, (this.mod.isDebugMode() ? ATextFormatting.GOLD : "") + I18n.func_135052_a((String)"mat.options.advanced", (Object[])new Object[0])));
        int _TURNOFFWIDTH = 62;
        this.field_146292_n.add(new GuiButton(200, _LEFT + 22, 208, 202, 20, "Done"));
        this.field_146292_n.add(new GuiButton(212, _RIGHT - 62 - 22, 208, 62, 20, "Turn Off"));
        if (!this.mod.hasResourcePacksLoaded()) {
            this.field_146292_n.add(new GuiButton(199, _LEFT + 22, 142, 266, 20, (this.mod.hasNonethelessResourcePacksInstalled() ? "Enable" : "Install") + " MAtmos Resource Pack"));
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k == 200) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else if (par1GuiButton.field_146127_k == 199) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenResourcePacks((GuiScreen)this));
        } else if (par1GuiButton.field_146127_k == 201) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMatMenu(this.parentScreen, this.mod, this.pageFromZero - 1));
        } else if (par1GuiButton.field_146127_k == 202) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMatMenu(this.parentScreen, this.mod, this.pageFromZero + 1));
        } else if (par1GuiButton.field_146127_k == 210) {
            boolean newEnabledState = !this.mod.getConfig().getBoolean("start.enabled");
            this.mod.getConfig().setProperty("start.enabled", (Object)newEnabledState);
            par1GuiButton.field_146126_j = I18n.func_135052_a((String)("mat.options.start." + newEnabledState), (Object[])new Object[0]);
            this.mod.saveConfig();
        } else if (par1GuiButton.field_146127_k == 211) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMore(this, this.mod));
        } else if (par1GuiButton.field_146127_k == 212) {
            this.field_146297_k.func_147108_a(this.parentScreen);
            this.mod.deactivate();
        } else if (par1GuiButton.field_146127_k == 220) {
            this.mod.getConfig().setProperty("sound.autopreview", (Object)(!this.isAutopreviewEnabled() ? 1 : 0));
            par1GuiButton.field_146126_j = this.isAutopreviewEnabled() ? "^o^" : "^_^";
            this.mod.saveConfig();
        } else if (par1GuiButton.field_146127_k == 230) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiModules(this, this.mod));
        } else {
            Make.perform(par1GuiButton.field_146127_k);
        }
    }

    private boolean isAutopreviewEnabled() {
        return this.mod.getConfig().getBoolean("sound.autopreview");
    }

    private void aboutToClose() {
        this.mod.synchronize();
        this.mod.saveExpansions();
        this.mod.saveConfig();
    }

    public void func_146281_b() {
        this.aboutToClose();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.buttonId < 0) {
            try {
                super.func_73864_a(mouseX, mouseY, mouseButton);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int _GAP = 2;
        int _UNIT = 20;
        int _MIX = 22;
        int _SEPARATOR = 10;
        if (!this.mod.isDebugMode()) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1073741824, 0x60000000);
            this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.title.expansions", (Object[])new Object[0]), this.field_146294_l / 2, 8, 0xFFFFFF);
        } else {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1061134336, 0x60C06000);
            this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.title.expansions", (Object[])new Object[0]) + ATextFormatting.GOLD + "(Dev mode)", this.field_146294_l / 2, 8, 0xFFFFFF);
            this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.title.devmode", (Object[])new Object[0]), this.field_146294_l / 2, 177, 0xFFFFFF);
        }
        this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.title.reloadhint", (Object[])new Object[0]), this.field_146294_l / 2, 230, 0xFFFFFF);
        this.mod.util().prepareDrawString();
        this.mod.util().drawString(I18n.func_135052_a((String)"mat.resources.lag", (Object[])new Object[]{this.mod.getLag().getMilliseconds()}), 1.0f, 1.0f, 0, 0, '3', 0, 0, 0, 0, true);
        if (!this.mod.hasResourcePacksLoaded()) {
            if (this.mod.hasNonethelessResourcePacksInstalled()) {
                this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.resources.off.1", (Object[])new Object[0]), this.field_146294_l / 2, 122, 0xFF0000);
                this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.resources.off.2", (Object[])new Object[0]), this.field_146294_l / 2, 130, 0xFF0000);
            } else {
                this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.resources.none.1", (Object[])new Object[0]), this.field_146294_l / 2, 122, 0xFF0000);
                this.func_73732_a(MAtUtil.getFontRenderer(), I18n.func_135052_a((String)"mat.resources.none.2", (Object[])new Object[0]), this.field_146294_l / 2, 130, 0xFF0000);
            }
        }
        super.func_73863_a(par1, par2, par3);
        if (this.isBlank && this.mod.isActivated()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMatMenu((GuiScreen)this.mod.util().getCurrentScreen(), this.mod));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @FunctionalInterface
    private static interface ActionPerformed {
        public void actionPerformed();
    }

    @Deprecated
    private static class Make {
        private static int makeIn = 1000;
        private static Map<Integer, ActionPerformed> actions = new HashMap<Integer, ActionPerformed>();

        private Make() {
        }

        public static int make(ActionPerformed callback) {
            int make = makeIn++;
            actions.put(make, callback);
            return make;
        }

        public static void perform(int action) {
            if (!actions.containsKey(action)) {
                return;
            }
            actions.get(action).actionPerformed();
        }
    }
}

