/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.eu.ha3.mc.haddon.forge;

import eu.ha3.matmos.lib.eu.ha3.mc.haddon.Haddon;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.OperatorCaster;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonUtilityImpl;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.ProfilerHelper;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsBlockChangeEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsClientTickEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsInGameChangeEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsPlayerFrameEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsSoundEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsSoundSetupEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsTickEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.event.BlockChangeEvent;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Logger;

public class ForgeBase
implements OperatorCaster {
    private static Logger logger;
    protected final Haddon haddon;
    protected final boolean shouldTick;
    protected final boolean suTick;
    protected final boolean suClientTick;
    protected final boolean suFrame;
    protected final boolean suFrameP;
    protected final boolean suInGame;
    protected final boolean suSound;
    protected final boolean suBlockChange;
    protected final boolean suSoundSetup;
    protected int tickCounter;
    protected boolean enableTick;
    protected boolean enableFrame;
    private int ticksSinceLastRender = 0;
    private boolean wasInGame;
    private Queue<BlockChangeEvent> blockEventQueue = new LinkedBlockingQueue<BlockChangeEvent>();

    public ForgeBase(Haddon haddon) {
        this.haddon = haddon;
        this.suTick = haddon instanceof SupportsTickEvents;
        this.suClientTick = haddon instanceof SupportsClientTickEvents;
        this.suFrame = haddon instanceof SupportsFrameEvents;
        this.suFrameP = haddon instanceof SupportsPlayerFrameEvents;
        this.suInGame = haddon instanceof SupportsInGameChangeEvents;
        this.suBlockChange = haddon instanceof SupportsBlockChangeEvents;
        this.suSound = haddon instanceof SupportsSoundEvents;
        this.suSoundSetup = haddon instanceof SupportsSoundSetupEvents;
        this.shouldTick = this.suTick || this.suFrame;
        haddon.setUtility(new HaddonUtilityImpl(){

            @Override
            public long getClientTick() {
                return ForgeBase.this.getTicks();
            }
        });
        haddon.setOperator(this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderViewEntity = mc.func_175606_aa();
        boolean inGame = renderViewEntity != null && renderViewEntity.field_70170_p != null;
        this.onTickLiteLoaderStyle(mc, -1.0f, inGame, true, true);
        ++this.ticksSinceLastRender;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        boolean clock = this.ticksSinceLastRender > 0;
        this.ticksSinceLastRender = 0;
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_147113_T() ? mc.field_193996_ah : mc.func_184121_ak();
        Entity renderViewEntity = mc.func_175606_aa();
        boolean inGame = renderViewEntity != null && renderViewEntity.field_70170_p != null;
        this.onTickLiteLoaderStyle(mc, partialTicks, inGame, clock, false);
    }

    @SubscribeEvent
    public void onSoundEvent(PlaySoundEvent event) {
        if (!this.shouldTick) {
            return;
        }
        if (this.suSound && !((SupportsSoundEvents)((Object)this.haddon)).onSound(event.getSound(), event.getName(), event.getManager())) {
            event.setResultSound(null);
        }
    }

    private void onTickLiteLoaderStyle(Minecraft minecraft, float partialTicks, boolean inGame, boolean clock, boolean trueClock) {
        if (trueClock && !this.suClientTick) {
            return;
        }
        if (inGame != this.wasInGame && this.suInGame) {
            ((SupportsInGameChangeEvents)((Object)this.haddon)).onInGameChange(inGame);
        }
        this.wasInGame = inGame;
        if (!this.shouldTick || !inGame) {
            return;
        }
        Profiler p = Minecraft.func_71410_x().field_71424_I;
        List<String> profilerSections = ProfilerHelper.goToRoot(p);
        p.func_76320_a(this.haddon.getIdentity().getHaddonName());
        if (this.enableTick && (this.suClientTick ? trueClock : clock)) {
            if (this.suTick) {
                ((SupportsTickEvents)((Object)this.haddon)).onTick();
            }
            ++this.tickCounter;
        }
        if (this.suBlockChange) {
            while (!this.blockEventQueue.isEmpty()) {
                ((SupportsBlockChangeEvents)((Object)this.haddon)).onBlockChanged(this.blockEventQueue.remove());
            }
        }
        if (this.enableFrame && !trueClock) {
            if (this.suFrame) {
                ((SupportsFrameEvents)((Object)this.haddon)).onFrame(partialTicks);
            }
            if (this.suFrameP) {
                for (EntityPlayer ply : this.haddon.getUtility().getClient().getAllPlayers()) {
                    if (ply == null) continue;
                    ((SupportsPlayerFrameEvents)((Object)this.haddon)).onFrame(ply, partialTicks);
                }
            }
        }
        p.func_76319_b();
        ProfilerHelper.startNestedSection(p, profilerSections);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event, String modid, String name, String version) {
        this.haddon.onLoad();
    }

    @SubscribeEvent
    public void onBlock(BlockEvent event) {
        if (!this.shouldTick || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (this.suBlockChange) {
            Block oldBlock = null;
            Block newBlock = null;
            if (event instanceof BlockEvent.PlaceEvent) {
                oldBlock = Block.func_149729_e((int)0);
                newBlock = ((BlockEvent.PlaceEvent)event).getPlacedBlock().func_177230_c();
            } else if (event instanceof BlockEvent.BreakEvent) {
                oldBlock = event.getState().func_177230_c();
                newBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.getPos()).func_177230_c();
            }
            if (oldBlock != null) {
                this.blockEventQueue.add(new BlockChangeEvent(event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), oldBlock, newBlock));
            }
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundSetupEvent event) {
        if (this.suSoundSetup) {
            ((SupportsSoundSetupEvents)((Object)this.haddon)).onSoundSetup(event.getManager());
        }
    }

    @Override
    public void setTickEnabled(boolean enabled) {
        this.enableTick = enabled;
    }

    @Override
    public boolean getTickEnabled() {
        return this.enableTick;
    }

    @Override
    public void setFrameEnabled(boolean enabled) {
        this.enableFrame = enabled;
    }

    @Override
    public boolean getFrameEnabled() {
        return this.enableFrame;
    }

    @Override
    public int getTicks() {
        return this.tickCounter;
    }
}

