/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem;

import eu.ha3.matmos.lib.eu.ha3.mc.haddon.Client;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.Utility;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonClientImpl;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.Instantiator;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.NullInstantiator;
import java.io.File;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.input.Keyboard;

public abstract class HaddonUtilityImpl
implements Utility {
    private static final int WORLD_HEIGHT = 256;
    private static final NullInstantiator NULL_INSTANTIATOR = new NullInstantiator();
    private static final HaddonClientImpl client = new HaddonClientImpl();
    protected long ticksRan;
    protected File mcFolder;
    protected File modsFolder;
    private ScaledResolution drawString_scaledRes = null;
    private int drawString_screenWidth;
    private int drawString_screenHeight;
    private int drawString_textHeight;

    @Override
    public boolean isPresent(String className) {
        return NULL_INSTANTIATOR.lookupClass(className) != null;
    }

    @Override
    public <E> Instantiator<E> getInstantiator(String className, Class<?> ... types) {
        return NULL_INSTANTIATOR.getOrCreate(className, types);
    }

    @Override
    public int getWorldHeight() {
        return 256;
    }

    @Override
    public Object getCurrentScreen() {
        return HaddonUtilityImpl.client.unsafe().field_71462_r;
    }

    @Override
    public boolean isCurrentScreen(Class<?> classtype) {
        Object current = this.getCurrentScreen();
        if (classtype == null) {
            return current == null;
        }
        if (current == null) {
            return false;
        }
        return classtype.isInstance(current);
    }

    @Override
    public void displayScreen(Object screen) {
        client.unsafe().func_147108_a((GuiScreen)screen);
    }

    @Override
    public void closeCurrentScreen() {
        this.displayScreen(null);
    }

    @Override
    public Client getClient() {
        return client;
    }

    @Override
    public void pauseSounds(boolean pause) {
        if (pause) {
            client.unsafe().func_147118_V().func_147689_b();
        } else {
            client.unsafe().func_147118_V().func_147687_e();
        }
    }

    @Override
    public boolean isGamePaused() {
        Object current = this.getCurrentScreen();
        return current != null && ((GuiScreen)current).func_73868_f() && this.isSingleplayer();
    }

    @Override
    public boolean isSingleplayer() {
        return client.unsafe().func_71356_B() && !client.unsafe().func_71401_C().func_71344_c();
    }

    @Override
    public void printChat(Object ... args) {
        if (client.getPlayer() == null) {
            return;
        }
        TextComponentString message = new TextComponentString("");
        Style style = null;
        for (Object o : args) {
            TextComponentTranslation line;
            if (o instanceof TextFormatting) {
                TextFormatting code = (TextFormatting)o;
                if (style == null) {
                    style = new Style();
                }
                switch (code) {
                    case OBFUSCATED: {
                        style.func_150237_e(Boolean.valueOf(true));
                        break;
                    }
                    case BOLD: {
                        style.func_150227_a(Boolean.valueOf(true));
                        break;
                    }
                    case STRIKETHROUGH: {
                        style.func_150225_c(Boolean.valueOf(true));
                        break;
                    }
                    case UNDERLINE: {
                        style.func_150228_d(Boolean.valueOf(true));
                        break;
                    }
                    case ITALIC: {
                        style.func_150217_b(Boolean.valueOf(true));
                        break;
                    }
                    case RESET: {
                        style = null;
                        break;
                    }
                    default: {
                        style.func_150238_a(code);
                        break;
                    }
                }
                continue;
            }
            if (o instanceof ClickEvent) {
                if (style == null) {
                    style = new Style();
                }
                style.func_150241_a((ClickEvent)o);
                continue;
            }
            if (o instanceof HoverEvent) {
                if (style == null) {
                    style = new Style();
                }
                style.func_150209_a((HoverEvent)o);
                continue;
            }
            if (o instanceof ITextComponent) {
                if (style != null) {
                    ((ITextComponent)o).func_150255_a(style);
                    style = null;
                }
                message.func_150257_a((ITextComponent)o);
                continue;
            }
            if (o instanceof Style) {
                if (((Style)o).func_150229_g()) continue;
                if (style != null) {
                    this.inheritFlat((Style)o, style);
                }
                style = (Style)o;
                continue;
            }
            Object object = line = o instanceof String ? new TextComponentTranslation((String)o, new Object[0]) : new TextComponentString(String.valueOf(o));
            if (style != null) {
                line.func_150255_a(style);
                style = null;
            }
            message.func_150257_a((ITextComponent)line);
        }
        client.getPlayer().func_145747_a((ITextComponent)message);
    }

    private void inheritFlat(Style parent, Style child) {
        Object temp;
        if (parent.func_150223_b() != child.func_150223_b() && child.func_150223_b()) {
            parent.func_150227_a(Boolean.valueOf(true));
        }
        if (parent.func_150242_c() != child.func_150242_c() && child.func_150242_c()) {
            parent.func_150217_b(Boolean.valueOf(true));
        }
        if (parent.func_150236_d() != child.func_150236_d() && child.func_150236_d()) {
            parent.func_150225_c(Boolean.valueOf(true));
        }
        if (parent.func_150234_e() != child.func_150234_e() && child.func_150234_e()) {
            parent.func_150228_d(Boolean.valueOf(true));
        }
        if (parent.func_150233_f() != child.func_150233_f() && child.func_150233_f()) {
            parent.func_150237_e(Boolean.valueOf(true));
        }
        if ((temp = child.func_150215_a()) != null) {
            parent.func_150238_a(temp);
        }
        if ((temp = child.func_150235_h()) != null) {
            parent.func_150241_a((ClickEvent)temp);
        }
        if ((temp = child.func_150210_i()) != null) {
            parent.func_150209_a((HoverEvent)temp);
        }
        if ((temp = child.func_179986_j()) != null) {
            parent.func_179989_a((String)temp);
        }
    }

    @Override
    public boolean areKeysDown(int ... args) {
        for (int arg : args) {
            if (Keyboard.isKeyDown((int)arg)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void prepareDrawString() {
        this.drawString_scaledRes = new ScaledResolution(client.unsafe());
        this.drawString_screenWidth = this.drawString_scaledRes.func_78326_a();
        this.drawString_screenHeight = this.drawString_scaledRes.func_78328_b();
        this.drawString_textHeight = HaddonUtilityImpl.client.getFontRenderer().field_78288_b;
    }

    @Override
    public void drawString(String text, float px, float py, int offx, int offy, char alignment, int cr, int cg, int cb, int ca, boolean hasShadow) {
        if (this.drawString_scaledRes == null) {
            this.prepareDrawString();
        }
        FontRenderer font = client.getFontRenderer();
        int xPos = (int)Math.floor(px * (float)this.drawString_screenWidth) + offx;
        int yPos = (int)Math.floor(py * (float)this.drawString_screenHeight) + offy;
        if (alignment == '2' || alignment == '5' || alignment == '8') {
            xPos -= font.func_78256_a(text) / 2;
        } else if (alignment == '3' || alignment == '6' || alignment == '9') {
            xPos -= font.func_78256_a(text);
        }
        if (alignment == '4' || alignment == '5' || alignment == '6') {
            yPos -= this.drawString_textHeight / 2;
        } else if (alignment == '1' || alignment == '2' || alignment == '3') {
            yPos -= this.drawString_textHeight;
        }
        int color = ca << 24 | cr << 16 | cg << 8 | cb;
        if (hasShadow) {
            font.func_175063_a(text, (float)xPos, (float)yPos, color);
        } else {
            font.func_78276_b(text, xPos, yPos, color);
        }
    }

    @Override
    public File getModsFolder() {
        if (this.modsFolder == null) {
            this.modsFolder = new File(this.getMcFolder(), "mods");
        }
        return this.modsFolder;
    }

    @Override
    public File getMcFolder() {
        if (this.mcFolder == null) {
            this.mcFolder = HaddonUtilityImpl.client.unsafe().field_71412_D;
        }
        return this.mcFolder;
    }
}

