/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.eu.ha3.util.property.simple;

import com.google.common.io.Files;
import eu.ha3.matmos.lib.eu.ha3.util.property.contract.ConfigSource;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.VersionnableProperty;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;

public class ConfigProperty
extends VersionnableProperty
implements ConfigSource {
    private String path;
    private String globalDescription = "";
    private Map<String, String> descriptionMap = new HashMap<String, String>();

    @Override
    public void setSource(String source) {
        this.path = source;
    }

    @Override
    public boolean load() {
        File file = new File(this.path);
        if (file.exists()) {
            try {
                IOUtils.readLines((Reader)new FileReader(file)).forEach(l -> {
                    if (!l.startsWith("#") && !l.isEmpty()) {
                        if (l.contains("=")) {
                            String[] parts = l.split("=");
                            this.setProperty(parts[0], parts.length > 1 ? parts[1] : "");
                        } else {
                            LogManager.getLogger((String)"haddon").warn("Ignoring malformed line in " + file.getName() + ": " + l);
                        }
                    }
                });
                this.commit();
                this.save();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.revert();
            }
        } else {
            this.save();
        }
        return false;
    }

    @Override
    public boolean save() {
        try {
            File userFile = new File(this.path);
            Files.createParentDirs((File)userFile);
            try (FileWriter writer = new FileWriter(userFile);){
                if (!this.globalDescription.isEmpty()) {
                    this.writeComment(this.globalDescription, writer);
                    writer.write("\n");
                }
                for (String k : this.getAllProperties().keySet().stream().sorted().collect(Collectors.toList())) {
                    String v = this.getString(k);
                    if (this.descriptionMap.containsKey(k)) {
                        this.writeComment(this.descriptionMap.get(k), writer);
                    }
                    writer.write(k + "=" + v + "\n\n");
                }
            }
            catch (IOException e) {
                LogManager.getLogger((String)"haddon").error("Failed to save config: " + e);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void writeComment(String desc, Writer writer) throws IOException {
        for (String descriptionLine : desc.split("\n")) {
            writer.write("# " + descriptionLine + "\n");
        }
    }

    public void setProperty(String name, Object o, String description) {
        super.setProperty(name, o);
        this.descriptionMap.put(name, description);
    }

    public void createProperty(String name, Object o, String description) {
        super.createProperty(name, o);
        this.descriptionMap.put(name, description);
    }

    public void setGlobalDescription(String globalDesc) {
        this.globalDescription = globalDesc != null ? globalDesc : "";
    }
}

