/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.bean;

import eu.ha3.matmos.lib.net.sf.kdgcommons.bean.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspection {
    private boolean _setAccessible;
    private Set<String> _propNames;
    private Set<String> _propNamesPublic;
    private Map<String, Method> _getters;
    private Map<String, Method> _setters;

    public Introspection(Class<?> klass) {
        this(klass, false);
    }

    public Introspection(Class<?> klass, boolean setAccessible) {
        this._setAccessible = setAccessible;
        this._propNames = new HashSet<String>();
        this._propNamesPublic = Collections.unmodifiableSet(this._propNames);
        this._getters = new HashMap<String, Method>();
        this._setters = new HashMap<String, Method>();
        this.introspect(klass);
    }

    public Set<String> propertyNames() {
        return this._propNamesPublic;
    }

    public Method getter(String propName) {
        return this._getters.get(propName.toLowerCase());
    }

    public Method setter(String propName) {
        return this._setters.get(propName.toLowerCase());
    }

    public Class<?> type(String propName) {
        Method getter = this.getter(propName);
        return getter == null ? null : getter.getReturnType();
    }

    private void introspect(Class<?> klass) {
        try {
            for (Method method : klass.getMethods()) {
                String propName;
                if (method.getDeclaringClass() == Object.class) continue;
                String methodName = method.getName();
                int paramCount = method.getParameterTypes().length;
                if (methodName.startsWith("get") && paramCount == 0) {
                    propName = this.extractAndSavePropName(methodName, 3);
                    this.saveGetter(propName, method);
                    continue;
                }
                if (methodName.startsWith("is") && paramCount == 0) {
                    propName = this.extractAndSavePropName(methodName, 2);
                    this.saveGetter(propName, method);
                    continue;
                }
                if (!methodName.startsWith("set") || paramCount != 1) continue;
                propName = this.extractAndSavePropName(methodName, 3);
                this.saveSetter(propName, method);
            }
        }
        catch (Exception ee) {
            throw new IntrospectionException("unable to introspect", ee);
        }
    }

    private String extractAndSavePropName(String methodName, int pos) {
        String propName = methodName.substring(pos);
        this._propNames.add(Introspector.decapitalize(propName));
        return propName.toLowerCase();
    }

    private void saveGetter(String propName, Method method) {
        Method existing;
        if (this._setAccessible) {
            method.setAccessible(true);
        }
        if ((existing = this._getters.get(propName)) == null) {
            this._getters.put(propName, method);
            return;
        }
        Class<?> methodClass = method.getReturnType();
        Class<?> existingClass = existing.getReturnType();
        if (existingClass.isAssignableFrom(methodClass)) {
            this._getters.put(propName, method);
            return;
        }
    }

    private void saveSetter(String propName, Method method) {
        Method existing;
        if (this._setAccessible) {
            method.setAccessible(true);
        }
        if ((existing = this._setters.get(propName)) == null) {
            this._setters.put(propName, method);
            return;
        }
        Class<?> methodClass = method.getDeclaringClass();
        Class<?> existingClass = existing.getDeclaringClass();
        if (!existingClass.isAssignableFrom(methodClass)) {
            return;
        }
        if (methodClass != existingClass) {
            this._setters.put(propName, method);
            return;
        }
        if (Introspection.setterRank(method) < Introspection.setterRank(existing)) {
            this._setters.put(propName, method);
            return;
        }
    }

    private static int setterRank(Method method) {
        Class<?> parmClass = method.getParameterTypes()[0];
        if (parmClass.isPrimitive()) {
            return 1;
        }
        if (Number.class.isAssignableFrom(parmClass)) {
            return 2;
        }
        if (String.class.isAssignableFrom(parmClass)) {
            return 3;
        }
        return 4;
    }
}

