/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.codec;

import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.Codec;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.CodecException;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.InvalidSourceByteException;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64Codec
extends Codec {
    private static char[] defaultCharLookup;
    private static HashMap<Character, Integer> defaultValueLookup;
    private static char[] filenameCharLookup;
    private static HashMap<Character, Integer> filenameValueLookup;
    private int _lineLength;
    private byte[] _separator;
    private char[] _charLookup;
    private HashMap<Character, Integer> _valueLookup;
    private char _padChar;
    private boolean _paddingRequired;

    public Base64Codec() {
        this(Option.UNBROKEN);
    }

    public Base64Codec(Option option) {
        this(option._lineLength, option._separator, option._charLookup, option._valueLookup, option._padChar);
    }

    public Base64Codec(int lineLength, String separator) {
        this(lineLength, StringUtil.toUTF8(separator));
    }

    public Base64Codec(int lineLength, byte[] separator) {
        this(lineLength, separator, defaultCharLookup, defaultValueLookup, '=');
    }

    private Base64Codec(int lineLength, byte[] separator, char[] charLookup, HashMap<Character, Integer> valueLookup, char padChar) {
        this._lineLength = lineLength;
        this._separator = separator;
        this._charLookup = charLookup;
        this._valueLookup = valueLookup;
        this._padChar = padChar;
        this._paddingRequired = this._padChar != '\u0000';
    }

    @Override
    public void encode(InputStream in, OutputStream out) {
        new Encoder(in, out).encode();
    }

    @Override
    public void decode(InputStream in, OutputStream out) {
        new Decoder(in, out).decode();
    }

    public String toString(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        byte[] encoded = this.encode(data);
        return StringUtil.fromUTF8(encoded);
    }

    public byte[] toBytes(String str) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY_ARRAY;
        }
        byte[] bytes = StringUtil.toUTF8(str);
        return this.decode(bytes);
    }

    static /* synthetic */ char[] access$000() {
        return defaultCharLookup;
    }

    static /* synthetic */ HashMap access$100() {
        return defaultValueLookup;
    }

    static /* synthetic */ char[] access$200() {
        return filenameCharLookup;
    }

    static /* synthetic */ HashMap access$300() {
        return filenameValueLookup;
    }

    static {
        int ii;
        defaultCharLookup = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        defaultValueLookup = new HashMap(64);
        defaultValueLookup.put(Character.valueOf('='), -1);
        for (ii = 0; ii < defaultCharLookup.length; ++ii) {
            defaultValueLookup.put(Character.valueOf(defaultCharLookup[ii]), ii);
        }
        filenameCharLookup = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        filenameValueLookup = new HashMap(64);
        filenameValueLookup.put(Character.valueOf('='), -1);
        for (ii = 0; ii < filenameCharLookup.length; ++ii) {
            filenameValueLookup.put(Character.valueOf(filenameCharLookup[ii]), ii);
        }
    }

    private class Decoder {
        private InputStream _in;
        private OutputStream _out;

        public Decoder(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
        }

        public void decode() {
            try {
                do {
                    Codec.skipIfSeparator(this._in, Base64Codec.this._separator);
                } while (this.decodeGroup());
            }
            catch (CodecException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CodecException("unable to decode", ex);
            }
        }

        private boolean decodeGroup() throws IOException {
            int e1 = this.next(true);
            if (e1 < 0) {
                return false;
            }
            int e2 = this.next(!Base64Codec.this._paddingRequired);
            int e3 = this.next(!Base64Codec.this._paddingRequired);
            int e4 = this.next(!Base64Codec.this._paddingRequired);
            this._out.write(e1 << 2 | (e2 & 0x30) >> 4);
            if (e3 < 0) {
                return false;
            }
            this._out.write((e2 & 0xF) << 4 | (e3 & 0x3C) >> 2);
            if (e4 < 0) {
                return false;
            }
            this._out.write((e3 & 3) << 6 | e4);
            return true;
        }

        private int next(boolean eofAllowed) throws IOException {
            int b = Codec.nextNonWhitespace(this._in);
            if (b < 0) {
                if (eofAllowed) {
                    return -1;
                }
                throw new CodecException("unexpected EOF");
            }
            if (b == Base64Codec.this._padChar) {
                return -1;
            }
            Integer val = (Integer)Base64Codec.this._valueLookup.get(Character.valueOf((char)b));
            if (val == null) {
                throw new InvalidSourceByteException(b);
            }
            return val;
        }
    }

    private class Encoder {
        private InputStream _in;
        private OutputStream _out;
        private int _breakCount;

        public Encoder(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
        }

        public void encode() {
            try {
                while (true) {
                    int b1 = this._in.read();
                    int b2 = this._in.read();
                    int b3 = this._in.read();
                    if (b1 < 0) {
                        return;
                    }
                    this.insertBreakIfNeeded();
                    this.encodeGroup(b1, b2, b3);
                }
            }
            catch (CodecException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CodecException("unable to encode", ex);
            }
        }

        private void insertBreakIfNeeded() throws IOException {
            if (Base64Codec.this._separator != null && this._breakCount >= Base64Codec.this._lineLength) {
                this._out.write(Base64Codec.this._separator);
                this._breakCount = 0;
            }
        }

        private boolean encodeGroup(int b1, int b2, int b3) throws IOException {
            int e1 = b1 >>> 2;
            int e2 = (b1 & 3) << 4;
            if (b2 >= 0) {
                e2 |= b2 >> 4;
            }
            int e3 = (b2 & 0xF) << 2;
            if (b3 >= 0) {
                e3 |= b3 >> 6;
            }
            int e4 = b3 & 0x3F;
            this._out.write(Base64Codec.this._charLookup[e1]);
            this._out.write(Base64Codec.this._charLookup[e2]);
            this.writeOrPad(b2, e3);
            this.writeOrPad(b3, e4);
            this._breakCount += 4;
            return true;
        }

        private void writeOrPad(int byteVal, int encVal) throws IOException {
            if (byteVal >= 0) {
                this._out.write(Base64Codec.this._charLookup[encVal]);
            } else if (Base64Codec.this._padChar != '\u0000') {
                this._out.write(Base64Codec.this._padChar);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        UNBROKEN(Integer.MAX_VALUE, null, Base64Codec.access$000(), Base64Codec.access$100(), '='),
        RFC1421(64, new byte[]{13, 10}, Base64Codec.access$000(), Base64Codec.access$100(), '='),
        FILENAME(Integer.MAX_VALUE, null, Base64Codec.access$200(), Base64Codec.access$300(), '\u0000');

        private final int _lineLength;
        private final byte[] _separator;
        private final char[] _charLookup;
        private final HashMap<Character, Integer> _valueLookup;
        private final char _padChar;

        private Option(int lineLength, byte[] separator, char[] charLookup, HashMap<Character, Integer> valueLookup, char padChar) {
            this._lineLength = lineLength;
            this._separator = separator;
            this._charLookup = charLookup;
            this._valueLookup = valueLookup;
            this._padChar = padChar;
        }
    }
}

