/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearch {
    public static <T> int search(Accessor<T> accessor, T value) {
        int min = accessor.start();
        int max = accessor.end() - 1;
        if (max < min) {
            return -1;
        }
        while (max > min) {
            int mid = min + (max - min) / 2;
            if (accessor.compare(value, mid) <= 0) {
                max = mid;
                continue;
            }
            min = mid + 1;
        }
        int rslt = accessor.compare(value, min);
        return rslt == 0 ? min : (rslt < 0 ? -min - 1 : -(min + 1) - 1);
    }

    public static <T> int search(int[] index, T value, IndexedComparator<T> cmp) {
        return BinarySearch.search(new IndexedAccessor<T>(index, cmp), value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexedAccessor<T>
    implements Accessor<T> {
        private int[] _array;
        private IndexedComparator<T> _cmp;

        public IndexedAccessor(int[] array, IndexedComparator<T> cmp) {
            this._array = array;
            this._cmp = cmp;
        }

        @Override
        public int start() {
            return 0;
        }

        @Override
        public int end() {
            return this._array.length;
        }

        @Override
        public int compare(T value, int index) {
            return this._cmp.compare(value, this._array[index]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IndexedComparator<T> {
        public int compare(T var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Accessor<T> {
        public int start();

        public int end();

        public int compare(T var1, int var2);
    }
}

