/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class IOUtil {
    public static void closeQuietly(Closeable closable) {
        if (closable == null) {
            return;
        }
        try {
            closable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        long total = 0L;
        int read = 0;
        byte[] data = new byte[8192];
        while ((read = in.read(data)) >= 0) {
            out.write(data, 0, read);
            total += (long)read;
        }
        return total;
    }

    public static InputStream openFile(File file) throws IOException {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            stream = new BufferedInputStream(stream);
            if (file.getName().endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            return stream;
        }
        catch (IOException ex) {
            IOUtil.closeQuietly(stream);
            throw ex;
        }
    }

    public static InputStream openFile(String fileName) throws IOException {
        return IOUtil.openFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String prefix, long size) throws IOException {
        File file = File.createTempFile(prefix, null);
        file.deleteOnExit();
        if (size == 0L) {
            return file;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.setLength(size);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(raf);
            throw throwable;
        }
        IOUtil.closeQuietly(raf);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(InputStream in, String prefix) throws IOException {
        File file = null;
        FileOutputStream fos = null;
        try {
            file = IOUtil.createTempFile(prefix, 0L);
            fos = new FileOutputStream(file);
            IOUtil.copy(in, fos);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(fos);
            throw throwable;
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(fos);
        return file;
    }

    public static int readFully(InputStream in, byte[] dest) throws IOException {
        int off = 0;
        int cc = 0;
        for (int len = dest.length; len > 0 && (cc = in.read(dest, off, len)) >= 0; len -= cc) {
            off += cc;
        }
        return off;
    }

    public static long skipFully(InputStream in, long bytesToSkip) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        long bytesSkipped = 0L;
        while (bytesToSkip > 0L && (len = (int)Math.min((long)buf.length, bytesToSkip)) != 0) {
            int count = in.read(buf, 0, len);
            if (count < 0) {
                return bytesSkipped;
            }
            bytesSkipped += (long)count;
            bytesToSkip -= (long)count;
        }
        return bytesSkipped;
    }
}

