/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml;

import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.ParseUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.XmlException;
import eu.ha3.matmos.lib.net.sf.practicalxml.util.ExceptionErrorHandler;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaUtil {
    private static final String NS_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String EL_SCHEMA = "schema";
    private static final String EL_IMPORT = "import";
    private static final String ATTR_TARGET_NS = "targetNamespace";
    private static final String ATTR_IMPORT_NS = "namespace";
    private static final String ATTR_IMPORT_LOC = "schemaLocation";

    public static synchronized SchemaFactory newFactory(ErrorHandler errHandler) {
        SchemaFactory fact = SchemaFactory.newInstance(NS_SCHEMA);
        fact.setErrorHandler(errHandler);
        return fact;
    }

    public static Schema newSchema(InputSource ... sources) {
        return SchemaUtil.newSchema(SchemaUtil.newFactory(new ExceptionErrorHandler()), sources);
    }

    public static Schema newSchema(SchemaFactory factory, InputSource ... sources) {
        return SchemaUtil.newSchema(factory, SchemaUtil.parseSources(sources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema newSchema(SchemaFactory factory, Document ... sources) {
        try {
            SchemaFactory schemaFactory = factory;
            synchronized (schemaFactory) {
                return factory.newSchema(SchemaUtil.toDOMSources(sources));
            }
        }
        catch (SAXException e) {
            throw new XmlException("unable to generate schema", e);
        }
    }

    public static Document[] combineSchemas(InputSource ... sources) {
        return new SchemaManager(SchemaUtil.parseSources(sources)).buildOutput();
    }

    public static Document[] parseSources(InputSource[] sources) {
        int ii;
        if (sources.length == 0) {
            throw new IllegalArgumentException("must specify at least one source");
        }
        Document[] result = new Document[sources.length];
        for (ii = 0; ii < sources.length; ++ii) {
            try {
                result[ii] = ParseUtil.parse(sources[ii]);
                continue;
            }
            catch (XmlException ee) {
                throw new XmlException("unable to parse source " + ii, ee.getCause());
            }
        }
        for (ii = 0; ii < result.length; ++ii) {
            if (DomUtil.isNamed(result[ii].getDocumentElement(), NS_SCHEMA, EL_SCHEMA)) continue;
            throw new XmlException("source " + ii + " does not appear to be an XSD");
        }
        return result;
    }

    private static DOMSource[] toDOMSources(Document[] sources) {
        DOMSource[] result = new DOMSource[sources.length];
        for (int ii = 0; ii < sources.length; ++ii) {
            result[ii] = new DOMSource(sources[ii]);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SchemaComparator
    implements Comparator<Document>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SchemaComparator() {
        }

        @Override
        public int compare(Document o1, Document o2) {
            Element root2;
            String namespace2;
            if (o1 == o2) {
                return 0;
            }
            Element root1 = o1.getDocumentElement();
            String namespace1 = root1.getAttribute(SchemaUtil.ATTR_TARGET_NS);
            if (namespace1.equals(namespace2 = (root2 = o2.getDocumentElement()).getAttribute(SchemaUtil.ATTR_TARGET_NS))) {
                return 0;
            }
            if ("".equals(namespace1)) {
                return 1;
            }
            if ("".equals(namespace2)) {
                return -1;
            }
            if (this.isImportedBy(namespace1, root2)) {
                return -1;
            }
            if (this.isImportedBy(namespace2, root1)) {
                return 1;
            }
            return namespace1.compareTo(namespace2);
        }

        private boolean isImportedBy(String namespace, Element root) {
            for (Element imp : DomUtil.getChildren(root, SchemaUtil.NS_SCHEMA, SchemaUtil.EL_IMPORT)) {
                if (!namespace.equals(imp.getAttribute(SchemaUtil.ATTR_IMPORT_NS))) continue;
                return true;
            }
            return false;
        }
    }

    static class SchemaManager {
        private HashMap<String, Document> _documents = new HashMap();

        public SchemaManager(Document[] sources) {
            for (int ii = 0; ii < sources.length; ++ii) {
                String srcNamespace = sources[ii].getDocumentElement().getAttribute(SchemaUtil.ATTR_TARGET_NS);
                Document existing = this._documents.get(srcNamespace);
                if (existing != null) {
                    this.merge(existing, sources[ii]);
                    continue;
                }
                this._documents.put(srcNamespace, sources[ii]);
            }
        }

        public Document[] buildOutput() {
            TreeSet<Document> ordered = new TreeSet<Document>(new SchemaComparator());
            for (Document doc : this._documents.values()) {
                ordered.add(this.rebuildImports(doc));
            }
            return ordered.toArray(new Document[ordered.size()]);
        }

        protected void merge(Document dst, Document src) {
            Element dstRoot = dst.getDocumentElement();
            Element srcRoot = src.getDocumentElement();
            for (Element child : DomUtil.getChildren(srcRoot)) {
                Node tmp = dst.importNode(child, true);
                dstRoot.appendChild(tmp);
            }
        }

        protected Document rebuildImports(Document doc) {
            HashMap<String, String> imports = new HashMap<String, String>();
            Element root = doc.getDocumentElement();
            for (Element imp : DomUtil.getChildren(root, SchemaUtil.NS_SCHEMA, SchemaUtil.EL_IMPORT)) {
                String namespace = imp.getAttribute(SchemaUtil.ATTR_IMPORT_NS);
                String location = imp.getAttribute(SchemaUtil.ATTR_IMPORT_LOC);
                if (this._documents.containsKey(namespace)) {
                    location = null;
                }
                imports.put(namespace, location);
                root.removeChild(imp);
            }
            for (String namespace : imports.keySet()) {
                String location = (String)imports.get(namespace);
                Element newImport = doc.createElementNS(SchemaUtil.NS_SCHEMA, SchemaUtil.EL_IMPORT);
                newImport.setAttribute(SchemaUtil.ATTR_IMPORT_NS, namespace);
                if (location != null) {
                    newImport.setAttribute(SchemaUtil.ATTR_IMPORT_LOC, location);
                }
                root.insertBefore(newImport, root.getFirstChild());
            }
            return doc;
        }
    }
}

