/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean;

import eu.ha3.matmos.lib.net.sf.kdgcommons.bean.IntrospectionCache;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.Base64Codec;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.HexCodec;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.ObjectUtil;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.XmlUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.ConversionException;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean.Xml2BeanOptions;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.ConversionUtils;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.JavaStringConversions;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2BeanConverter {
    private DateFormat _defaultDateFormat;
    private DateFormat _sqlDateFormat;
    private DateFormat _sqlTimeFormat;
    private DateFormat _sqlTimestampFormat;
    private EnumSet<Xml2BeanOptions> _options = EnumSet.noneOf(Xml2BeanOptions.class);
    private IntrospectionCache _introspections;
    private JavaStringConversions _converter;
    List<ConversionException> _deferredExceptions;

    public Xml2BeanConverter(Xml2BeanOptions ... options) {
        for (Xml2BeanOptions option : options) {
            this._options.add(option);
            if (option != Xml2BeanOptions.DEFER_EXCEPTIONS) continue;
            this._deferredExceptions = new ArrayList<ConversionException>();
        }
        this._introspections = new IntrospectionCache(this._options.contains((Object)Xml2BeanOptions.CACHE_INTROSPECTIONS));
        this._converter = new JavaStringConversions(this._options.contains((Object)Xml2BeanOptions.EXPECT_XSD_FORMAT));
    }

    public <T> T convert(Element elem, Class<T> klass) {
        return klass.cast(this.convertWithoutCast(elem, klass));
    }

    public List<ConversionException> getDeferredExceptions() {
        if (this._deferredExceptions != null) {
            return Collections.unmodifiableList(this._deferredExceptions);
        }
        return Collections.emptyList();
    }

    public Object convertWithoutCast(Element elem, Class<?> klass) {
        this.validateXsiType(elem, klass);
        if (this.isAllowableNull(elem)) {
            return null;
        }
        Object obj = this.tryConvertSimple(elem, klass);
        if (obj == null) {
            obj = this.tryConvertAsEnum(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsArray(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsSimpleCollection(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsMap(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsDate(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsCalendar(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsBean(elem, klass);
        }
        return obj;
    }

    private boolean isAllowableNull(Element elem) {
        ConversionException ex;
        String text = this.getText(elem, false);
        if (text != null || this.hasElementChildren(elem)) {
            return false;
        }
        for (Attr attr : DomUtil.getAttributes(elem)) {
            if (!this.isConvertableAttribute(elem, attr)) continue;
            return false;
        }
        if (this._options.contains((Object)Xml2BeanOptions.REQUIRE_XSI_NIL) && !ConversionUtils.getXsiNil(elem) && !this.exceptionDeferred(ex = new ConversionException("missing/false xsi:nil", elem))) {
            throw ex;
        }
        return true;
    }

    private Object tryConvertSimple(Element elem, Class<?> klass) {
        if (!this._converter.isConvertableToString(klass)) {
            return null;
        }
        return this._converter.parse(this.getText(elem, true), klass);
    }

    private Object tryConvertAsEnum(Element elem, Class<?> klass) {
        if (!Enum.class.isAssignableFrom(klass)) {
            return null;
        }
        try {
            return new EnumParser(this._options.contains((Object)Xml2BeanOptions.ENUM_AS_STRING_VALUE)).parse(elem, klass);
        }
        catch (ConversionException ex) {
            if (!this.exceptionDeferred(ex)) {
                throw ex;
            }
            return null;
        }
    }

    private Object tryConvertAsArray(Element elem, Class<?> klass) {
        byte[] obj;
        Class<?> childKlass = klass.getComponentType();
        if (childKlass == null) {
            return null;
        }
        if (childKlass == Byte.TYPE && (obj = this.tryConvertAsEncodedByteArray(elem)) != null) {
            return obj;
        }
        List<Element> children = DomUtil.getChildren(elem);
        Object result = Array.newInstance(childKlass, children.size());
        int idx = 0;
        for (Element child : children) {
            Array.set(result, idx++, this.convertWithoutCast(child, childKlass));
        }
        return result;
    }

    private byte[] tryConvertAsEncodedByteArray(Element elem) {
        String text = DomUtil.getText(elem);
        if (this._options.contains((Object)Xml2BeanOptions.BYTE_ARRAYS_AS_BASE64)) {
            return new Base64Codec().toBytes(text);
        }
        if (this._options.contains((Object)Xml2BeanOptions.BYTE_ARRAYS_AS_HEX)) {
            return new HexCodec().toBytes(text);
        }
        return null;
    }

    private Object tryConvertAsSimpleCollection(Element elem, Class<?> klass) {
        Collection<Object> result = this.instantiateCollection(klass);
        if (result == null) {
            return null;
        }
        List<Element> children = DomUtil.getChildren(elem);
        for (Element child : children) {
            try {
                Class<?> childClass = this.getCollectionElementClass(child);
                result.add(this.convertWithoutCast(child, childClass));
            }
            catch (ConversionException ex) {
                if (this.exceptionDeferred(ex)) continue;
                throw ex;
            }
        }
        return result;
    }

    private Object tryConvertAsMap(Element elem, Class<?> klass) {
        Map<Object, Object> result = this.instantiateMap(klass);
        if (result == null) {
            return null;
        }
        List<Element> children = DomUtil.getChildren(elem);
        for (Element child : children) {
            String key = ConversionUtils.getAttribute(child, "key");
            if (StringUtil.isEmpty(key)) {
                key = DomUtil.getLocalName(child);
            }
            Class<?> childClass = this.getCollectionElementClass(child);
            result.put(key, this.convertWithoutCast(child, childClass));
        }
        return result;
    }

    private Object tryConvertAsDate(Element elem, Class<?> klass) {
        if (!java.util.Date.class.isAssignableFrom(klass)) {
            return null;
        }
        String str = this.getText(elem, true);
        java.util.Date date = this._options.contains((Object)Xml2BeanOptions.EXPECT_XSD_FORMAT) ? XmlUtil.parseXsdDatetime(str) : this.parseDateDefault(klass, str);
        return klass == java.util.Date.class ? date : this.instantiateDateSubclass(klass, date.getTime());
    }

    private Object tryConvertAsCalendar(Element elem, Class<?> klass) {
        if (!Calendar.class.isAssignableFrom(klass)) {
            return null;
        }
        Long millis = null;
        TimeZone zone = null;
        int firstDayOfWeek = -1;
        int minDaysInFirstWeek = -1;
        for (Element child : DomUtil.getChildren(elem)) {
            String childName = DomUtil.getLocalName(child);
            String childText = this.getText(child, true);
            if (childName.equals("millis")) {
                millis = (Long)this._converter.parse(childText, Long.class);
                continue;
            }
            if (childName.equals("timezone")) {
                zone = (TimeZone)this._converter.parse(childText, TimeZone.class);
                continue;
            }
            if (childName.equals("firstDayOfWeek")) {
                firstDayOfWeek = Integer.parseInt(childText);
                continue;
            }
            if (!childName.equals("minimumDaysInFirstWeek")) continue;
            minDaysInFirstWeek = Integer.parseInt(childText);
        }
        Calendar cal = Calendar.getInstance(zone);
        cal.setTimeInMillis(millis);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.setMinimalDaysInFirstWeek(minDaysInFirstWeek);
        return cal;
    }

    private Object tryConvertAsBean(Element elem, Class<?> klass) {
        Object bean = this.instantiateBean(elem, klass);
        if (bean != null) {
            this.convertAttributes(elem, bean);
            this.convertChildren(elem, bean);
        }
        return bean;
    }

    private String getText(Element elem, boolean validateTextOnly) {
        ConversionException ex;
        if (validateTextOnly && this.hasElementChildren(elem) && !this.exceptionDeferred(ex = new ConversionException("unexpected child elements", elem))) {
            throw ex;
        }
        String text = DomUtil.getText(elem);
        if (StringUtil.isBlank(text) && this._options.contains((Object)Xml2BeanOptions.EMPTY_IS_NULL)) {
            text = null;
        }
        return text;
    }

    private void validateXsiType(Element elem, Class<?> klass) {
        block3: {
            try {
                if (this._options.contains((Object)Xml2BeanOptions.REQUIRE_TYPE)) {
                    TypeUtils.validateType(elem, klass);
                }
            }
            catch (ConversionException ex) {
                if (this.exceptionDeferred(ex)) break block3;
                throw ex;
            }
        }
    }

    private Class<?> getCollectionElementClass(Element child) {
        Class<?> childClass = TypeUtils.getType(child, false);
        return childClass != null ? childClass : String.class;
    }

    private boolean hasElementChildren(Element elem) {
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return true;
        }
        return false;
    }

    private boolean isConvertableAttribute(Element elem, Attr attr) {
        String attrNS;
        if (!this._options.contains((Object)Xml2BeanOptions.CONVERT_ATTRIBUTES) && !this._options.contains((Object)Xml2BeanOptions.CONVERT_ATTRIBUTES_MATCH_NAMESPACE)) {
            return false;
        }
        String elemNS = elem.getNamespaceURI() != null ? elem.getNamespaceURI() : "";
        String string = attrNS = attr.getNamespaceURI() != null ? attr.getNamespaceURI() : "";
        if (this._options.contains((Object)Xml2BeanOptions.CONVERT_ATTRIBUTES_MATCH_NAMESPACE) && !elemNS.equals(attrNS)) {
            return false;
        }
        return !attrNS.equals("http://www.w3.org/2001/XMLSchema-instance") && !attrNS.equals("http://practicalxml.sourceforge.net/Converter");
    }

    private void convertAttributes(Element elem, Object bean) {
        Class<?> klass = bean.getClass();
        List<Attr> attrs = DomUtil.getAttributes(elem);
        for (Attr attr : attrs) {
            Object attrValue;
            Class<?> attrClass;
            Method setter;
            if (!this.isConvertableAttribute(elem, attr) || (setter = this.getSetterMethod(klass, elem, DomUtil.getLocalName(attr))) == null || !this._converter.isConvertableToString(attrClass = setter.getParameterTypes()[0]) || (attrValue = this._converter.parse(attr.getValue(), attrClass)) == null) continue;
            this.invokeSetter(elem, bean, setter, attrValue);
        }
    }

    private void convertChildren(Element elem, Object bean) {
        Class<?> klass = bean.getClass();
        List<Element> children = DomUtil.getChildren(elem);
        for (Element child : children) {
            Method setter = this.getSetterMethod(klass, child, DomUtil.getLocalName(child));
            if (setter == null) continue;
            Class<?> childClass = setter.getParameterTypes()[0];
            Object childValue = this.convertWithoutCast(child, childClass);
            this.invokeSetter(elem, bean, setter, childValue);
        }
    }

    private Method getSetterMethod(Class<?> beanKlass, Element elem, String propName) {
        ConversionException ex;
        Method setter = this._introspections.lookup(beanKlass).setter(propName);
        if (setter == null && !this._options.contains((Object)Xml2BeanOptions.IGNORE_MISSING_PROPERTIES) && !this.exceptionDeferred(ex = new ConversionException("can't find property setter: " + propName, elem))) {
            throw ex;
        }
        return setter;
    }

    private synchronized java.util.Date parseDateDefault(Class<?> klass, String str) {
        try {
            if (Date.class.isAssignableFrom(klass)) {
                if (this._sqlDateFormat == null) {
                    this._sqlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
                return this._sqlDateFormat.parse(str);
            }
            if (Time.class.isAssignableFrom(klass)) {
                if (this._sqlTimeFormat == null) {
                    this._sqlTimeFormat = new SimpleDateFormat("HH:mm:ss");
                }
                return this._sqlTimeFormat.parse(str);
            }
            if (Timestamp.class.isAssignableFrom(klass)) {
                if (this._sqlTimestampFormat == null) {
                    this._sqlTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
                return this._sqlTimestampFormat.parse(str);
            }
            if (this._defaultDateFormat == null) {
                this._defaultDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            }
            return this._defaultDateFormat.parse(str);
        }
        catch (ParseException ee) {
            throw new ConversionException("unable to parse: " + str, ee);
        }
    }

    private Object instantiateDateSubclass(Class<?> klass, long millis) {
        try {
            Constructor<?> ctor = klass.getConstructor(Long.TYPE);
            return ctor.newInstance(millis);
        }
        catch (Exception ex) {
            throw new ConversionException("unable to instantiate: " + klass.getName(), ex);
        }
    }

    private Collection<Object> instantiateCollection(Class<?> klass) {
        if (SortedSet.class.isAssignableFrom(klass)) {
            return new TreeSet<Object>();
        }
        if (Set.class.isAssignableFrom(klass)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(klass)) {
            return new ArrayList<Object>();
        }
        if (Collection.class.isAssignableFrom(klass)) {
            return new ArrayList<Object>();
        }
        return null;
    }

    private Map<Object, Object> instantiateMap(Class<?> klass) {
        if (SortedMap.class.isAssignableFrom(klass)) {
            return new TreeMap<Object, Object>();
        }
        if (Map.class.isAssignableFrom(klass)) {
            return new HashMap<Object, Object>();
        }
        return null;
    }

    private Object instantiateBean(Element elem, Class<?> klass) {
        try {
            return klass.newInstance();
        }
        catch (Exception ee) {
            ConversionException ex = new ConversionException("unable to instantiate bean", elem, (Throwable)ee);
            if (!this.exceptionDeferred(ex)) {
                throw ex;
            }
            return null;
        }
    }

    private void invokeSetter(Element elem, Object bean, Method setter, Object value) {
        block2: {
            try {
                setter.invoke(bean, value);
            }
            catch (Exception ee) {
                ConversionException ex = new ConversionException("unable to invoke setter: " + setter.getName(), elem, (Throwable)ee);
                if (this.exceptionDeferred(ex)) break block2;
                throw ex;
            }
        }
    }

    private boolean exceptionDeferred(ConversionException ex) {
        if (this._deferredExceptions != null) {
            this._deferredExceptions.add(ex);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumParser {
        private boolean _matchByStringValue;

        public EnumParser(boolean matchByStringValue) {
            this._matchByStringValue = matchByStringValue;
        }

        public Object parse(Element elem, Class<?> klass) {
            String text = DomUtil.getText(elem);
            try {
                if (this._matchByStringValue) {
                    return this.matchStringValue(klass, text);
                }
                return this.matchName(klass, text);
            }
            catch (ConversionException ee) {
                throw new ConversionException(ee.getMessage(), elem);
            }
            catch (InvocationTargetException ee) {
                throw new ConversionException("unable to parse enum " + klass.getName() + ": \"" + text + "\"", elem, ee.getTargetException());
            }
            catch (Exception ee) {
                throw new ConversionException("unable to parse enum " + klass.getName() + ": \"" + text + "\"", elem, (Throwable)ee);
            }
        }

        private Object matchStringValue(Class<?> klass, String text) throws Exception {
            Object[] values;
            Method method = klass.getMethod("values", new Class[0]);
            for (Object value : values = (Object[])method.invoke(null, new Object[0])) {
                if (!ObjectUtil.equals(text, String.valueOf(value))) continue;
                return value;
            }
            throw new ConversionException("unable to parse enum " + klass.getName() + ": \"" + text + "\"");
        }

        private Object matchName(Class<?> klass, String text) throws Exception {
            Method method = klass.getMethod("valueOf", Class.class, String.class);
            return method.invoke(null, klass, text);
        }
    }
}

